/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalAggregation
implements Aggregation,
NamedWriteable {
    protected final String name;
    protected final Map<String, Object> metadata;
    private List<PipelineAggregator> pipelineAggregatorsForBwcSerialization;

    protected InternalAggregation(String name, Map<String, Object> metadata) {
        this.name = name;
        this.metadata = metadata;
    }

    public final void mergePipelineTreeForBWCSerialization(PipelineAggregator.PipelineTree pipelineTree) {
        if (this.pipelineAggregatorsForBwcSerialization != null) {
            return;
        }
        this.pipelineAggregatorsForBwcSerialization = pipelineTree.aggregators();
        this.forEachBucket(bucketAggs -> bucketAggs.mergePipelineTreeForBWCSerialization(pipelineTree));
    }

    protected InternalAggregation(StreamInput in) throws IOException {
        this.name = in.readString();
        this.metadata = in.readMap();
        if (in.getVersion().before(Version.V_7_8_0)) {
            in.readNamedWriteableList(PipelineAggregator.class);
        }
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeGenericValue(this.metadata);
        if (out.getVersion().before(Version.V_7_8_0)) {
            assert (this.pipelineAggregatorsForBwcSerialization != null) : "serializing to pre-7.8.0 versions should have called mergePipelineTreeForBWCSerialization";
            out.writeNamedWriteableList(this.pipelineAggregatorsForBwcSerialization);
        }
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public String getName() {
        return this.name;
    }

    public InternalAggregation copyWithRewritenBuckets(Function<InternalAggregations, InternalAggregations> rewriter) {
        throw new IllegalStateException("Aggregation [" + this.getName() + "] must be a bucket aggregation but was [" + this.getWriteableName() + "]");
    }

    public void forEachBucket(Consumer<InternalAggregations> consumer) {
    }

    public InternalAggregation reducePipelines(InternalAggregation reducedAggs, ReduceContext reduceContext, PipelineAggregator.PipelineTree pipelinesForThisAgg) {
        assert (reduceContext.isFinalReduce());
        for (PipelineAggregator pipelineAggregator : pipelinesForThisAgg.aggregators()) {
            reducedAggs = pipelineAggregator.reduce(reducedAggs, reduceContext);
        }
        return reducedAggs;
    }

    public abstract InternalAggregation reduce(List<InternalAggregation> var1, ReduceContext var2);

    protected abstract boolean mustReduceOnSingleInternalAgg();

    public boolean isMapped() {
        return true;
    }

    public Object getProperty(String path) {
        AggregationPath aggPath = AggregationPath.parse(path);
        return this.getProperty(aggPath.getPathElementsAsStringList());
    }

    public abstract Object getProperty(List<String> var1);

    protected static int readSize(StreamInput in) throws IOException {
        int size = in.readVInt();
        return size == 0 ? Integer.MAX_VALUE : size;
    }

    protected static void writeSize(int size, StreamOutput out) throws IOException {
        if (size == Integer.MAX_VALUE) {
            size = 0;
        }
        out.writeVInt(size);
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Deprecated
    public List<PipelineAggregator> pipelineAggregatorsForBwcSerialization() {
        return this.pipelineAggregatorsForBwcSerialization;
    }

    @Override
    public String getType() {
        return this.getWriteableName();
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (params.paramAsBoolean("typed_keys", false)) {
            builder.startObject(String.join((CharSequence)"#", this.getType(), this.getName()));
        } else {
            builder.startObject(this.getName());
        }
        if (this.metadata != null) {
            builder.field(Aggregation.CommonFields.META.getPreferredName());
            builder.map(this.metadata);
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(this.name, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        InternalAggregation other = (InternalAggregation)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.metadata, other.metadata);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public double sortValue(String key) {
        throw new IllegalArgumentException("Can't sort a [" + this.getType() + "] aggregation [" + this.getName() + "]");
    }

    public double sortValue(AggregationPath.PathElement head, Iterator<AggregationPath.PathElement> tail) {
        throw new IllegalArgumentException("Can't sort by a descendant of a [" + this.getType() + "] aggregation [" + head + "]");
    }

    public static class ReduceContext {
        private final BigArrays bigArrays;
        private final ScriptService scriptService;
        private final IntConsumer multiBucketConsumer;
        private final PipelineAggregator.PipelineTree pipelineTreeRoot;
        private final Supplier<Boolean> isCanceled;
        private final Supplier<PipelineAggregator.PipelineTree> pipelineTreeForBwcSerialization;

        public static ReduceContext forPartialReduction(BigArrays bigArrays, ScriptService scriptService, Supplier<PipelineAggregator.PipelineTree> pipelineTreeForBwcSerialization, Supplier<Boolean> isCanceled) {
            return new ReduceContext(bigArrays, scriptService, s -> {}, null, pipelineTreeForBwcSerialization, isCanceled);
        }

        public static ReduceContext forFinalReduction(BigArrays bigArrays, ScriptService scriptService, IntConsumer multiBucketConsumer, PipelineAggregator.PipelineTree pipelineTreeRoot, Supplier<Boolean> isCanceled) {
            return new ReduceContext(bigArrays, scriptService, multiBucketConsumer, Objects.requireNonNull(pipelineTreeRoot, "prefer EMPTY to null"), () -> pipelineTreeRoot, isCanceled);
        }

        private ReduceContext(BigArrays bigArrays, ScriptService scriptService, IntConsumer multiBucketConsumer, PipelineAggregator.PipelineTree pipelineTreeRoot, Supplier<PipelineAggregator.PipelineTree> pipelineTreeForBwcSerialization, Supplier<Boolean> isCanceled) {
            this.bigArrays = bigArrays;
            this.scriptService = scriptService;
            this.multiBucketConsumer = multiBucketConsumer;
            this.pipelineTreeRoot = pipelineTreeRoot;
            this.pipelineTreeForBwcSerialization = pipelineTreeForBwcSerialization;
            this.isCanceled = isCanceled;
        }

        public boolean isFinalReduce() {
            return this.pipelineTreeRoot != null;
        }

        public BigArrays bigArrays() {
            return this.bigArrays;
        }

        public ScriptService scriptService() {
            return this.scriptService;
        }

        public PipelineAggregator.PipelineTree pipelineTreeRoot() {
            return this.pipelineTreeRoot;
        }

        public Supplier<PipelineAggregator.PipelineTree> pipelineTreeForBwcSerialization() {
            return this.pipelineTreeForBwcSerialization;
        }

        public void consumeBucketsAndMaybeBreak(int size) {
            if (this.isCanceled.get().booleanValue()) {
                throw new TaskCancelledException("Cancelled");
            }
            this.multiBucketConsumer.accept(size);
        }

        public Supplier<Boolean> isCanceled() {
            return this.isCanceled;
        }
    }

    public static interface ReduceContextBuilder {
        public ReduceContext forPartialReduction();

        public ReduceContext forFinalReduction();
    }
}

