/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.search.OpenPointInTimeAction;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestOpenPointInTimeAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "open_point_in_time";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_pit"), new RestHandler.Route(RestRequest.Method.POST, "/_pit"));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        OpenPointInTimeRequest openRequest = new OpenPointInTimeRequest(indices);
        openRequest.indicesOptions(IndicesOptions.fromRequest(request, OpenPointInTimeRequest.DEFAULT_INDICES_OPTIONS));
        openRequest.routing(request.param("routing"));
        openRequest.preference(request.param("preference"));
        openRequest.keepAlive(TimeValue.parseTimeValue((String)request.param("keep_alive"), null, (String)"keep_alive"));
        return channel -> client.execute(OpenPointInTimeAction.INSTANCE, openRequest, new RestToXContentListener((RestChannel)channel));
    }
}

