/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeAction;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportResizeAction
extends TransportMasterNodeAction<ResizeRequest, ResizeResponse> {
    private static final Logger logger = LogManager.getLogger(TransportResizeAction.class);
    private final MetadataCreateIndexService createIndexService;
    private final Client client;

    @Inject
    public TransportResizeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        this("indices:admin/resize", transportService, clusterService, threadPool, createIndexService, actionFilters, indexNameExpressionResolver, client);
    }

    protected TransportResizeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, ResizeRequest::new, indexNameExpressionResolver, ResizeResponse::new, "same");
        this.createIndexService = createIndexService;
        this.client = client;
    }

    @Override
    protected ClusterBlockException checkBlock(ResizeRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getTargetIndexRequest().index());
    }

    @Override
    protected void masterOperation(ResizeRequest resizeRequest, ClusterState state, ActionListener<ResizeResponse> listener) {
        String sourceIndex = this.indexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getSourceIndex());
        String targetIndex = this.indexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getTargetIndexRequest().index());
        IndexMetadata sourceMetadata = state.metadata().index(sourceIndex);
        if (sourceMetadata == null) {
            listener.onFailure(new IndexNotFoundException(sourceIndex));
            return;
        }
        this.client.admin().indices().prepareStats(sourceIndex).clear().setDocs(true).setStore(true).execute(listener.delegateFailure((delegatedListener, indicesStatsResponse) -> {
            CreateIndexClusterStateUpdateRequest updateRequest;
            try {
                StoreStats indexStoreStats = indicesStatsResponse.getPrimaries().store;
                updateRequest = TransportResizeAction.prepareCreateIndexRequest(resizeRequest, sourceMetadata, indexStoreStats, i -> {
                    IndexShardStats shard = indicesStatsResponse.getIndex(sourceIndex).getIndexShards().get(i);
                    return shard == null ? null : shard.getPrimary().getDocs();
                }, targetIndex);
            }
            catch (Exception e) {
                delegatedListener.onFailure(e);
                return;
            }
            this.createIndexService.createIndex(updateRequest, delegatedListener.map(response -> new ResizeResponse(response.isAcknowledged(), response.isShardsAcknowledged(), updateRequest.index())));
        }));
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(ResizeRequest resizeRequest, IndexMetadata sourceMetadata, StoreStats indexStoreStats, IntFunction<DocsStats> perShardDocStats, String targetIndexName) {
        int numShards;
        CreateIndexRequest targetIndex = resizeRequest.getTargetIndexRequest();
        Settings.Builder targetIndexSettingsBuilder = Settings.builder().put(targetIndex.settings()).normalizePrefix("index.");
        targetIndexSettingsBuilder.remove("index.history.uuid");
        Settings targetIndexSettings = targetIndexSettingsBuilder.build();
        ByteSizeValue maxPrimaryShardSize = resizeRequest.getMaxPrimaryShardSize();
        if (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            if (resizeRequest.getResizeType() == ResizeType.SHRINK && maxPrimaryShardSize != null) {
                throw new IllegalArgumentException("Cannot set both index.number_of_shards and max_primary_shard_size for the target index");
            }
            numShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings);
        } else {
            assert (resizeRequest.getResizeType() != ResizeType.SPLIT) : "split must specify the number of shards explicitly";
            if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
                if (maxPrimaryShardSize != null) {
                    long maxPrimaryShardSizeBytes;
                    int sourceIndexShardsNum = sourceMetadata.getNumberOfShards();
                    long sourceIndexStorageBytes = indexStoreStats.getSizeInBytes();
                    long minShardsNum = sourceIndexStorageBytes / (maxPrimaryShardSizeBytes = maxPrimaryShardSize.getBytes());
                    if (minShardsNum * maxPrimaryShardSizeBytes < sourceIndexStorageBytes) {
                        ++minShardsNum;
                    }
                    if (minShardsNum > (long)sourceIndexShardsNum) {
                        logger.info("By setting max_primary_shard_size to [{}], the target index [{}] will contain [{}] shards, which will be greater than [{}] shards in the source index [{}], using [{}] for the shard count of the target index [{}]", (Object)maxPrimaryShardSize.toString(), (Object)targetIndexName, (Object)minShardsNum, (Object)sourceIndexShardsNum, (Object)sourceMetadata.getIndex().getName(), (Object)sourceIndexShardsNum, (Object)targetIndexName);
                        numShards = sourceIndexShardsNum;
                    } else {
                        numShards = TransportResizeAction.calTargetShardsNum(sourceIndexShardsNum, (int)minShardsNum);
                    }
                } else {
                    numShards = 1;
                }
            } else {
                assert (resizeRequest.getResizeType() == ResizeType.CLONE);
                numShards = sourceMetadata.getNumberOfShards();
            }
        }
        for (int i = 0; i < numShards; ++i) {
            if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
                Set<ShardId> shardIds = IndexMetadata.selectShrinkShards(i, sourceMetadata, numShards);
                long count = 0L;
                for (ShardId id : shardIds) {
                    DocsStats docsStats = perShardDocStats.apply(id.id());
                    if (docsStats != null) {
                        count += docsStats.getCount();
                    }
                    if (count <= 0x7FFFFF7FL) continue;
                    throw new IllegalStateException("Can't merge index with more than [2147483519] docs - too many documents in shards " + shardIds);
                }
                continue;
            }
            if (resizeRequest.getResizeType() == ResizeType.SPLIT) {
                Objects.requireNonNull(IndexMetadata.selectSplitShard(i, sourceMetadata, numShards));
                continue;
            }
            Objects.requireNonNull(IndexMetadata.selectCloneShard(i, sourceMetadata, numShards));
        }
        if (IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.exists(targetIndexSettings)) {
            throw new IllegalArgumentException("cannot provide a routing partition size value when resizing an index");
        }
        if (IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(targetIndexSettings)) {
            boolean splitFromSingleShards;
            boolean bl = splitFromSingleShards = resizeRequest.getResizeType() == ResizeType.SPLIT && sourceMetadata.getNumberOfShards() == 1;
            if (!splitFromSingleShards) {
                throw new IllegalArgumentException("cannot provide index.number_of_routing_shards on resize");
            }
        }
        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(sourceMetadata.getSettings()).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(targetIndexSettings) && !IndexSettings.INDEX_SOFT_DELETES_SETTING.get(targetIndexSettings).booleanValue()) {
            throw new IllegalArgumentException("Can't disable [index.soft_deletes.enabled] setting on resize");
        }
        String cause = resizeRequest.getResizeType().name().toLowerCase(Locale.ROOT) + "_index";
        targetIndex.cause(cause);
        Settings.Builder settingsBuilder = Settings.builder().put(targetIndexSettings);
        settingsBuilder.put("index.number_of_shards", numShards);
        targetIndex.settings(settingsBuilder);
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(cause, targetIndex.index(), targetIndexName).ackTimeout(targetIndex.timeout())).masterNodeTimeout(targetIndex.masterNodeTimeout())).settings(targetIndex.settings()).aliases(targetIndex.aliases()).waitForActiveShards(targetIndex.waitForActiveShards()).recoverFrom(sourceMetadata.getIndex()).resizeType(resizeRequest.getResizeType()).copySettings(resizeRequest.getCopySettings() == null ? false : resizeRequest.getCopySettings());
    }

    @Override
    protected String getMasterActionName(DiscoveryNode node) {
        if (node.getVersion().onOrAfter(ResizeAction.COMPATIBILITY_VERSION)) {
            return super.getMasterActionName(node);
        }
        return "indices:admin/shrink";
    }

    protected static int calTargetShardsNum(int sourceIndexShardsNum, int minShardsNum) {
        if (sourceIndexShardsNum <= 0 || minShardsNum <= 0) {
            return 1;
        }
        if (sourceIndexShardsNum % minShardsNum == 0) {
            return minShardsNum;
        }
        int num = (int)Math.floor(Math.sqrt(sourceIndexShardsNum));
        if (minShardsNum >= num) {
            for (int i = num; i >= 1; --i) {
                if (sourceIndexShardsNum % i != 0 || minShardsNum > sourceIndexShardsNum / i) continue;
                return sourceIndexShardsNum / i;
            }
        } else {
            for (int i = 1; i < num; ++i) {
                if (sourceIndexShardsNum % i != 0 || minShardsNum > i) continue;
                return i;
            }
        }
        return sourceIndexShardsNum;
    }
}

