/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.GetSnapshotInfoContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.RepositoryStats;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;

public interface Repository
extends LifecycleComponent {
    public RepositoryMetadata getMetadata();

    public void getSnapshotInfo(GetSnapshotInfoContext var1);

    default public void getSnapshotInfo(SnapshotId snapshotId, final ActionListener<SnapshotInfo> listener) {
        this.getSnapshotInfo(new GetSnapshotInfoContext(Collections.singletonList(snapshotId), true, () -> false, (context, snapshotInfo) -> {
            if (!2.$assertionsDisabled && !Repository.assertSnapshotMetaThread()) {
                throw new AssertionError();
            }
            listener.onResponse((SnapshotInfo)snapshotInfo);
        }, new ActionListener<Void>(){

            @Override
            public void onResponse(Void o) {
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }));
    }

    public Metadata getSnapshotGlobalMetadata(SnapshotId var1);

    public IndexMetadata getSnapshotIndexMetaData(RepositoryData var1, SnapshotId var2, IndexId var3) throws IOException;

    public void getRepositoryData(ActionListener<RepositoryData> var1);

    @Deprecated
    public void initializeSnapshot(SnapshotId var1, List<IndexId> var2, Metadata var3);

    public void finalizeSnapshot(ShardGenerations var1, long var2, Metadata var4, SnapshotInfo var5, Version var6, Function<ClusterState, ClusterState> var7, ActionListener<RepositoryData> var8);

    public void deleteSnapshots(Collection<SnapshotId> var1, long var2, Version var4, ActionListener<RepositoryData> var5);

    public long getSnapshotThrottleTimeInNanos();

    public long getRestoreThrottleTimeInNanos();

    default public RepositoryStats stats() {
        return RepositoryStats.EMPTY_STATS;
    }

    public String startVerification();

    public void endVerification(String var1);

    public void verify(String var1, DiscoveryNode var2);

    public boolean isReadOnly();

    public void snapshotShard(SnapshotShardContext var1);

    public void restoreShard(Store var1, SnapshotId var2, IndexId var3, ShardId var4, RecoveryState var5, ActionListener<Void> var6);

    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId var1, IndexId var2, ShardId var3);

    default public boolean canUpdateInPlace(Settings updatedSettings, Set<String> ignoredSettings) {
        return this.getMetadata().settings().equals(updatedSettings);
    }

    public void updateState(ClusterState var1);

    public void executeConsistentStateUpdate(Function<RepositoryData, ClusterStateUpdateTask> var1, String var2, Consumer<Exception> var3);

    public void cloneShardSnapshot(SnapshotId var1, SnapshotId var2, RepositoryShardId var3, @Nullable String var4, ActionListener<ShardSnapshotResult> var5);

    default public Map<String, Object> adaptUserMetadata(Map<String, Object> userMetadata) {
        return userMetadata;
    }

    public static boolean assertSnapshotMetaThread() {
        String threadName = Thread.currentThread().getName();
        if (!(2.$assertionsDisabled || threadName.contains("[snapshot_meta]") || threadName.startsWith("TEST-"))) {
            throw new AssertionError((Object)("Expected current thread [" + Thread.currentThread() + "] to be a snapshot meta thread."));
        }
        return true;
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface Factory {
        public Repository create(RepositoryMetadata var1) throws Exception;

        default public Repository create(RepositoryMetadata metadata, Function<String, Factory> typeLookup) throws Exception {
            return this.create(metadata);
        }
    }
}

