/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.elasticsearch.Version;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;

public abstract class ParseContext {
    public abstract Iterable<LuceneDocument> nonRootDocuments();

    public abstract void addIgnoredField(String var1);

    public abstract Collection<String> getIgnoredFields();

    public abstract void addToFieldNames(String var1);

    public abstract Collection<String> getFieldNames();

    public abstract MappingParserContext dynamicTemplateParserContext(DateFormatter var1);

    public final ParseContext createCopyToContext() {
        return new FilterParseContext(this){

            @Override
            public boolean isWithinCopyTo() {
                return true;
            }
        };
    }

    public boolean isWithinCopyTo() {
        return false;
    }

    public final ParseContext createMultiFieldContext() {
        return new FilterParseContext(this){

            @Override
            public boolean isWithinMultiFields() {
                return true;
            }
        };
    }

    public final ParseContext createNestedContext(String fullPath) {
        LuceneDocument doc = new LuceneDocument(fullPath, this.doc());
        this.addDoc(doc);
        return this.switchDoc(doc);
    }

    public final ParseContext switchDoc(final LuceneDocument document) {
        return new FilterParseContext(this){

            @Override
            public LuceneDocument doc() {
                return document;
            }
        };
    }

    public final ParseContext overridePath(final ContentPath path) {
        return new FilterParseContext(this){

            @Override
            public ContentPath path() {
                return path;
            }
        };
    }

    @Deprecated
    public final ParseContext switchParser(final XContentParser parser) {
        return new FilterParseContext(this){

            @Override
            public XContentParser parser() {
                return parser;
            }
        };
    }

    public boolean isWithinMultiFields() {
        return false;
    }

    public abstract IndexSettings indexSettings();

    public abstract SourceToParse sourceToParse();

    public abstract ContentPath path();

    public abstract XContentParser parser();

    public abstract LuceneDocument rootDoc();

    public abstract List<LuceneDocument> docs();

    public abstract LuceneDocument doc();

    protected abstract void addDoc(LuceneDocument var1);

    public abstract RootObjectMapper root();

    public abstract MappingLookup mappingLookup();

    public abstract MetadataFieldMapper getMetadataMapper(String var1);

    public abstract IndexAnalyzers indexAnalyzers();

    public abstract Field version();

    public abstract void version(Field var1);

    public abstract SeqNoFieldMapper.SequenceIDFields seqID();

    public abstract void seqID(SeqNoFieldMapper.SequenceIDFields var1);

    public abstract void addDynamicMapper(Mapper var1);

    public abstract ObjectMapper getObjectMapper(String var1);

    public abstract List<Mapper> getDynamicMappers();

    public abstract void addDynamicRuntimeField(RuntimeField var1);

    public abstract List<RuntimeField> getDynamicRuntimeFields();

    public final DynamicTemplate findDynamicTemplate(String fieldName, DynamicTemplate.XContentFieldType matchType) {
        String pathAsString = this.path().pathAsText(fieldName);
        String matchTemplateName = this.sourceToParse().dynamicTemplates().get(pathAsString);
        for (DynamicTemplate template : this.root().dynamicTemplates()) {
            if (!template.match(matchTemplateName, pathAsString, fieldName, matchType)) continue;
            return template;
        }
        if (matchTemplateName != null) {
            throw new MapperParsingException("Can't find dynamic template for dynamic template name [" + matchTemplateName + "] of field [" + pathAsString + "]");
        }
        return null;
    }

    public static class InternalParseContext
    extends ParseContext {
        private final MappingLookup mappingLookup;
        private final IndexSettings indexSettings;
        private final IndexAnalyzers indexAnalyzers;
        private final Function<DateFormatter, MappingParserContext> parserContextFunction;
        private final ContentPath path = new ContentPath(0);
        private final XContentParser parser;
        private final LuceneDocument document;
        private final List<LuceneDocument> documents = new ArrayList<LuceneDocument>();
        private final SourceToParse sourceToParse;
        private final long maxAllowedNumNestedDocs;
        private final List<Mapper> dynamicMappers = new ArrayList<Mapper>();
        private final Set<String> newFieldsSeen = new HashSet<String>();
        private final Map<String, ObjectMapper> dynamicObjectMappers = new HashMap<String, ObjectMapper>();
        private final List<RuntimeField> dynamicRuntimeFields = new ArrayList<RuntimeField>();
        private final Set<String> ignoredFields = new HashSet<String>();
        private final Set<String> fieldNameFields = new HashSet<String>();
        private Field version;
        private SeqNoFieldMapper.SequenceIDFields seqID;
        private long numNestedDocs;
        private boolean docsReversed = false;

        public InternalParseContext(MappingLookup mappingLookup, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, Function<DateFormatter, MappingParserContext> parserContext, SourceToParse source, XContentParser parser) {
            this.mappingLookup = mappingLookup;
            this.indexSettings = indexSettings;
            this.indexAnalyzers = indexAnalyzers;
            this.parserContextFunction = parserContext;
            this.parser = parser;
            this.document = new LuceneDocument();
            this.documents.add(this.document);
            this.version = null;
            this.sourceToParse = source;
            this.maxAllowedNumNestedDocs = this.indexSettings().getMappingNestedDocsLimit();
            this.numNestedDocs = 0L;
        }

        @Override
        public MappingParserContext dynamicTemplateParserContext(DateFormatter dateFormatter) {
            return this.parserContextFunction.apply(dateFormatter);
        }

        @Override
        public IndexSettings indexSettings() {
            return this.indexSettings;
        }

        @Override
        public SourceToParse sourceToParse() {
            return this.sourceToParse;
        }

        @Override
        public ContentPath path() {
            return this.path;
        }

        @Override
        public XContentParser parser() {
            return this.parser;
        }

        @Override
        public LuceneDocument rootDoc() {
            return this.documents.get(0);
        }

        @Override
        public List<LuceneDocument> docs() {
            return this.documents;
        }

        @Override
        public LuceneDocument doc() {
            return this.document;
        }

        @Override
        protected void addDoc(LuceneDocument doc) {
            ++this.numNestedDocs;
            if (this.numNestedDocs > this.maxAllowedNumNestedDocs) {
                throw new MapperParsingException("The number of nested documents has exceeded the allowed limit of [" + this.maxAllowedNumNestedDocs + "]. This limit can be set by changing the [" + MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING.getKey() + "] index level setting.");
            }
            this.documents.add(doc);
        }

        @Override
        public RootObjectMapper root() {
            return this.mappingLookup.getMapping().getRoot();
        }

        @Override
        public MappingLookup mappingLookup() {
            return this.mappingLookup;
        }

        @Override
        public MetadataFieldMapper getMetadataMapper(String mapperName) {
            return this.mappingLookup.getMapping().getMetadataMapperByName(mapperName);
        }

        @Override
        public IndexAnalyzers indexAnalyzers() {
            return this.indexAnalyzers;
        }

        @Override
        public Field version() {
            return this.version;
        }

        @Override
        public void version(Field version) {
            this.version = version;
        }

        @Override
        public SeqNoFieldMapper.SequenceIDFields seqID() {
            return this.seqID;
        }

        @Override
        public void seqID(SeqNoFieldMapper.SequenceIDFields seqID) {
            this.seqID = seqID;
        }

        @Override
        public void addDynamicMapper(Mapper mapper) {
            if (this.mappingLookup.getMapper(mapper.name()) == null && !this.mappingLookup.objectMappers().containsKey(mapper.name()) && this.newFieldsSeen.add(mapper.name())) {
                this.mappingLookup.checkFieldLimit(this.indexSettings.getMappingTotalFieldsLimit(), this.newFieldsSeen.size());
            }
            if (mapper instanceof ObjectMapper) {
                this.dynamicObjectMappers.put(mapper.name(), (ObjectMapper)mapper);
            }
            this.dynamicMappers.add(mapper);
        }

        @Override
        public List<Mapper> getDynamicMappers() {
            return this.dynamicMappers;
        }

        @Override
        public ObjectMapper getObjectMapper(String name) {
            return this.dynamicObjectMappers.get(name);
        }

        @Override
        public void addDynamicRuntimeField(RuntimeField runtimeField) {
            this.dynamicRuntimeFields.add(runtimeField);
        }

        @Override
        public List<RuntimeField> getDynamicRuntimeFields() {
            return Collections.unmodifiableList(this.dynamicRuntimeFields);
        }

        @Override
        public Iterable<LuceneDocument> nonRootDocuments() {
            if (this.docsReversed) {
                throw new IllegalStateException("documents are already reversed");
            }
            return this.documents.subList(1, this.documents.size());
        }

        void postParse() {
            if (this.documents.size() > 1) {
                this.docsReversed = true;
                if (this.indexSettings().getIndexVersionCreated().onOrAfter(Version.V_6_5_0)) {
                    List<LuceneDocument> newDocs = this.reorderParent(this.documents);
                    this.documents.clear();
                    this.documents.addAll(newDocs);
                } else {
                    Collections.reverse(this.documents);
                }
            }
        }

        private List<LuceneDocument> reorderParent(List<LuceneDocument> docs) {
            ArrayList<LuceneDocument> newDocs = new ArrayList<LuceneDocument>(docs.size());
            LinkedList<LuceneDocument> parents = new LinkedList<LuceneDocument>();
            for (LuceneDocument doc : docs) {
                while (parents.peek() != doc.getParent()) {
                    newDocs.add((LuceneDocument)parents.poll());
                }
                parents.add(0, doc);
            }
            newDocs.addAll(parents);
            return newDocs;
        }

        @Override
        public void addIgnoredField(String field) {
            this.ignoredFields.add(field);
        }

        @Override
        public Collection<String> getIgnoredFields() {
            return Collections.unmodifiableCollection(this.ignoredFields);
        }

        @Override
        public void addToFieldNames(String field) {
            this.fieldNameFields.add(field);
        }

        @Override
        public Collection<String> getFieldNames() {
            return Collections.unmodifiableCollection(this.fieldNameFields);
        }
    }

    private static class FilterParseContext
    extends ParseContext {
        private final ParseContext in;

        private FilterParseContext(ParseContext in) {
            this.in = in;
        }

        @Override
        public ObjectMapper getObjectMapper(String name) {
            return this.in.getObjectMapper(name);
        }

        @Override
        public Iterable<LuceneDocument> nonRootDocuments() {
            return this.in.nonRootDocuments();
        }

        @Override
        public MappingParserContext dynamicTemplateParserContext(DateFormatter dateFormatter) {
            return this.in.dynamicTemplateParserContext(dateFormatter);
        }

        @Override
        public boolean isWithinCopyTo() {
            return this.in.isWithinCopyTo();
        }

        @Override
        public boolean isWithinMultiFields() {
            return this.in.isWithinMultiFields();
        }

        @Override
        public IndexSettings indexSettings() {
            return this.in.indexSettings();
        }

        @Override
        public SourceToParse sourceToParse() {
            return this.in.sourceToParse();
        }

        @Override
        public ContentPath path() {
            return this.in.path();
        }

        @Override
        public XContentParser parser() {
            return this.in.parser();
        }

        @Override
        public LuceneDocument rootDoc() {
            return this.in.rootDoc();
        }

        @Override
        public List<LuceneDocument> docs() {
            return this.in.docs();
        }

        @Override
        public LuceneDocument doc() {
            return this.in.doc();
        }

        @Override
        protected void addDoc(LuceneDocument doc) {
            this.in.addDoc(doc);
        }

        @Override
        public RootObjectMapper root() {
            return this.in.root();
        }

        @Override
        public MappingLookup mappingLookup() {
            return this.in.mappingLookup();
        }

        @Override
        public MetadataFieldMapper getMetadataMapper(String mapperName) {
            return this.in.getMetadataMapper(mapperName);
        }

        @Override
        public IndexAnalyzers indexAnalyzers() {
            return this.in.indexAnalyzers();
        }

        @Override
        public Field version() {
            return this.in.version();
        }

        @Override
        public void version(Field version) {
            this.in.version(version);
        }

        @Override
        public SeqNoFieldMapper.SequenceIDFields seqID() {
            return this.in.seqID();
        }

        @Override
        public void seqID(SeqNoFieldMapper.SequenceIDFields seqID) {
            this.in.seqID(seqID);
        }

        @Override
        public void addDynamicMapper(Mapper update) {
            this.in.addDynamicMapper(update);
        }

        @Override
        public List<Mapper> getDynamicMappers() {
            return this.in.getDynamicMappers();
        }

        @Override
        public void addDynamicRuntimeField(RuntimeField runtimeField) {
            this.in.addDynamicRuntimeField(runtimeField);
        }

        @Override
        public List<RuntimeField> getDynamicRuntimeFields() {
            return this.in.getDynamicRuntimeFields();
        }

        @Override
        public void addIgnoredField(String field) {
            this.in.addIgnoredField(field);
        }

        @Override
        public Collection<String> getIgnoredFields() {
            return this.in.getIgnoredFields();
        }

        @Override
        public void addToFieldNames(String field) {
            this.in.addToFieldNames(field);
        }

        @Override
        public Collection<String> getFieldNames() {
            return this.in.getFieldNames();
        }
    }
}

