/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.fielddata.DateScriptFieldData;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.DateFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.runtime.LongScriptFieldDistanceFeatureQuery;
import org.elasticsearch.search.runtime.LongScriptFieldExistsQuery;
import org.elasticsearch.search.runtime.LongScriptFieldRangeQuery;
import org.elasticsearch.search.runtime.LongScriptFieldTermQuery;
import org.elasticsearch.search.runtime.LongScriptFieldTermsQuery;

public class DateScriptFieldType
extends AbstractScriptFieldType<DateFieldScript.LeafFactory> {
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(name -> new AbstractScriptFieldType.Builder<DateFieldScript.Factory>(name, DateFieldScript.CONTEXT, DateFieldScript.PARSE_FROM_SOURCE){
        private final FieldMapper.Parameter<String> format = FieldMapper.Parameter.stringParam("format", true, AbstractScriptFieldType.initializerNotSupported(), null).setSerializer((b, n, v) -> {
            if (v != null && !v.equals(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.pattern())) {
                b.field(n, v);
            }
        }, Object::toString).acceptsNull();
        private final FieldMapper.Parameter<Locale> locale = new FieldMapper.Parameter<Locale>("locale", true, () -> null, (n, c, o) -> o == null ? null : LocaleUtils.parse(o.toString()), AbstractScriptFieldType.initializerNotSupported()).setSerializer((b, n, v) -> {
            if (v != null && !v.equals(Locale.ROOT)) {
                b.field(n, v.toString());
            }
        }, Object::toString).acceptsNull();

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            ArrayList parameters = new ArrayList(super.getParameters());
            parameters.add(this.format);
            parameters.add(this.locale);
            return Collections.unmodifiableList(parameters);
        }

        @Override
        RuntimeField newRuntimeField(DateFieldScript.Factory scriptFactory) {
            String pattern = this.format.getValue() == null ? DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.pattern() : this.format.getValue();
            Locale locale = this.locale.getValue() == null ? Locale.ROOT : this.locale.getValue();
            DateFormatter dateTimeFormatter = DateFormatter.forPattern(pattern).withLocale(locale);
            return new DateScriptFieldType(this.name, scriptFactory, dateTimeFormatter, this.getScript(), this.meta(), this);
        }
    });
    private final DateFormatter dateTimeFormatter;

    public DateScriptFieldType(String name, DateFormatter dateTimeFormatter) {
        this(name, DateFieldScript.PARSE_FROM_SOURCE, dateTimeFormatter, null, Collections.emptyMap(), (builder, params) -> {
            if (!DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.pattern().equals(dateTimeFormatter.pattern())) {
                builder.field("format", dateTimeFormatter.pattern());
            }
            return builder;
        });
    }

    DateScriptFieldType(String name, DateFieldScript.Factory scriptFactory, DateFormatter dateTimeFormatter, Script script, Map<String, String> meta, ToXContent toXContent) {
        super(name, searchLookup -> scriptFactory.newFactory(name, script.getParams(), (SearchLookup)searchLookup, dateTimeFormatter), script, meta, toXContent);
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public String typeName() {
        return "date";
    }

    @Override
    public Object valueForDisplay(Object value) {
        Long val = (Long)value;
        if (val == null) {
            return null;
        }
        return this.dateTimeFormatter.format(DateFieldMapper.Resolution.MILLISECONDS.toInstant(val).atZone(ZoneOffset.UTC));
    }

    @Override
    public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
        DateFormatter dateTimeFormatter = this.dateTimeFormatter;
        if (format != null) {
            dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
        }
        if (timeZone == null) {
            timeZone = ZoneOffset.UTC;
        }
        return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, DateFieldMapper.Resolution.MILLISECONDS);
    }

    @Override
    public DateScriptFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> lookup) {
        return new DateScriptFieldData.Builder(this.name(), (DateFieldScript.LeafFactory)this.leafFactory(lookup.get()));
    }

    @Override
    public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        return DateFieldMapper.DateFieldType.handleNow(context, now -> {
            long originLong = DateFieldMapper.DateFieldType.parseToLong(origin, true, null, this.dateTimeFormatter.toDateMathParser(), now, DateFieldMapper.Resolution.MILLISECONDS);
            TimeValue pivotTime = TimeValue.parseTimeValue((String)pivot, (String)"distance_feature.pivot");
            return new LongScriptFieldDistanceFeatureQuery(this.script, ((DateFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), originLong, pivotTime.getMillis());
        });
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        this.checkAllowExpensiveQueries(context);
        return new LongScriptFieldExistsQuery(this.script, ((DateFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name());
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ZoneId timeZone, @Nullable DateMathParser parser, SearchExecutionContext context) {
        parser = parser == null ? this.dateTimeFormatter.toDateMathParser() : parser;
        this.checkAllowExpensiveQueries(context);
        return DateFieldMapper.DateFieldType.dateRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, parser, context, DateFieldMapper.Resolution.MILLISECONDS, (l, u) -> new LongScriptFieldRangeQuery(this.script, ((DateFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), (long)l, (long)u));
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        return DateFieldMapper.DateFieldType.handleNow(context, now -> {
            long l = DateFieldMapper.DateFieldType.parseToLong(value, false, null, this.dateTimeFormatter.toDateMathParser(), now, DateFieldMapper.Resolution.MILLISECONDS);
            this.checkAllowExpensiveQueries(context);
            return new LongScriptFieldTermQuery(this.script, ((DateFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), l);
        });
    }

    @Override
    public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        if (values.isEmpty()) {
            return Queries.newMatchAllQuery();
        }
        return DateFieldMapper.DateFieldType.handleNow(context, now -> {
            LongHashSet terms = new LongHashSet(values.size());
            for (Object value : values) {
                terms.add(DateFieldMapper.DateFieldType.parseToLong(value, false, null, this.dateTimeFormatter.toDateMathParser(), now, DateFieldMapper.Resolution.MILLISECONDS));
            }
            this.checkAllowExpensiveQueries(context);
            return new LongScriptFieldTermsQuery(this.script, ((DateFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), (LongSet)terms);
        });
    }
}

