/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.utils.WellKnownText;

public class GeoFormatterFactory {
    public static final String GEOJSON = "geojson";
    public static final String WKT = "wkt";
    private static final Map<String, Function<Geometry, Object>> FORMATTERS = new HashMap<String, Function<Geometry, Object>>();

    public static Function<Geometry, Object> getFormatter(String name) {
        Function<Geometry, Object> format = FORMATTERS.get(name);
        if (format == null) {
            throw new IllegalArgumentException("Unrecognized geometry format [" + name + "].");
        }
        return format;
    }

    static {
        FORMATTERS.put(GEOJSON, GeoJson::toMap);
        FORMATTERS.put(WKT, WellKnownText::toWKT);
    }
}

