/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataStreamAlias
extends AbstractDiffable<DataStreamAlias>
implements ToXContentFragment {
    public static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
    public static final ParseField WRITE_DATA_STREAM_FIELD = new ParseField("write_data_stream", new String[0]);
    private static final ConstructingObjectParser<DataStreamAlias, String> PARSER = new ConstructingObjectParser("data_stream_alias", false, (args, name) -> new DataStreamAlias((String)name, (List)args[0], (String)args[1]));
    private final String name;
    private final List<String> dataStreams;
    private final String writeDataStream;

    public DataStreamAlias(String name, Collection<String> dataStreams, String writeDataStream) {
        this.name = Objects.requireNonNull(name);
        this.dataStreams = Collections.unmodifiableList(new ArrayList<String>(dataStreams));
        this.writeDataStream = writeDataStream;
        assert (writeDataStream == null || dataStreams.contains(writeDataStream));
    }

    public DataStreamAlias(StreamInput in) throws IOException {
        this.name = in.readString();
        this.dataStreams = in.readStringList();
        this.writeDataStream = in.readOptionalString();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getDataStreams() {
        return this.dataStreams;
    }

    public String getWriteDataStream() {
        return this.writeDataStream;
    }

    public DataStreamAlias addDataStream(String dataStream, Boolean isWriteDataStream) {
        HashSet<String> dataStreams;
        boolean added;
        String writeDataStream = this.writeDataStream;
        if (isWriteDataStream != null) {
            if (isWriteDataStream.booleanValue()) {
                writeDataStream = dataStream;
            } else if (dataStream.equals(writeDataStream)) {
                writeDataStream = null;
            }
        }
        if ((added = (dataStreams = new HashSet<String>(this.dataStreams)).add(dataStream)) || !Objects.equals(this.writeDataStream, writeDataStream)) {
            return new DataStreamAlias(this.name, dataStreams, writeDataStream);
        }
        return this;
    }

    public DataStreamAlias removeDataStream(String dataStream) {
        HashSet<String> dataStreams = new HashSet<String>(this.dataStreams);
        boolean removed = dataStreams.remove(dataStream);
        if (!removed) {
            return this;
        }
        if (dataStreams.isEmpty()) {
            return null;
        }
        String writeDataStream = this.writeDataStream;
        if (dataStream.equals(writeDataStream)) {
            writeDataStream = null;
        }
        return new DataStreamAlias(this.name, dataStreams, writeDataStream);
    }

    public DataStreamAlias intersect(Predicate<String> filter) {
        String writeDataStream;
        List<String> intersectingDataStreams = this.dataStreams.stream().filter(filter).collect(Collectors.toList());
        if (!intersectingDataStreams.contains(writeDataStream = this.writeDataStream)) {
            writeDataStream = null;
        }
        return new DataStreamAlias(this.name, intersectingDataStreams, writeDataStream);
    }

    public DataStreamAlias merge(DataStreamAlias other) {
        HashSet<String> mergedDataStreams = new HashSet<String>(other.getDataStreams());
        mergedDataStreams.addAll(this.getDataStreams());
        String writeDataStream = this.writeDataStream;
        if (writeDataStream == null && other.getWriteDataStream() != null && mergedDataStreams.contains(other.getWriteDataStream())) {
            writeDataStream = other.getWriteDataStream();
        }
        return new DataStreamAlias(this.name, mergedDataStreams, writeDataStream);
    }

    public DataStreamAlias renameDataStreams(String renamePattern, String renameReplacement) {
        List<String> renamedDataStreams = this.dataStreams.stream().map(s -> s.replaceAll(renamePattern, renameReplacement)).collect(Collectors.toList());
        String writeDataStream = this.writeDataStream;
        if (writeDataStream != null) {
            writeDataStream = writeDataStream.replaceAll(renamePattern, renameReplacement);
        }
        return new DataStreamAlias(this.name, renamedDataStreams, writeDataStream);
    }

    public static Diff<DataStreamAlias> readDiffFrom(StreamInput in) throws IOException {
        return DataStreamAlias.readDiffFrom(DataStreamAlias::new, in);
    }

    public static DataStreamAlias fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
        }
        String name = parser.currentName();
        return (DataStreamAlias)PARSER.parse(parser, (Object)name);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(DATA_STREAMS_FIELD.getPreferredName(), this.dataStreams);
        if (this.writeDataStream != null) {
            builder.field(WRITE_DATA_STREAM_FIELD.getPreferredName(), this.writeDataStream);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.dataStreams);
        out.writeOptionalString(this.writeDataStream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamAlias that = (DataStreamAlias)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.dataStreams, that.dataStreams) && Objects.equals(this.writeDataStream, that.writeDataStream);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataStreams, this.writeDataStream);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), DATA_STREAMS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), WRITE_DATA_STREAM_FIELD);
    }
}

