/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.geo.GeoLineDecomposer;
import org.elasticsearch.common.geo.GeoPolygonDecomposer;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.GeoShapeUtils;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;

public class GeoShapeIndexer {
    private final boolean orientation;
    private final String name;

    public GeoShapeIndexer(boolean orientation, String name) {
        this.orientation = orientation;
        this.name = name;
    }

    public Geometry prepareForIndexing(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        return (Geometry)geometry.visit((GeometryVisitor)new GeometryVisitor<Geometry, RuntimeException>(){

            public Geometry visit(Circle circle) {
                throw new UnsupportedOperationException((Object)((Object)GeoShapeType.CIRCLE) + " geometry is not supported");
            }

            public Geometry visit(GeometryCollection<?> collection) {
                if (collection.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                ArrayList<Geometry> shapes = new ArrayList<Geometry>(collection.size());
                for (Geometry shape : collection) {
                    shapes.add((Geometry)shape.visit((GeometryVisitor)this));
                }
                if (shapes.size() == 1) {
                    return (Geometry)shapes.get(0);
                }
                return new GeometryCollection(shapes);
            }

            public Geometry visit(Line line) {
                ArrayList<Line> lines = new ArrayList<Line>();
                GeoLineDecomposer.decomposeLine(line, lines);
                if (lines.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (lines.size() == 1) {
                    return (Geometry)lines.get(0);
                }
                return new MultiLine(lines);
            }

            public Geometry visit(LinearRing ring) {
                throw new UnsupportedOperationException("cannot index linear ring [" + ring + "] directly");
            }

            public Geometry visit(MultiLine multiLine) {
                ArrayList<Line> lines = new ArrayList<Line>();
                GeoLineDecomposer.decomposeMultiLine(multiLine, lines);
                if (lines.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (lines.size() == 1) {
                    return (Geometry)lines.get(0);
                }
                return new MultiLine(lines);
            }

            public Geometry visit(MultiPoint multiPoint) {
                if (multiPoint.isEmpty()) {
                    return MultiPoint.EMPTY;
                }
                if (multiPoint.size() == 1) {
                    return (Geometry)((Point)multiPoint.get(0)).visit((GeometryVisitor)this);
                }
                ArrayList<Point> points = new ArrayList<Point>();
                for (Point point : multiPoint) {
                    points.add((Point)point.visit((GeometryVisitor)this));
                }
                return new MultiPoint(points);
            }

            public Geometry visit(MultiPolygon multiPolygon) {
                ArrayList<org.elasticsearch.geometry.Polygon> polygons = new ArrayList<org.elasticsearch.geometry.Polygon>();
                GeoPolygonDecomposer.decomposeMultiPolygon(multiPolygon, GeoShapeIndexer.this.orientation, polygons);
                if (polygons.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (polygons.size() == 1) {
                    return (Geometry)polygons.get(0);
                }
                return new MultiPolygon(polygons);
            }

            public Geometry visit(Point point) {
                double[] latlon = new double[]{point.getX(), point.getY()};
                GeoUtils.normalizePoint(latlon);
                return new Point(latlon[0], latlon[1]);
            }

            public Geometry visit(org.elasticsearch.geometry.Polygon polygon) {
                ArrayList<org.elasticsearch.geometry.Polygon> polygons = new ArrayList<org.elasticsearch.geometry.Polygon>();
                GeoPolygonDecomposer.decomposePolygon(polygon, GeoShapeIndexer.this.orientation, polygons);
                if (polygons.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (polygons.size() == 1) {
                    return (Geometry)polygons.get(0);
                }
                return new MultiPolygon(polygons);
            }

            public Geometry visit(Rectangle rectangle) {
                return rectangle;
            }
        });
    }

    public List<IndexableField> indexShape(Geometry shape) {
        LuceneGeometryIndexer visitor = new LuceneGeometryIndexer(this.name);
        if ((shape = this.prepareForIndexing(shape)) == null) {
            return Collections.emptyList();
        }
        shape.visit((GeometryVisitor)visitor);
        return visitor.fields();
    }

    private static class LuceneGeometryIndexer
    implements GeometryVisitor<Void, RuntimeException> {
        private List<IndexableField> fields = new ArrayList<IndexableField>();
        private final String name;

        private LuceneGeometryIndexer(String name) {
            this.name = name;
        }

        List<IndexableField> fields() {
            return this.fields;
        }

        public Void visit(Circle circle) {
            throw new IllegalArgumentException("invalid shape type found [Circle] while indexing shape");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry geometry : collection) {
                geometry.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (org.apache.lucene.geo.Line)GeoShapeUtils.toLuceneLine(line)));
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new IllegalArgumentException("invalid shape type found [LinearRing] while indexing shape");
        }

        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (org.elasticsearch.geometry.Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (double)point.getY(), (double)point.getX()));
            return null;
        }

        public Void visit(org.elasticsearch.geometry.Polygon polygon) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (Polygon)GeoShapeUtils.toLucenePolygon(polygon)));
            return null;
        }

        public Void visit(Rectangle r) {
            int minLat = GeoEncodingUtils.encodeLatitude((double)r.getMinLat());
            int maxLat = GeoEncodingUtils.encodeLatitude((double)r.getMaxLat());
            int minLon = GeoEncodingUtils.encodeLongitude((double)r.getMinLon());
            int maxLon = GeoEncodingUtils.encodeLongitude((double)r.getMaxLon());
            if (r.getMinLon() > r.getMaxLon()) {
                Line line;
                if (minLon == Integer.MAX_VALUE) {
                    line = new Line(new double[]{180.0, 180.0}, new double[]{r.getMaxLat(), r.getMinLat()});
                    this.visit(line);
                } else {
                    Rectangle left = new Rectangle(r.getMinLon(), 180.0, r.getMaxLat(), r.getMinLat());
                    this.visit(left);
                }
                if (maxLon == Integer.MIN_VALUE) {
                    line = new Line(new double[]{-180.0, -180.0}, new double[]{r.getMaxLat(), r.getMinLat()});
                    this.visit(line);
                } else {
                    Rectangle right = new Rectangle(-180.0, r.getMaxLon(), r.getMaxLat(), r.getMinLat());
                    this.visit(right);
                }
            } else if (minLon == maxLon) {
                if (minLat == maxLat) {
                    this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (double)r.getMinLat(), (double)r.getMinLon()));
                } else {
                    Line line = new Line(new double[]{r.getMinLon(), r.getMaxLon()}, new double[]{r.getMaxLat(), r.getMinLat()});
                    this.visit(line);
                }
            } else if (minLat == maxLat) {
                Line line = new Line(new double[]{r.getMinLon(), r.getMaxLon()}, new double[]{r.getMaxLat(), r.getMinLat()});
                this.visit(line);
            } else {
                Rectangle qRectangle = new Rectangle(GeoEncodingUtils.decodeLongitude((int)minLon), GeoEncodingUtils.decodeLongitude((int)maxLon), GeoEncodingUtils.decodeLatitude((int)maxLat), GeoEncodingUtils.decodeLatitude((int)minLat));
                this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (Polygon)GeoShapeUtils.toLucenePolygon(qRectangle)));
            }
            return null;
        }

        private void addFields(IndexableField[] fields) {
            this.fields.addAll(Arrays.asList(fields));
        }
    }
}

