/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoShapeUtils;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.GeometryFormat;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLatLonPointIndexFieldData;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.GeoPointFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;

public class GeoPointFieldMapper
extends AbstractPointGeometryFieldMapper<GeoPoint> {
    public static final String CONTENT_TYPE = "geo_point";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.scriptCompiler(), (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())));
    private final Builder builder;
    private final FieldValues<GeoPoint> scriptValues;

    private static Builder builder(FieldMapper in) {
        return ((GeoPointFieldMapper)in).builder;
    }

    public GeoPointFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<ParsedGeoPoint> parser, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, builder.ignoreMalformed.get(), builder.ignoreZValue.get(), builder.nullValue.get(), copyTo, parser);
        this.builder = builder;
        this.scriptValues = null;
    }

    public GeoPointFieldMapper(String simpleName, MappedFieldType mappedFieldType, AbstractGeometryFieldMapper.Parser<ParsedGeoPoint> parser, Builder builder) {
        super(simpleName, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty(), parser, (String)builder.onScriptError.get());
        this.builder = builder;
        this.scriptValues = builder.scriptValues();
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.scriptCompiler, this.builder.ignoreMalformed.getDefaultValue().value()).init(this);
    }

    @Override
    protected void index(ParseContext context, GeoPoint geometry) throws IOException {
        if (this.fieldType().isSearchable()) {
            context.doc().add((IndexableField)new LatLonPoint(this.fieldType().name(), geometry.lat(), geometry.lon()));
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add((IndexableField)new LatLonDocValuesField(this.fieldType().name(), geometry.lat(), geometry.lon()));
        } else if (this.fieldType().isStored() || this.fieldType().isSearchable()) {
            this.createFieldNamesField(context);
        }
        if (this.fieldType().isStored()) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), geometry.toString()));
        }
        this.multiFields.parse(this, context.createExternalValueContext(geometry.geohash()));
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, ParseContext parseContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, point -> {
            try {
                this.index(parseContext, (GeoPoint)point);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<AbstractPointGeometryFieldMapper.ParsedPoint> nullValue;
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).indexed.get(), true);
        final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).hasDocValues.get(), true);
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).stored.get(), false);
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).script.get());
        private final FieldMapper.Parameter<String> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).onScriptError.get(), this.script);
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final ScriptCompiler scriptCompiler;

        public Builder(String name, ScriptCompiler scriptCompiler, boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.nullValue = AbstractPointGeometryFieldMapper.nullValueParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).nullValue.get(), (n, c, o) -> Builder.parseNullValue(o, this.ignoreZValue.get().value(), this.ignoreMalformed.get().value()), () -> null).acceptsNull();
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.script.precludesParameters(this.nullValue, this.ignoreMalformed, this.ignoreZValue);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.hasDocValues, this.indexed, this.stored, this.ignoreMalformed, this.ignoreZValue, this.nullValue, this.script, this.onScriptError, this.meta);
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        private static ParsedGeoPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            if (nullValue == null) {
                return null;
            }
            ParsedGeoPoint point = new ParsedGeoPoint();
            GeoUtils.parseGeoPoint(nullValue, (GeoPoint)point, ignoreZValue);
            if (!ignoreMalformed) {
                if (point.lat() > 90.0 || point.lat() < -90.0) {
                    throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "]");
                }
                if (point.lon() > 180.0 || point.lon() < -180.0) {
                    throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "]");
                }
            } else {
                GeoUtils.normalizePoint(point);
            }
            return point;
        }

        private FieldValues<GeoPoint> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            GeoPointFieldScript.Factory factory = this.scriptCompiler.compile(this.script.get(), GeoPointFieldScript.CONTEXT);
            return factory == null ? null : (lookup, ctx, doc, consumer) -> factory.newFactory(this.name, this.script.get().getParams(), lookup).newInstance(ctx).runGeoPointForDoc(doc, consumer);
        }

        @Override
        public FieldMapper build(ContentPath contentPath) {
            AbstractPointGeometryFieldMapper.PointParser<ParsedGeoPoint> geoParser = new AbstractPointGeometryFieldMapper.PointParser<ParsedGeoPoint>(this.name, ParsedGeoPoint::new, (parser, point) -> {
                GeoUtils.parseGeoPoint(parser, (GeoPoint)point, (boolean)this.ignoreZValue.get().value());
                return point;
            }, (ParsedGeoPoint)this.nullValue.get(), this.ignoreZValue.get().value(), this.ignoreMalformed.get().value());
            GeoPointFieldType ft = new GeoPointFieldType(this.buildFullName(contentPath), this.indexed.get(), this.stored.get(), this.hasDocValues.get(), geoParser, this.scriptValues(), this.meta.get());
            if (this.script.get() == null) {
                return new GeoPointFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), geoParser, this);
            }
            return new GeoPointFieldMapper(this.name, (MappedFieldType)ft, geoParser, this);
        }
    }

    protected static class ParsedGeoPoint
    extends GeoPoint
    implements AbstractPointGeometryFieldMapper.ParsedPoint {
        protected ParsedGeoPoint() {
        }

        @Override
        public void validate(String fieldName) {
            if (this.lat() > 90.0 || this.lat() < -90.0) {
                throw new IllegalArgumentException("illegal latitude value [" + this.lat() + "] for " + fieldName);
            }
            if (this.lon() > 180.0 || this.lon() < -180.0) {
                throw new IllegalArgumentException("illegal longitude value [" + this.lon() + "] for " + fieldName);
            }
        }

        @Override
        public void normalize(String name) {
            if (!this.isNormalizable(this.lat()) || !this.isNormalizable(this.lon())) {
                throw new ElasticsearchParseException("cannot normalize the point - not a number", new Object[0]);
            }
            GeoUtils.normalizePoint(this);
        }

        @Override
        public boolean isNormalizable(double coord) {
            return !Double.isNaN(coord) && !Double.isInfinite(coord);
        }

        @Override
        public void resetCoords(double x, double y) {
            this.reset(y, x);
        }

        @Override
        public Point asGeometry() {
            return new Point(this.lon(), this.lat());
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof GeoPoint)) {
                return false;
            }
            GeoPoint o = (GeoPoint)other;
            double oLat = o.lat();
            double oLon = o.lon();
            if (Double.compare(oLat, this.lat) != 0) {
                return false;
            }
            return Double.compare(oLon, this.lon) == 0;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class GeoPointFieldType
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType
    implements GeoShapeQueryable {
        private static final GeometryParser PARSER = new GeometryParser(true, true, true);
        private final FieldValues<GeoPoint> scriptValues;

        private GeoPointFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, AbstractGeometryFieldMapper.Parser<ParsedGeoPoint> parser, FieldValues<GeoPoint> scriptValues, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, true, parser, meta);
            this.scriptValues = scriptValues;
        }

        public GeoPointFieldType(String name) {
            this(name, true, false, true, null, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return GeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (this.scriptValues == null) {
                return super.valueFetcher(context, format);
            }
            String geoFormat = format != null ? format : "geojson";
            GeometryFormat<Geometry> geometryFormat = PARSER.geometryFormat(geoFormat);
            return FieldValues.valueFetcher(this.scriptValues, v -> {
                GeoPoint p = (GeoPoint)v;
                return geometryFormat.toXContentAsObject((Geometry)new Point(p.lon(), p.lat()));
            }, context);
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            LatLonGeometry[] luceneGeometries = GeoShapeUtils.toLuceneGeometry(fieldName, context, shape, relation);
            if (luceneGeometries.length == 0) {
                return new MatchNoDocsQuery();
            }
            Query query = LatLonPoint.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (LatLonGeometry[])luceneGeometries);
            if (this.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (LatLonGeometry[])luceneGeometries);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new AbstractLatLonPointIndexFieldData.Builder(this.name(), CoreValuesSourceType.GEOPOINT);
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
            GeoPoint originGeoPoint;
            if (origin instanceof GeoPoint) {
                originGeoPoint = (GeoPoint)origin;
            } else if (origin instanceof String) {
                originGeoPoint = GeoUtils.parseFromString((String)origin);
            } else {
                throw new IllegalArgumentException("Illegal type [" + origin.getClass() + "] for [origin]! Must be of type [geo_point] or [string] for geo_point fields!");
            }
            double pivotDouble = DistanceUnit.DEFAULT.parse(pivot, DistanceUnit.DEFAULT);
            return LatLonPoint.newDistanceFeatureQuery((String)this.name(), (float)1.0f, (double)originGeoPoint.lat(), (double)originGeoPoint.lon(), (double)pivotDouble);
        }
    }
}

