/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.RatioValue;
import org.elasticsearch.common.unit.RelativeByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class DiskThresholdSettings {
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING = Setting.boolSetting("cluster.routing.allocation.disk.threshold_enabled", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<String> CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING = new Setting<String>("cluster.routing.allocation.disk.watermark.low", "85%", s -> DiskThresholdSettings.validWatermarkSetting(s, "cluster.routing.allocation.disk.watermark.low"), new LowDiskWatermarkValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<String> CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING = new Setting<String>("cluster.routing.allocation.disk.watermark.high", "90%", s -> DiskThresholdSettings.validWatermarkSetting(s, "cluster.routing.allocation.disk.watermark.high"), new HighDiskWatermarkValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<String> CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING = new Setting<String>("cluster.routing.allocation.disk.watermark.flood_stage", "95%", s -> DiskThresholdSettings.validWatermarkSetting(s, "cluster.routing.allocation.disk.watermark.flood_stage"), new FloodStageValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<RelativeByteSizeValue> CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_SETTING = new Setting<RelativeByteSizeValue>("cluster.routing.allocation.disk.watermark.flood_stage.frozen", "95%", s -> RelativeByteSizeValue.parseRelativeByteSizeValue(s, "cluster.routing.allocation.disk.watermark.flood_stage.frozen"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING = new Setting<ByteSizeValue>("cluster.routing.allocation.disk.watermark.flood_stage.frozen.max_headroom", settings -> {
        if (CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_SETTING.exists((Settings)settings)) {
            return "-1";
        }
        return "20GB";
    }, s -> ByteSizeValue.parseBytesSizeValue(s, "cluster.routing.allocation.disk.watermark.flood_stage.frozen.max_headroom"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_INCLUDE_RELOCATIONS_SETTING = Setting.boolSetting("cluster.routing.allocation.disk.include_relocations", true, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<TimeValue> CLUSTER_ROUTING_ALLOCATION_REROUTE_INTERVAL_SETTING = Setting.positiveTimeSetting("cluster.routing.allocation.disk.reroute_interval", TimeValue.timeValueSeconds((long)60L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile String lowWatermarkRaw;
    private volatile String highWatermarkRaw;
    private volatile Double freeDiskThresholdLow;
    private volatile Double freeDiskThresholdHigh;
    private volatile ByteSizeValue freeBytesThresholdLow;
    private volatile ByteSizeValue freeBytesThresholdHigh;
    private volatile boolean includeRelocations;
    private volatile boolean enabled;
    private volatile TimeValue rerouteInterval;
    private volatile Double freeDiskThresholdFloodStage;
    private volatile ByteSizeValue freeBytesThresholdFloodStage;
    private volatile RelativeByteSizeValue frozenFloodStage;
    private volatile ByteSizeValue frozenFloodStageMaxHeadroom;
    private static final boolean autoReleaseIndexEnabled;
    public static final String AUTO_RELEASE_INDEX_ENABLED_KEY = "es.disk.auto_release_flood_stage_block";

    public DiskThresholdSettings(Settings settings, ClusterSettings clusterSettings) {
        String lowWatermark = CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.get(settings);
        String highWatermark = CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.get(settings);
        String floodStage = CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.get(settings);
        this.setHighWatermark(highWatermark);
        this.setLowWatermark(lowWatermark);
        this.setFloodStage(floodStage);
        this.setFrozenFloodStage(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_SETTING.get(settings));
        this.setFrozenFloodStageMaxHeadroom(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING.get(settings));
        this.includeRelocations = CLUSTER_ROUTING_ALLOCATION_INCLUDE_RELOCATIONS_SETTING.get(settings);
        this.rerouteInterval = CLUSTER_ROUTING_ALLOCATION_REROUTE_INTERVAL_SETTING.get(settings);
        this.enabled = CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, this::setLowWatermark);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING, this::setHighWatermark);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING, this::setFloodStage);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_SETTING, this::setFrozenFloodStage);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING, this::setFrozenFloodStageMaxHeadroom);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_INCLUDE_RELOCATIONS_SETTING, this::setIncludeRelocations);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_REROUTE_INTERVAL_SETTING, this::setRerouteInterval);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING, this::setEnabled);
    }

    private static void doValidate(String low, String high, String flood) {
        try {
            DiskThresholdSettings.doValidateAsPercentage(low, high, flood);
            return;
        }
        catch (ElasticsearchParseException elasticsearchParseException) {
            try {
                DiskThresholdSettings.doValidateAsBytes(low, high, flood);
            }
            catch (ElasticsearchParseException e) {
                String message = String.format(Locale.ROOT, "unable to consistently parse [%s=%s], [%s=%s], and [%s=%s] as percentage or bytes", CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), low, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), high, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), flood);
                throw new IllegalArgumentException(message, e);
            }
            return;
        }
    }

    private static void doValidateAsPercentage(String low, String high, String flood) {
        double lowWatermarkThreshold = DiskThresholdSettings.thresholdPercentageFromWatermark(low, false);
        double highWatermarkThreshold = DiskThresholdSettings.thresholdPercentageFromWatermark(high, false);
        double floodThreshold = DiskThresholdSettings.thresholdPercentageFromWatermark(flood, false);
        if (lowWatermarkThreshold > highWatermarkThreshold) {
            throw new IllegalArgumentException("low disk watermark [" + low + "] more than high disk watermark [" + high + "]");
        }
        if (highWatermarkThreshold > floodThreshold) {
            throw new IllegalArgumentException("high disk watermark [" + high + "] more than flood stage disk watermark [" + flood + "]");
        }
    }

    private static void doValidateAsBytes(String low, String high, String flood) {
        ByteSizeValue lowWatermarkBytes = DiskThresholdSettings.thresholdBytesFromWatermark(low, CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), false);
        ByteSizeValue highWatermarkBytes = DiskThresholdSettings.thresholdBytesFromWatermark(high, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), false);
        ByteSizeValue floodStageBytes = DiskThresholdSettings.thresholdBytesFromWatermark(flood, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), false);
        if (lowWatermarkBytes.getBytes() < highWatermarkBytes.getBytes()) {
            throw new IllegalArgumentException("low disk watermark [" + low + "] less than high disk watermark [" + high + "]");
        }
        if (highWatermarkBytes.getBytes() < floodStageBytes.getBytes()) {
            throw new IllegalArgumentException("high disk watermark [" + high + "] less than flood stage disk watermark [" + flood + "]");
        }
    }

    private void setIncludeRelocations(boolean includeRelocations) {
        this.includeRelocations = includeRelocations;
    }

    private void setRerouteInterval(TimeValue rerouteInterval) {
        this.rerouteInterval = rerouteInterval;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void setLowWatermark(String lowWatermark) {
        this.lowWatermarkRaw = lowWatermark;
        this.freeDiskThresholdLow = 100.0 - DiskThresholdSettings.thresholdPercentageFromWatermark(lowWatermark);
        this.freeBytesThresholdLow = DiskThresholdSettings.thresholdBytesFromWatermark(lowWatermark, CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey());
    }

    private void setHighWatermark(String highWatermark) {
        this.highWatermarkRaw = highWatermark;
        this.freeDiskThresholdHigh = 100.0 - DiskThresholdSettings.thresholdPercentageFromWatermark(highWatermark);
        this.freeBytesThresholdHigh = DiskThresholdSettings.thresholdBytesFromWatermark(highWatermark, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey());
    }

    private void setFloodStage(String floodStageRaw) {
        this.freeDiskThresholdFloodStage = 100.0 - DiskThresholdSettings.thresholdPercentageFromWatermark(floodStageRaw);
        this.freeBytesThresholdFloodStage = DiskThresholdSettings.thresholdBytesFromWatermark(floodStageRaw, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey());
    }

    private void setFrozenFloodStage(RelativeByteSizeValue floodStage) {
        this.frozenFloodStage = floodStage;
    }

    private void setFrozenFloodStageMaxHeadroom(ByteSizeValue maxHeadroom) {
        this.frozenFloodStageMaxHeadroom = maxHeadroom;
    }

    public String getLowWatermarkRaw() {
        return this.lowWatermarkRaw;
    }

    public String getHighWatermarkRaw() {
        return this.highWatermarkRaw;
    }

    public Double getFreeDiskThresholdLow() {
        return this.freeDiskThresholdLow;
    }

    public Double getFreeDiskThresholdHigh() {
        return this.freeDiskThresholdHigh;
    }

    public ByteSizeValue getFreeBytesThresholdLow() {
        return this.freeBytesThresholdLow;
    }

    public ByteSizeValue getFreeBytesThresholdHigh() {
        return this.freeBytesThresholdHigh;
    }

    public Double getFreeDiskThresholdFloodStage() {
        return this.freeDiskThresholdFloodStage;
    }

    public ByteSizeValue getFreeBytesThresholdFloodStage() {
        return this.freeBytesThresholdFloodStage;
    }

    public ByteSizeValue getFreeBytesThresholdFrozenFloodStage(ByteSizeValue total) {
        RelativeByteSizeValue frozenFloodStage = this.frozenFloodStage;
        if (frozenFloodStage.isAbsolute()) {
            return frozenFloodStage.getAbsolute();
        }
        return ByteSizeValue.ofBytes(total.getBytes() - frozenFloodStage.calculateValue(total, this.frozenFloodStageMaxHeadroom).getBytes());
    }

    public boolean isAutoReleaseIndexEnabled() {
        return autoReleaseIndexEnabled;
    }

    public boolean includeRelocations() {
        return this.includeRelocations;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TimeValue getRerouteInterval() {
        return this.rerouteInterval;
    }

    String describeLowThreshold() {
        return this.freeBytesThresholdLow.equals(ByteSizeValue.ZERO) ? Strings.format1Decimals(100.0 - this.freeDiskThresholdLow, "%") : this.freeBytesThresholdLow.toString();
    }

    String describeHighThreshold() {
        return this.freeBytesThresholdHigh.equals(ByteSizeValue.ZERO) ? Strings.format1Decimals(100.0 - this.freeDiskThresholdHigh, "%") : this.freeBytesThresholdHigh.toString();
    }

    String describeFloodStageThreshold() {
        return this.freeBytesThresholdFloodStage.equals(ByteSizeValue.ZERO) ? Strings.format1Decimals(100.0 - this.freeDiskThresholdFloodStage, "%") : this.freeBytesThresholdFloodStage.toString();
    }

    String describeFrozenFloodStageThreshold(ByteSizeValue total) {
        ByteSizeValue maxHeadroom = this.frozenFloodStageMaxHeadroom;
        RelativeByteSizeValue floodStage = this.frozenFloodStage;
        if (floodStage.isAbsolute()) {
            return floodStage.getStringRep();
        }
        if (floodStage.calculateValue(total, maxHeadroom).equals(floodStage.calculateValue(total, null))) {
            return Strings.format1Decimals(floodStage.getRatio().getAsPercent(), "%");
        }
        return "max_headroom=" + maxHeadroom;
    }

    private static double thresholdPercentageFromWatermark(String watermark) {
        return DiskThresholdSettings.thresholdPercentageFromWatermark(watermark, true);
    }

    private static double thresholdPercentageFromWatermark(String watermark, boolean lenient) {
        try {
            return RatioValue.parseRatioValue(watermark).getAsPercent();
        }
        catch (ElasticsearchParseException ex) {
            if (lenient) {
                return 100.0;
            }
            throw ex;
        }
    }

    private static ByteSizeValue thresholdBytesFromWatermark(String watermark, String settingName) {
        return DiskThresholdSettings.thresholdBytesFromWatermark(watermark, settingName, true);
    }

    private static ByteSizeValue thresholdBytesFromWatermark(String watermark, String settingName, boolean lenient) {
        try {
            return ByteSizeValue.parseBytesSizeValue(watermark, settingName);
        }
        catch (ElasticsearchParseException ex) {
            if (lenient) {
                return ByteSizeValue.parseBytesSizeValue("0b", settingName);
            }
            throw ex;
        }
    }

    private static String validWatermarkSetting(String watermark, String settingName) {
        try {
            RatioValue.parseRatioValue(watermark);
        }
        catch (ElasticsearchParseException e) {
            try {
                ByteSizeValue.parseBytesSizeValue(watermark, settingName);
            }
            catch (ElasticsearchParseException ex) {
                ex.addSuppressed(e);
                throw ex;
            }
        }
        return watermark;
    }

    static {
        String property = System.getProperty(AUTO_RELEASE_INDEX_ENABLED_KEY);
        if (property == null) {
            autoReleaseIndexEnabled = true;
        } else if (Boolean.FALSE.toString().equals(property)) {
            autoReleaseIndexEnabled = false;
        } else {
            throw new IllegalArgumentException("es.disk.auto_release_flood_stage_block may only be unset or set to [false] but was [" + property + "]");
        }
    }

    static final class LowDiskWatermarkValidator
    implements Setting.Validator<String> {
        LowDiskWatermarkValidator() {
        }

        @Override
        public void validate(String value) {
        }

        @Override
        public void validate(String value, Map<Setting<?>, Object> settings) {
            String highWatermarkRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING);
            String floodStageRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING);
            DiskThresholdSettings.doValidate(value, highWatermarkRaw, floodStageRaw);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting> settings = Arrays.asList(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING);
            return settings.iterator();
        }
    }

    static final class HighDiskWatermarkValidator
    implements Setting.Validator<String> {
        HighDiskWatermarkValidator() {
        }

        @Override
        public void validate(String value) {
        }

        @Override
        public void validate(String value, Map<Setting<?>, Object> settings) {
            String lowWatermarkRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING);
            String floodStageRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING);
            DiskThresholdSettings.doValidate(lowWatermarkRaw, value, floodStageRaw);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting> settings = Arrays.asList(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING);
            return settings.iterator();
        }
    }

    static final class FloodStageValidator
    implements Setting.Validator<String> {
        FloodStageValidator() {
        }

        @Override
        public void validate(String value) {
        }

        @Override
        public void validate(String value, Map<Setting<?>, Object> settings) {
            String lowWatermarkRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING);
            String highWatermarkRaw = (String)settings.get(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING);
            DiskThresholdSettings.doValidate(lowWatermarkRaw, highWatermarkRaw, value);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting> settings = Arrays.asList(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING);
            return settings.iterator();
        }
    }
}

