/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.ComponentTemplateMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.DataStreamMetadata;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexAliasesService;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.MetadataMappingService;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.routing.DelayedAllocationService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ConcurrentRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.MaxRetryAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.NodeVersionAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.RebalanceOnlyWhenActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ReplicaAfterPrimaryActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ResizeAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.RestoreInProgressAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SnapshotInProgressAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksNodeService;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.script.ScriptMetadata;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskResultsService;

public class ClusterModule
extends AbstractModule {
    public static final String BALANCED_ALLOCATOR = "balanced";
    public static final Setting<String> SHARDS_ALLOCATOR_TYPE_SETTING = new Setting("cluster.routing.allocation.type", "balanced", Function.identity(), Setting.Property.NodeScope);
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final AllocationDeciders allocationDeciders;
    private final AllocationService allocationService;
    private final List<ClusterPlugin> clusterPlugins;
    private final MetadataDeleteIndexService metadataDeleteIndexService;
    final Collection<AllocationDecider> deciderList;
    final ShardsAllocator shardsAllocator;
    static final Set<String> PRE_6_3_METADATA_CUSTOMS_WHITE_LIST = Collections.unmodifiableSet(Sets.newHashSet("index-graveyard", "ingest", "repositories", "stored_scripts"));
    static final Set<String> PRE_6_3_CLUSTER_CUSTOMS_WHITE_LIST = Collections.unmodifiableSet(Sets.newHashSet("restore", "snapshot_deletions", "snapshots"));

    public ClusterModule(Settings settings, ClusterService clusterService, List<ClusterPlugin> clusterPlugins, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, ThreadContext threadContext, SystemIndices systemIndices) {
        this.clusterPlugins = clusterPlugins;
        this.deciderList = ClusterModule.createAllocationDeciders(settings, clusterService.getClusterSettings(), clusterPlugins);
        this.allocationDeciders = new AllocationDeciders(this.deciderList);
        this.shardsAllocator = ClusterModule.createShardsAllocator(settings, clusterService.getClusterSettings(), clusterPlugins);
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = new IndexNameExpressionResolver(threadContext, systemIndices);
        this.allocationService = new AllocationService(this.allocationDeciders, this.shardsAllocator, clusterInfoService, snapshotsInfoService);
        this.metadataDeleteIndexService = new MetadataDeleteIndexService(settings, clusterService, this.allocationService);
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        ClusterModule.registerClusterCustom(entries, "snapshots", SnapshotsInProgress::new, SnapshotsInProgress::readDiffFrom);
        ClusterModule.registerClusterCustom(entries, "restore", RestoreInProgress::new, RestoreInProgress::readDiffFrom);
        ClusterModule.registerClusterCustom(entries, "snapshot_deletions", SnapshotDeletionsInProgress::new, SnapshotDeletionsInProgress::readDiffFrom);
        ClusterModule.registerClusterCustom(entries, "repository_cleanup", RepositoryCleanupInProgress::new, RepositoryCleanupInProgress::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "repositories", RepositoriesMetadata::new, RepositoriesMetadata::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "ingest", IngestMetadata::new, IngestMetadata::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "stored_scripts", ScriptMetadata::new, ScriptMetadata::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "index-graveyard", IndexGraveyard::new, IndexGraveyard::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "persistent_tasks", PersistentTasksCustomMetadata::new, PersistentTasksCustomMetadata::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "component_template", ComponentTemplateMetadata::new, ComponentTemplateMetadata::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "index_template", ComposableIndexTemplateMetadata::new, ComposableIndexTemplateMetadata::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "data_stream", DataStreamMetadata::new, DataStreamMetadata::readDiffFrom);
        ClusterModule.registerMetadataCustom(entries, "node_shutdown", NodesShutdownMetadata::new, NodesShutdownMetadata::readDiffFrom);
        entries.add(new NamedWriteableRegistry.Entry(Task.Status.class, "persistent_executor", PersistentTasksNodeService.Status::new));
        return entries;
    }

    public static ClusterState filterCustomsForPre63Clients(ClusterState clusterState) {
        ClusterState.Builder builder = ClusterState.builder(clusterState);
        clusterState.customs().keysIt().forEachRemaining(name -> {
            if (!PRE_6_3_CLUSTER_CUSTOMS_WHITE_LIST.contains(name)) {
                builder.removeCustom((String)name);
            }
        });
        Metadata.Builder metaBuilder = Metadata.builder(clusterState.metadata());
        clusterState.metadata().customs().keysIt().forEachRemaining(name -> {
            if (!PRE_6_3_METADATA_CUSTOMS_WHITE_LIST.contains(name)) {
                metaBuilder.removeCustom((String)name);
            }
        });
        return builder.metadata(metaBuilder).build();
    }

    public static List<NamedXContentRegistry.Entry> getNamedXWriteables() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("repositories", new String[0]), RepositoriesMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("ingest", new String[0]), IngestMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("stored_scripts", new String[0]), ScriptMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("index-graveyard", new String[0]), IndexGraveyard::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("persistent_tasks", new String[0]), PersistentTasksCustomMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("component_template", new String[0]), ComponentTemplateMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("index_template", new String[0]), ComposableIndexTemplateMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("data_stream", new String[0]), DataStreamMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("node_shutdown", new String[0]), NodesShutdownMetadata::fromXContent));
        return entries;
    }

    private static <T extends ClusterState.Custom> void registerClusterCustom(List<NamedWriteableRegistry.Entry> entries, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        ClusterModule.registerCustom(entries, ClusterState.Custom.class, name, reader, diffReader);
    }

    private static <T extends Metadata.Custom> void registerMetadataCustom(List<NamedWriteableRegistry.Entry> entries, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        ClusterModule.registerCustom(entries, Metadata.Custom.class, name, reader, diffReader);
    }

    private static <T extends NamedWriteable> void registerCustom(List<NamedWriteableRegistry.Entry> entries, Class<T> category, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        entries.add(new NamedWriteableRegistry.Entry(category, name, reader));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, name, diffReader));
    }

    public IndexNameExpressionResolver getIndexNameExpressionResolver() {
        return this.indexNameExpressionResolver;
    }

    public static Collection<AllocationDecider> createAllocationDeciders(Settings settings, ClusterSettings clusterSettings, List<ClusterPlugin> clusterPlugins) {
        LinkedHashMap<Class, AllocationDecider> deciders = new LinkedHashMap<Class, AllocationDecider>();
        ClusterModule.addAllocationDecider(deciders, new MaxRetryAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new ResizeAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new ReplicaAfterPrimaryActiveAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new RebalanceOnlyWhenActiveAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new ClusterRebalanceAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ConcurrentRebalanceAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new EnableAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new NodeVersionAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new SnapshotInProgressAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new RestoreInProgressAllocationDecider());
        ClusterModule.addAllocationDecider(deciders, new FilterAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new SameShardAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new DiskThresholdDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ThrottlingAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ShardsLimitAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new AwarenessAllocationDecider(settings, clusterSettings));
        clusterPlugins.stream().flatMap(p -> p.createAllocationDeciders(settings, clusterSettings).stream()).forEach(d -> ClusterModule.addAllocationDecider(deciders, d));
        return deciders.values();
    }

    private static void addAllocationDecider(Map<Class, AllocationDecider> deciders, AllocationDecider decider) {
        if (deciders.put(decider.getClass(), decider) != null) {
            throw new IllegalArgumentException("Cannot specify allocation decider [" + decider.getClass().getName() + "] twice");
        }
    }

    private static ShardsAllocator createShardsAllocator(Settings settings, ClusterSettings clusterSettings, List<ClusterPlugin> clusterPlugins) {
        HashMap<String, Supplier<ShardsAllocator>> allocators = new HashMap<String, Supplier<ShardsAllocator>>();
        allocators.put(BALANCED_ALLOCATOR, () -> new BalancedShardsAllocator(settings, clusterSettings));
        for (ClusterPlugin plugin : clusterPlugins) {
            plugin.getShardsAllocators(settings, clusterSettings).forEach((k, v) -> {
                if (allocators.put((String)k, (Supplier<ShardsAllocator>)v) != null) {
                    throw new IllegalArgumentException("ShardsAllocator [" + k + "] already defined");
                }
            });
        }
        String allocatorName = SHARDS_ALLOCATOR_TYPE_SETTING.get(settings);
        Supplier allocatorSupplier = (Supplier)allocators.get(allocatorName);
        if (allocatorSupplier == null) {
            throw new IllegalArgumentException("Unknown ShardsAllocator [" + allocatorName + "]");
        }
        return Objects.requireNonNull((ShardsAllocator)allocatorSupplier.get(), "ShardsAllocator factory for [" + allocatorName + "] returned null");
    }

    public AllocationService getAllocationService() {
        return this.allocationService;
    }

    public MetadataDeleteIndexService getMetadataDeleteIndexService() {
        return this.metadataDeleteIndexService;
    }

    @Override
    protected void configure() {
        this.bind(GatewayAllocator.class).asEagerSingleton();
        this.bind(AllocationService.class).toInstance(this.allocationService);
        this.bind(ClusterService.class).toInstance(this.clusterService);
        this.bind(NodeConnectionsService.class).asEagerSingleton();
        this.bind(MetadataDeleteIndexService.class).toInstance(this.metadataDeleteIndexService);
        this.bind(MetadataIndexStateService.class).asEagerSingleton();
        this.bind(MetadataMappingService.class).asEagerSingleton();
        this.bind(MetadataIndexAliasesService.class).asEagerSingleton();
        this.bind(MetadataUpdateSettingsService.class).asEagerSingleton();
        this.bind(MetadataIndexTemplateService.class).asEagerSingleton();
        this.bind(IndexNameExpressionResolver.class).toInstance(this.indexNameExpressionResolver);
        this.bind(DelayedAllocationService.class).asEagerSingleton();
        this.bind(ShardStateAction.class).asEagerSingleton();
        this.bind(MappingUpdatedAction.class).asEagerSingleton();
        this.bind(TaskResultsService.class).asEagerSingleton();
        this.bind(AllocationDeciders.class).toInstance(this.allocationDeciders);
        this.bind(ShardsAllocator.class).toInstance(this.shardsAllocator);
    }

    public void setExistingShardsAllocators(GatewayAllocator gatewayAllocator) {
        HashMap<String, ExistingShardsAllocator> existingShardsAllocators = new HashMap<String, ExistingShardsAllocator>();
        existingShardsAllocators.put("gateway_allocator", gatewayAllocator);
        for (ClusterPlugin clusterPlugin : this.clusterPlugins) {
            for (Map.Entry<String, ExistingShardsAllocator> existingShardsAllocatorEntry : clusterPlugin.getExistingShardsAllocators().entrySet()) {
                String allocatorName = existingShardsAllocatorEntry.getKey();
                if (existingShardsAllocators.put(allocatorName, existingShardsAllocatorEntry.getValue()) == null) continue;
                throw new IllegalArgumentException("ExistingShardsAllocator [" + allocatorName + "] from [" + clusterPlugin.getClass().getName() + "] was already defined");
            }
        }
        this.allocationService.setExistingShardsAllocators(existingShardsAllocators);
    }
}

