/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateRequest;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportResetFeatureStateAction
extends HandledTransportAction<ResetFeatureStateRequest, ResetFeatureStateResponse> {
    private final SystemIndices systemIndices;
    private final NodeClient client;
    private final ClusterService clusterService;

    @Inject
    public TransportResetFeatureStateAction(TransportService transportService, ActionFilters actionFilters, SystemIndices systemIndices, NodeClient client, ClusterService clusterService) {
        super("cluster:admin/features/reset", transportService, actionFilters, ResetFeatureStateRequest::new);
        this.systemIndices = systemIndices;
        this.client = client;
        this.clusterService = clusterService;
    }

    @Override
    protected void doExecute(Task task, ResetFeatureStateRequest request, ActionListener<ResetFeatureStateResponse> listener) {
        if (this.systemIndices.getFeatures().size() == 0) {
            listener.onResponse(new ResetFeatureStateResponse(Collections.emptyList()));
        }
        int features = this.systemIndices.getFeatures().size();
        GroupedActionListener groupedActionListener = new GroupedActionListener(listener.map(responses -> {
            assert (features == responses.size());
            return new ResetFeatureStateResponse(new ArrayList<ResetFeatureStateResponse.ResetFeatureStateStatus>((Collection<ResetFeatureStateResponse.ResetFeatureStateStatus>)responses));
        }), this.systemIndices.getFeatures().size());
        for (SystemIndices.Feature feature : this.systemIndices.getFeatures().values()) {
            feature.getCleanUpFunction().apply(this.clusterService, this.client, groupedActionListener);
        }
    }
}

