/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.features;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ResetFeatureStateResponse
extends ActionResponse
implements ToXContentObject {
    List<ResetFeatureStateStatus> resetFeatureStateStatusList;

    public ResetFeatureStateResponse(List<ResetFeatureStateStatus> resetFeatureStateStatuses) {
        this.resetFeatureStateStatusList = new ArrayList<ResetFeatureStateStatus>();
        this.resetFeatureStateStatusList.addAll(resetFeatureStateStatuses);
        this.resetFeatureStateStatusList.sort(Comparator.comparing(ResetFeatureStateStatus::getFeatureName));
    }

    public ResetFeatureStateResponse(StreamInput in) throws IOException {
        super(in);
        this.resetFeatureStateStatusList = in.readList(ResetFeatureStateStatus::new);
    }

    public List<ResetFeatureStateStatus> getFeatureStateResetStatuses() {
        return Collections.unmodifiableList(this.resetFeatureStateStatusList);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("features");
        for (ResetFeatureStateStatus resetFeatureStateStatus : this.resetFeatureStateStatusList) {
            builder.value((Object)resetFeatureStateStatus);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.resetFeatureStateStatusList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResetFeatureStateResponse that = (ResetFeatureStateResponse)o;
        return Objects.equals(this.resetFeatureStateStatusList, that.resetFeatureStateStatusList);
    }

    public int hashCode() {
        return Objects.hash(this.resetFeatureStateStatusList);
    }

    public String toString() {
        return "ResetFeatureStateResponse{resetFeatureStateStatusList=" + this.resetFeatureStateStatusList + '}';
    }

    public static class ResetFeatureStateStatus
    implements Writeable,
    ToXContentObject {
        private final String featureName;
        private final Status status;
        private final Exception exception;

        public static ResetFeatureStateStatus success(String featureName) {
            return new ResetFeatureStateStatus(featureName, Status.SUCCESS, null);
        }

        public static ResetFeatureStateStatus failure(String featureName, Exception exception) {
            return new ResetFeatureStateStatus(featureName, Status.FAILURE, exception);
        }

        private ResetFeatureStateStatus(String featureName, Status status, @Nullable Exception exception) {
            this.featureName = featureName;
            this.status = status;
            assert (!Status.FAILURE.equals((Object)status) ? Objects.isNull(exception) : Objects.nonNull(exception));
            this.exception = exception;
        }

        ResetFeatureStateStatus(StreamInput in) throws IOException {
            this.featureName = in.readString();
            this.status = Status.valueOf(in.readString());
            this.exception = in.readBoolean() ? in.readException() : null;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public Status getStatus() {
            return this.status;
        }

        @Nullable
        public Exception getException() {
            return this.exception;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("feature_name", this.featureName);
            builder.field("status", (Object)this.status);
            if (Objects.nonNull(this.exception)) {
                builder.field("exception");
                builder.startObject();
                new ElasticsearchException(this.exception).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResetFeatureStateStatus that = (ResetFeatureStateStatus)o;
            return Objects.equals(this.featureName, that.featureName) && this.status == that.status;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.featureName, this.status});
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.featureName);
            out.writeString(this.status.toString());
            if (this.exception != null) {
                out.writeBoolean(true);
                out.writeException(this.exception);
            } else {
                out.writeBoolean(false);
            }
        }

        public String toString() {
            return "ResetFeatureStateStatus{featureName='" + this.featureName + '\'' + ", status=" + (Object)((Object)this.status) + ", exception='" + this.exception + '\'' + '}';
        }

        public static enum Status {
            SUCCESS,
            FAILURE;

        }
    }
}

