/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValueType;

public class MultiValuesSourceFieldConfig
implements Writeable,
ToXContentObject {
    private final String fieldName;
    private final Object missing;
    private final Script script;
    private final ZoneId timeZone;
    private final QueryBuilder filter;
    private final ValueType userValueTypeHint;
    private final String format;
    private static final String NAME = "field_config";
    public static final ParseField FILTER = new ParseField("filter", new String[0]);
    public static final ParserBuilder PARSER = (scriptable, timezoneAware, filtered, heterogeneous) -> {
        ObjectParser parser = new ObjectParser(NAME, Builder::new);
        parser.declareString(Builder::setFieldName, ParseField.CommonFields.FIELD);
        parser.declareField(Builder::setMissing, XContentParser::objectText, ParseField.CommonFields.MISSING, ObjectParser.ValueType.VALUE);
        if (scriptable) {
            parser.declareField(Builder::setScript, (p, context) -> Script.parse(p), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        }
        if (timezoneAware) {
            parser.declareField(Builder::setTimeZone, p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return ZoneId.of(p.text());
                }
                return ZoneOffset.ofHours(p.intValue());
            }, ParseField.CommonFields.TIME_ZONE, ObjectParser.ValueType.LONG);
        }
        if (filtered) {
            parser.declareField(Builder::setFilter, (p, context) -> AbstractQueryBuilder.parseInnerQueryBuilder(p), FILTER, ObjectParser.ValueType.OBJECT);
        }
        if (heterogeneous) {
            parser.declareField(Builder::setUserValueTypeHint, p -> ValueType.lenientParse(p.text()), ValueType.VALUE_TYPE, ObjectParser.ValueType.STRING);
            parser.declareField(Builder::setFormat, XContentParser::text, ParseField.CommonFields.FORMAT, ObjectParser.ValueType.STRING);
        }
        return parser;
    };

    protected MultiValuesSourceFieldConfig(String fieldName, Object missing, Script script, ZoneId timeZone, QueryBuilder filter, ValueType userValueTypeHint, String format) {
        this.fieldName = fieldName;
        this.missing = missing;
        this.script = script;
        this.timeZone = timeZone;
        this.filter = filter;
        this.userValueTypeHint = userValueTypeHint;
        this.format = format;
    }

    public MultiValuesSourceFieldConfig(StreamInput in) throws IOException {
        this.fieldName = in.getVersion().onOrAfter(Version.V_7_6_0) ? in.readOptionalString() : in.readString();
        this.missing = in.readGenericValue();
        this.script = in.readOptionalWriteable(Script::new);
        this.timeZone = in.getVersion().before(Version.V_7_0_0) ? DateUtils.dateTimeZoneToZoneId(in.readOptionalTimeZone()) : in.readOptionalZoneId();
        this.filter = in.getVersion().onOrAfter(Version.V_7_8_0) ? in.readOptionalNamedWriteable(QueryBuilder.class) : null;
        if (in.getVersion().onOrAfter(Version.V_7_12_0)) {
            this.userValueTypeHint = in.readOptionalWriteable(ValueType::readFromStream);
            this.format = in.readOptionalString();
        } else {
            this.userValueTypeHint = null;
            this.format = null;
        }
    }

    public Object getMissing() {
        return this.missing;
    }

    public Script getScript() {
        return this.script;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public QueryBuilder getFilter() {
        return this.filter;
    }

    public ValueType getUserValueTypeHint() {
        return this.userValueTypeHint;
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
            out.writeOptionalString(this.fieldName);
        } else {
            out.writeString(this.fieldName);
        }
        out.writeGenericValue(this.missing);
        out.writeOptionalWriteable(this.script);
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalTimeZone(DateUtils.zoneIdToDateTimeZone(this.timeZone));
        } else {
            out.writeOptionalZoneId(this.timeZone);
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeOptionalNamedWriteable(this.filter);
        }
        if (out.getVersion().onOrAfter(Version.V_7_12_0)) {
            out.writeOptionalWriteable(this.userValueTypeHint);
            out.writeOptionalString(this.format);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.missing != null) {
            builder.field(ParseField.CommonFields.MISSING.getPreferredName(), this.missing);
        }
        if (this.script != null) {
            builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), (ToXContent)this.script);
        }
        if (this.fieldName != null) {
            builder.field(ParseField.CommonFields.FIELD.getPreferredName(), this.fieldName);
        }
        if (this.timeZone != null) {
            builder.field(ParseField.CommonFields.TIME_ZONE.getPreferredName(), this.timeZone.getId());
        }
        if (this.filter != null) {
            builder.field(FILTER.getPreferredName());
            this.filter.toXContent(builder, params);
        }
        if (this.userValueTypeHint != null) {
            builder.field(AggregationBuilder.CommonFields.VALUE_TYPE.getPreferredName(), this.userValueTypeHint.getPreferredName());
        }
        if (this.format != null) {
            builder.field(AggregationBuilder.CommonFields.FORMAT.getPreferredName(), this.format);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiValuesSourceFieldConfig that = (MultiValuesSourceFieldConfig)o;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.missing, that.missing) && Objects.equals(this.script, that.script) && Objects.equals(this.timeZone, that.timeZone) && Objects.equals(this.filter, that.filter) && Objects.equals(this.userValueTypeHint, that.userValueTypeHint) && Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.missing, this.script, this.timeZone, this.filter, this.userValueTypeHint, this.format);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static interface ParserBuilder {
        public ObjectParser<Builder, Void> build(boolean var1, boolean var2, boolean var3, boolean var4);
    }

    public static class Builder {
        private String fieldName;
        private Object missing = null;
        private Script script = null;
        private ZoneId timeZone = null;
        private QueryBuilder filter = null;
        private ValueType userValueTypeHint = null;
        private String format = null;

        public String getFieldName() {
            return this.fieldName;
        }

        public Builder setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Object getMissing() {
            return this.missing;
        }

        public Builder setMissing(Object missing) {
            this.missing = missing;
            return this;
        }

        public Script getScript() {
            return this.script;
        }

        public Builder setScript(Script script) {
            this.script = script;
            return this;
        }

        public ZoneId getTimeZone() {
            return this.timeZone;
        }

        public Builder setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder setFilter(QueryBuilder filter) {
            this.filter = filter;
            return this;
        }

        public Builder setUserValueTypeHint(ValueType userValueTypeHint) {
            this.userValueTypeHint = userValueTypeHint;
            return this;
        }

        public ValueType getUserValueTypeHint() {
            return this.userValueTypeHint;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public String getFormat() {
            return this.format;
        }

        public MultiValuesSourceFieldConfig build() {
            if (Strings.isNullOrEmpty(this.fieldName) && this.script == null) {
                throw new IllegalArgumentException("[" + ParseField.CommonFields.FIELD.getPreferredName() + "] and [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] cannot both be null.  Please specify one or the other.");
            }
            if (!Strings.isNullOrEmpty(this.fieldName) && this.script != null) {
                throw new IllegalArgumentException("[" + ParseField.CommonFields.FIELD.getPreferredName() + "] and [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] cannot both be configured.  Please specify one or the other.");
            }
            return new MultiValuesSourceFieldConfig(this.fieldName, this.missing, this.script, this.timeZone, this.filter, this.userValueTypeHint, this.format);
        }
    }
}

