/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.ESLogMessage;

public class DeprecatedMessage
extends ESLogMessage {
    public static final String X_OPAQUE_ID_FIELD_NAME = "x-opaque-id";

    public DeprecatedMessage(DeprecationCategory category, String key, String xOpaqueId, String messagePattern, Object ... args) {
        super(DeprecatedMessage.fieldMap(category, key, xOpaqueId), messagePattern, args);
    }

    private static Map<String, Object> fieldMap(DeprecationCategory category, String key, String xOpaqueId) {
        MapBuilder<String, String> builder = MapBuilder.newMapBuilder();
        Objects.requireNonNull(category, "category cannot be null");
        builder.put("category", category.name().toLowerCase(Locale.ROOT));
        if (!Strings.isNullOrEmpty(key)) {
            builder.put("key", key);
        }
        if (!Strings.isNullOrEmpty(xOpaqueId)) {
            builder.put(X_OPAQUE_ID_FIELD_NAME, xOpaqueId);
        }
        return builder.immutableMap();
    }
}

