/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;

class BytesReferenceStreamInput
extends StreamInput {
    protected final BytesReference bytesReference;
    private BytesRefIterator iterator;
    private int sliceIndex;
    private BytesRef slice;
    private int sliceStartOffset;
    private int mark = 0;

    BytesReferenceStreamInput(BytesReference bytesReference) throws IOException {
        this.bytesReference = bytesReference;
        this.iterator = bytesReference.iterator();
        this.slice = this.iterator.next();
        this.sliceStartOffset = 0;
        this.sliceIndex = 0;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.offset() >= this.bytesReference.length()) {
            throw new EOFException();
        }
        this.maybeNextSlice();
        return this.slice.bytes[this.slice.offset + this.sliceIndex++];
    }

    protected int offset() {
        return this.sliceStartOffset + this.sliceIndex;
    }

    private void maybeNextSlice() throws IOException {
        while (this.sliceIndex == this.slice.length) {
            this.sliceStartOffset += this.sliceIndex;
            this.slice = this.iterator.next();
            this.sliceIndex = 0;
            if (this.slice != null) continue;
            throw new EOFException();
        }
    }

    @Override
    public void readBytes(byte[] b, int bOffset, int len) throws IOException {
        int length = this.bytesReference.length();
        int offset = this.offset();
        if (offset + len > length) {
            throw new IndexOutOfBoundsException("Cannot read " + len + " bytes from stream with length " + length + " at offset " + offset);
        }
        int bytesRead = this.read(b, bOffset, len);
        assert (bytesRead == len) : bytesRead + " vs " + len;
    }

    @Override
    public int read() throws IOException {
        if (this.offset() >= this.bytesReference.length()) {
            return -1;
        }
        return Byte.toUnsignedInt(this.readByte());
    }

    @Override
    public int read(byte[] b, int bOffset, int len) throws IOException {
        int numBytesToCopy;
        int length = this.bytesReference.length();
        int offset = this.offset();
        if (offset >= length) {
            return -1;
        }
        int remaining = numBytesToCopy = Math.min(len, length - offset);
        int destOffset = bOffset;
        while (remaining > 0) {
            this.maybeNextSlice();
            int currentLen = Math.min(remaining, this.slice.length - this.sliceIndex);
            assert (currentLen > 0) : "length has to be > 0 to make progress but was: " + currentLen;
            System.arraycopy(this.slice.bytes, this.slice.offset + this.sliceIndex, b, destOffset, currentLen);
            destOffset += currentLen;
            this.sliceIndex += currentLen;
            assert ((remaining -= currentLen) >= 0) : "remaining: " + remaining;
        }
        return numBytesToCopy;
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        return this.bytesReference.length() - this.offset();
    }

    @Override
    protected void ensureCanReadBytes(int bytesToRead) throws EOFException {
        int bytesAvailable = this.bytesReference.length() - this.offset();
        if (bytesAvailable < bytesToRead) {
            throw new EOFException("tried to read: " + bytesToRead + " bytes but only " + bytesAvailable + " remaining");
        }
    }

    @Override
    public long skip(long n) throws IOException {
        int numBytesSkipped;
        if (n <= 0L) {
            return 0L;
        }
        assert (this.offset() <= this.bytesReference.length()) : this.offset() + " vs " + this.bytesReference.length();
        int remaining = numBytesSkipped = (int)Math.min(n, (long)(this.bytesReference.length() - this.offset()));
        while (remaining > 0) {
            this.maybeNextSlice();
            int currentLen = Math.min(remaining, this.slice.length - this.sliceIndex);
            this.sliceIndex += currentLen;
            assert ((remaining -= currentLen) >= 0) : "remaining: " + remaining;
        }
        return numBytesSkipped;
    }

    @Override
    public void reset() throws IOException {
        if (this.sliceStartOffset <= this.mark) {
            this.sliceIndex = this.mark - this.sliceStartOffset;
        } else {
            this.iterator = this.bytesReference.iterator();
            this.slice = this.iterator.next();
            this.sliceStartOffset = 0;
            this.sliceIndex = 0;
            long skipped = this.skip(this.mark);
            assert (skipped == (long)this.mark) : skipped + " vs " + this.mark;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        this.mark = this.offset();
    }
}

