/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

package org.elasticsearch.index.fielddata;


import org.elasticsearch.search.aggregations.support.ValuesSourceType;

/**
 * Specialization of {@link IndexFieldData} for histograms.
 */
public abstract class IndexHistogramFieldData implements IndexFieldData<LeafHistogramFieldData> {
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;

    public IndexHistogramFieldData(String fieldName, ValuesSourceType valuesSourceType) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
    }

    @Override
    public final String getFieldName() {
        return fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return valuesSourceType;
    }

}
