/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

package org.elasticsearch.action.support.master;

import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

/**
 * A base class for read operations that needs to be performed on the master node.
 * Can also be executed on the local node if needed.
 */
public abstract class TransportMasterNodeReadAction<Request extends MasterNodeReadRequest<Request>, Response extends ActionResponse>
        extends TransportMasterNodeAction<Request, Response> {

    protected TransportMasterNodeReadAction(String actionName, TransportService transportService,
                                            ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters,
                                            Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver,
                                            Writeable.Reader<Response> response, String executor) {
        this(actionName, true, transportService, clusterService, threadPool, actionFilters, request, indexNameExpressionResolver,
                response, executor);
    }

    protected TransportMasterNodeReadAction(String actionName, boolean checkSizeLimit, TransportService transportService,
                                            ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters,
                                            Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver,
                                            Writeable.Reader<Response> response, String executor) {
        super(actionName, checkSizeLimit, transportService, clusterService, threadPool, actionFilters, request,
            indexNameExpressionResolver, response, executor);
    }

    @Override
    protected final boolean localExecute(Request request) {
        return request.local();
    }
}
