/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.SearchSortValuesAndFormats;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.MinAndMax;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortFieldAndFormat;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;

public class FieldSortBuilder
extends SortBuilder<FieldSortBuilder> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(FieldSortBuilder.class);
    public static final String NAME = "field_sort";
    public static final ParseField MISSING = new ParseField("missing", new String[0]);
    public static final ParseField SORT_MODE = new ParseField("mode", new String[0]);
    public static final ParseField UNMAPPED_TYPE = new ParseField("unmapped_type", new String[0]);
    public static final ParseField NUMERIC_TYPE = new ParseField("numeric_type", new String[0]);
    public static final String DOC_FIELD_NAME = "_doc";
    private static final SortFieldAndFormat SORT_DOC = new SortFieldAndFormat(new SortField(null, SortField.Type.DOC), DocValueFormat.RAW);
    private static final SortFieldAndFormat SORT_DOC_REVERSE = new SortFieldAndFormat(new SortField(null, SortField.Type.DOC, true), DocValueFormat.RAW);
    private final String fieldName;
    private Object missing;
    private String unmappedType;
    private String numericType;
    private SortMode sortMode;
    private QueryBuilder nestedFilter;
    private String nestedPath;
    private NestedSortBuilder nestedSort;
    private static final ObjectParser<FieldSortBuilder, Void> PARSER = new ObjectParser("field_sort");

    public FieldSortBuilder(FieldSortBuilder template) {
        this(template.fieldName);
        this.order(template.order());
        this.missing(template.missing());
        this.unmappedType(template.unmappedType());
        if (template.sortMode != null) {
            this.sortMode(template.sortMode());
        }
        this.setNestedFilter(template.getNestedFilter());
        this.setNestedPath(template.getNestedPath());
        if (template.getNestedSort() != null) {
            this.setNestedSort(template.getNestedSort());
        }
        this.numericType = template.numericType;
    }

    public FieldSortBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        this.fieldName = fieldName;
    }

    public FieldSortBuilder(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        this.nestedFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nestedPath = in.readOptionalString();
        this.missing = in.readGenericValue();
        this.order = in.readOptionalWriteable(SortOrder::readFromStream);
        this.sortMode = in.readOptionalWriteable(SortMode::readFromStream);
        this.unmappedType = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.nestedSort = in.readOptionalWriteable(NestedSortBuilder::new);
        }
        if (in.getVersion().onOrAfter(Version.V_7_2_0)) {
            this.numericType = in.readOptionalString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeOptionalNamedWriteable(this.nestedFilter);
        out.writeOptionalString(this.nestedPath);
        out.writeGenericValue(this.missing);
        out.writeOptionalWriteable(this.order);
        out.writeOptionalWriteable(this.sortMode);
        out.writeOptionalString(this.unmappedType);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeOptionalWriteable(this.nestedSort);
        }
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeOptionalString(this.numericType);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldSortBuilder missing(Object missing) {
        this.missing = missing;
        return this;
    }

    public Object missing() {
        return this.missing;
    }

    public FieldSortBuilder unmappedType(String type) {
        this.unmappedType = type;
        return this;
    }

    public String unmappedType() {
        return this.unmappedType;
    }

    public FieldSortBuilder sortMode(SortMode sortMode) {
        Objects.requireNonNull(sortMode, "sort mode cannot be null");
        this.sortMode = sortMode;
        return this;
    }

    public SortMode sortMode() {
        return this.sortMode;
    }

    @Deprecated
    public FieldSortBuilder setNestedFilter(QueryBuilder nestedFilter) {
        if (this.nestedSort != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedFilter = nestedFilter;
        return this;
    }

    @Deprecated
    public QueryBuilder getNestedFilter() {
        return this.nestedFilter;
    }

    @Deprecated
    public FieldSortBuilder setNestedPath(String nestedPath) {
        if (this.nestedSort != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedPath = nestedPath;
        return this;
    }

    @Deprecated
    public String getNestedPath() {
        return this.nestedPath;
    }

    public NestedSortBuilder getNestedSort() {
        return this.nestedSort;
    }

    public FieldSortBuilder setNestedSort(NestedSortBuilder nestedSort) {
        if (this.nestedFilter != null || this.nestedPath != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedSort = nestedSort;
        return this;
    }

    public String getNumericType() {
        return this.numericType;
    }

    public FieldSortBuilder setNumericType(String numericType) {
        String lowerCase;
        switch (lowerCase = numericType.toLowerCase(Locale.ENGLISH)) {
            case "long": 
            case "double": 
            case "date": 
            case "date_nanos": {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid value for [numeric_type], must be [long, double, date, date_nanos], got " + lowerCase);
            }
        }
        this.numericType = lowerCase;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.fieldName);
        builder.field(ORDER_FIELD.getPreferredName(), (Object)this.order);
        if (this.missing != null) {
            builder.field(MISSING.getPreferredName(), this.missing);
        }
        if (this.unmappedType != null) {
            builder.field(UNMAPPED_TYPE.getPreferredName(), this.unmappedType);
        }
        if (this.sortMode != null) {
            builder.field(SORT_MODE.getPreferredName(), (Object)this.sortMode);
        }
        if (this.nestedFilter != null) {
            builder.field(NESTED_FILTER_FIELD.getPreferredName(), (ToXContent)this.nestedFilter, params);
        }
        if (this.nestedPath != null) {
            builder.field(NESTED_PATH_FIELD.getPreferredName(), this.nestedPath);
        }
        if (this.nestedSort != null) {
            builder.field(NestedSortBuilder.NESTED_FIELD.getPreferredName(), (ToXContent)this.nestedSort);
        }
        if (this.numericType != null) {
            builder.field(NUMERIC_TYPE.getPreferredName(), this.numericType);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static IndexNumericFieldData.NumericType resolveNumericType(String value) {
        switch (value) {
            case "long": {
                return IndexNumericFieldData.NumericType.LONG;
            }
            case "double": {
                return IndexNumericFieldData.NumericType.DOUBLE;
            }
            case "date": {
                return IndexNumericFieldData.NumericType.DATE;
            }
            case "date_nanos": {
                return IndexNumericFieldData.NumericType.DATE_NANOSECONDS;
            }
        }
        throw new IllegalArgumentException("invalid value for [numeric_type], must be [long, double, date, date_nanos], got " + value);
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) throws IOException {
        SortField field;
        if (DOC_FIELD_NAME.equals(this.fieldName)) {
            return this.order == SortOrder.DESC ? SORT_DOC_REVERSE : SORT_DOC;
        }
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        IndexFieldData.XFieldComparatorSource.Nested nested = this.nested(context, fieldType);
        if (fieldType == null) {
            fieldType = this.resolveUnmappedType(context);
        }
        boolean reverse = this.order == SortOrder.DESC;
        Object fieldData = context.getForField(fieldType);
        if (!(fieldData instanceof IndexNumericFieldData || this.sortMode != SortMode.SUM && this.sortMode != SortMode.AVG && this.sortMode != SortMode.MEDIAN)) {
            throw new QueryShardException(context, "we only support AVG, MEDIAN and SUM on number based fields", new Object[0]);
        }
        boolean isNanosecond = false;
        if (this.numericType != null) {
            if (!(fieldData instanceof IndexNumericFieldData)) {
                throw new QueryShardException(context, "[numeric_type] option cannot be set on a non-numeric field, got " + fieldType.typeName(), new Object[0]);
            }
            IndexNumericFieldData numericFieldData = (IndexNumericFieldData)fieldData;
            IndexNumericFieldData.NumericType resolvedType = FieldSortBuilder.resolveNumericType(this.numericType);
            field = numericFieldData.sortField(resolvedType, this.missing, this.localSortMode(), nested, reverse);
            isNanosecond = resolvedType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS;
        } else {
            field = fieldData.sortField(this.missing, this.localSortMode(), nested, reverse);
            if (fieldData instanceof IndexNumericFieldData) {
                isNanosecond = ((IndexNumericFieldData)fieldData).getNumericType() == IndexNumericFieldData.NumericType.DATE_NANOSECONDS;
            }
        }
        DocValueFormat format = fieldType.docValueFormat(null, null);
        if (isNanosecond) {
            format = DocValueFormat.withNanosecondResolution(format);
        }
        return new SortFieldAndFormat(field, format);
    }

    public boolean canRewriteToMatchNone() {
        return this.nestedSort == null && (this.missing == null || "_last".equals(this.missing));
    }

    public boolean isBottomSortShardDisjoint(QueryShardContext context, SearchSortValuesAndFormats bottomSortValues) throws IOException {
        if (bottomSortValues == null || bottomSortValues.getRawSortValues().length == 0) {
            return false;
        }
        if (!this.canRewriteToMatchNone()) {
            return false;
        }
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            return false;
        }
        if (!fieldType.isSearchable()) {
            return false;
        }
        DocValueFormat docValueFormat = bottomSortValues.getSortValueFormats()[0];
        DateMathParser dateMathParser = docValueFormat instanceof DocValueFormat.DateTime ? ((DocValueFormat.DateTime)docValueFormat).getDateMathParser() : null;
        Object bottomSortValue = bottomSortValues.getFormattedSortValues()[0];
        Object minValue = this.order() == SortOrder.DESC ? bottomSortValue : null;
        Object maxValue = this.order() == SortOrder.DESC ? null : bottomSortValue;
        try {
            MappedFieldType.Relation relation = fieldType.isFieldWithinQuery(context.getIndexReader(), minValue, maxValue, true, true, null, dateMathParser, context);
            return relation == MappedFieldType.Relation.DISJOINT;
        }
        catch (ElasticsearchParseException exc) {
            return false;
        }
    }

    @Override
    public BucketedSort buildBucketedSort(QueryShardContext context, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
        Object fieldData;
        if (DOC_FIELD_NAME.equals(this.fieldName)) {
            throw new IllegalArgumentException("sorting by _doc is not supported");
        }
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        IndexFieldData.XFieldComparatorSource.Nested nested = this.nested(context, fieldType);
        if (fieldType == null) {
            fieldType = this.resolveUnmappedType(context);
        }
        if (!((fieldData = context.getForField(fieldType)) instanceof IndexNumericFieldData || this.sortMode != SortMode.SUM && this.sortMode != SortMode.AVG && this.sortMode != SortMode.MEDIAN)) {
            throw new QueryShardException(context, "we only support AVG, MEDIAN and SUM on number based fields", new Object[0]);
        }
        if (this.numericType != null) {
            if (!(fieldData instanceof IndexNumericFieldData)) {
                throw new QueryShardException(context, "[numeric_type] option cannot be set on a non-numeric field, got " + fieldType.typeName(), new Object[0]);
            }
            IndexNumericFieldData numericFieldData = (IndexNumericFieldData)fieldData;
            IndexNumericFieldData.NumericType resolvedType = FieldSortBuilder.resolveNumericType(this.numericType);
            return numericFieldData.newBucketedSort(resolvedType, context.bigArrays(), this.missing, this.localSortMode(), nested, this.order, fieldType.docValueFormat(null, null), bucketSize, extra);
        }
        try {
            return fieldData.newBucketedSort(context.bigArrays(), this.missing, this.localSortMode(), nested, this.order, fieldType.docValueFormat(null, null), bucketSize, extra);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("error building sort for field [" + this.fieldName + "] of type [" + fieldType.typeName() + "] in index [" + context.index().getName() + "]: " + e.getMessage(), e);
        }
    }

    private MappedFieldType resolveUnmappedType(QueryShardContext context) {
        if (this.unmappedType == null) {
            throw new QueryShardException(context, "No mapping found for [" + this.fieldName + "] in order to sort on", new Object[0]);
        }
        return context.buildAnonymousFieldType(this.unmappedType);
    }

    private MultiValueMode localSortMode() {
        if (this.sortMode != null) {
            return MultiValueMode.fromString(this.sortMode.toString());
        }
        return this.order == SortOrder.DESC ? MultiValueMode.MAX : MultiValueMode.MIN;
    }

    private IndexFieldData.XFieldComparatorSource.Nested nested(QueryShardContext context, MappedFieldType fieldType) throws IOException {
        if (fieldType == null) {
            return null;
        }
        if (this.nestedSort == null) {
            return FieldSortBuilder.resolveNested(context, this.nestedPath, this.nestedFilter);
        }
        if (context.indexVersionCreated().before(Version.V_6_5_0) && this.nestedSort.getMaxChildren() != Integer.MAX_VALUE) {
            throw new QueryShardException(context, "max_children is only supported on v6.5.0 or higher", new Object[0]);
        }
        FieldSortBuilder.validateMaxChildrenExistOnlyInTopLevelNestedSort(context, this.nestedSort);
        return FieldSortBuilder.resolveNested(context, this.nestedSort);
    }

    public static boolean hasPrimaryFieldSort(SearchSourceBuilder source) {
        return FieldSortBuilder.getPrimaryFieldSortOrNull(source) != null;
    }

    public static FieldSortBuilder getPrimaryFieldSortOrNull(SearchSourceBuilder source) {
        if (source == null || source.sorts() == null || source.sorts().isEmpty()) {
            return null;
        }
        return source.sorts().get(0) instanceof FieldSortBuilder ? (FieldSortBuilder)source.sorts().get(0) : null;
    }

    public static MinAndMax<?> getMinMaxOrNull(QueryShardContext context, FieldSortBuilder sortBuilder) throws IOException {
        SortAndFormats sort = SortBuilder.buildSort(Collections.singletonList(sortBuilder), context).get();
        SortField sortField = sort.sort.getSort()[0];
        if (sortField.getField() == null) {
            return null;
        }
        IndexReader reader = context.getIndexReader();
        MappedFieldType fieldType = context.getFieldType(sortField.getField());
        if (reader == null || fieldType == null || !fieldType.isSearchable()) {
            return null;
        }
        switch (IndexSortConfig.getSortFieldType(sortField)) {
            case LONG: 
            case INT: 
            case DOUBLE: 
            case FLOAT: {
                return FieldSortBuilder.extractNumericMinAndMax(reader, sortField, fieldType, sortBuilder);
            }
            case STRING: 
            case STRING_VAL: {
                if (!(fieldType instanceof KeywordFieldMapper.KeywordFieldType)) break;
                Terms terms = MultiTerms.getTerms((IndexReader)reader, (String)fieldType.name());
                if (terms == null) {
                    return null;
                }
                return terms.getMin() != null ? new MinAndMax<BytesRef>(terms.getMin(), terms.getMax()) : null;
            }
        }
        return null;
    }

    private static MinAndMax<?> extractNumericMinAndMax(IndexReader reader, SortField sortField, MappedFieldType fieldType, FieldSortBuilder sortBuilder) throws IOException {
        String fieldName = fieldType.name();
        if (PointValues.size((IndexReader)reader, (String)fieldName) == 0L) {
            return null;
        }
        if (fieldType instanceof NumberFieldMapper.NumberFieldType) {
            NumberFieldMapper.NumberFieldType numberFieldType = (NumberFieldMapper.NumberFieldType)fieldType;
            Number minPoint = numberFieldType.parsePoint(PointValues.getMinPackedValue((IndexReader)reader, (String)fieldName));
            Number maxPoint = numberFieldType.parsePoint(PointValues.getMaxPackedValue((IndexReader)reader, (String)fieldName));
            switch (IndexSortConfig.getSortFieldType(sortField)) {
                case LONG: {
                    return new MinAndMax<Long>(minPoint.longValue(), maxPoint.longValue());
                }
                case INT: {
                    return new MinAndMax<Integer>(minPoint.intValue(), maxPoint.intValue());
                }
                case DOUBLE: {
                    return new MinAndMax<Double>(minPoint.doubleValue(), maxPoint.doubleValue());
                }
                case FLOAT: {
                    return new MinAndMax<Float>(Float.valueOf(minPoint.floatValue()), Float.valueOf(maxPoint.floatValue()));
                }
            }
            return null;
        }
        if (fieldType instanceof DateFieldMapper.DateFieldType) {
            DateFieldMapper.DateFieldType dateFieldType = (DateFieldMapper.DateFieldType)fieldType;
            Function<byte[], Long> dateConverter = FieldSortBuilder.createDateConverter(sortBuilder, dateFieldType);
            Long min = dateConverter.apply(PointValues.getMinPackedValue((IndexReader)reader, (String)fieldName));
            Long max = dateConverter.apply(PointValues.getMaxPackedValue((IndexReader)reader, (String)fieldName));
            return new MinAndMax<Long>(min, max);
        }
        return null;
    }

    private static Function<byte[], Long> createDateConverter(FieldSortBuilder sortBuilder, DateFieldMapper.DateFieldType dateFieldType) {
        String numericTypeStr = sortBuilder.getNumericType();
        if (numericTypeStr != null) {
            IndexNumericFieldData.NumericType numericType = FieldSortBuilder.resolveNumericType(numericTypeStr);
            if (dateFieldType.resolution() == DateFieldMapper.Resolution.MILLISECONDS && numericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS) {
                return v -> DateUtils.toNanoSeconds(LongPoint.decodeDimension((byte[])v, (int)0));
            }
            if (dateFieldType.resolution() == DateFieldMapper.Resolution.NANOSECONDS && numericType == IndexNumericFieldData.NumericType.DATE) {
                return v -> DateUtils.toMilliSeconds(LongPoint.decodeDimension((byte[])v, (int)0));
            }
        }
        return v -> LongPoint.decodeDimension((byte[])v, (int)0);
    }

    static void validateMaxChildrenExistOnlyInTopLevelNestedSort(QueryShardContext context, NestedSortBuilder nestedSort) {
        for (NestedSortBuilder child = nestedSort.getNestedSort(); child != null; child = child.getNestedSort()) {
            if (child.getMaxChildren() == Integer.MAX_VALUE) continue;
            throw new QueryShardException(context, "max_children is only supported on top level of nested sort", new Object[0]);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FieldSortBuilder builder = (FieldSortBuilder)other;
        return Objects.equals(this.fieldName, builder.fieldName) && Objects.equals(this.nestedFilter, builder.nestedFilter) && Objects.equals(this.nestedPath, builder.nestedPath) && Objects.equals(this.missing, builder.missing) && Objects.equals(this.order, builder.order) && Objects.equals(this.sortMode, builder.sortMode) && Objects.equals(this.unmappedType, builder.unmappedType) && Objects.equals(this.nestedSort, builder.nestedSort) && Objects.equals(this.numericType, builder.numericType);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.nestedFilter, this.nestedPath, this.nestedSort, this.missing, this.order, this.sortMode, this.unmappedType, this.numericType);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public static FieldSortBuilder fromXContent(XContentParser parser, String fieldName) throws IOException {
        return (FieldSortBuilder)PARSER.parse(parser, (Object)new FieldSortBuilder(fieldName), null);
    }

    @Override
    public FieldSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.nestedFilter == null && this.nestedSort == null) {
            return this;
        }
        if (this.nestedFilter != null) {
            QueryBuilder rewrite = this.nestedFilter.rewrite(ctx);
            if (this.nestedFilter == rewrite) {
                return this;
            }
            return new FieldSortBuilder(this).setNestedFilter(rewrite);
        }
        NestedSortBuilder rewrite = this.nestedSort.rewrite(ctx);
        if (this.nestedSort == rewrite) {
            return this;
        }
        return new FieldSortBuilder(this).setNestedSort(rewrite);
    }

    static {
        PARSER.declareField(FieldSortBuilder::missing, XContentParser::objectText, MISSING, ObjectParser.ValueType.VALUE);
        PARSER.declareString((fieldSortBuilder, nestedPath) -> {
            deprecationLogger.deprecate("field_sort_nested_path", "[nested_path] has been deprecated in favor of the [nested] parameter", new Object[0]);
            fieldSortBuilder.setNestedPath((String)nestedPath);
        }, NESTED_PATH_FIELD);
        PARSER.declareString(FieldSortBuilder::unmappedType, UNMAPPED_TYPE);
        PARSER.declareString((b, v) -> b.order(SortOrder.fromString(v)), ORDER_FIELD);
        PARSER.declareString((b, v) -> b.sortMode(SortMode.fromString(v)), SORT_MODE);
        PARSER.declareObject(FieldSortBuilder::setNestedFilter, (p, c) -> {
            deprecationLogger.deprecate("field_sort_nested_filter", "[nested_filter] has been deprecated in favour for the [nested] parameter", new Object[0]);
            return SortBuilder.parseNestedFilter(p);
        }, NESTED_FILTER_FIELD);
        PARSER.declareObject(FieldSortBuilder::setNestedSort, (p, c) -> NestedSortBuilder.fromXContent(p), NestedSortBuilder.NESTED_FIELD);
        PARSER.declareString(FieldSortBuilder::setNumericType, NUMERIC_TYPE);
    }
}

