/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class FieldFetcher {
    private final Map<String, FieldContext> fieldContexts;
    private final CharacterRunAutomaton unmappedFetchAutomaton;
    private final boolean includeUnmapped;

    public static FieldFetcher create(QueryShardContext context, SearchLookup searchLookup, Collection<FieldAndFormat> fieldAndFormats) {
        LinkedHashMap<String, FieldContext> fieldContexts = new LinkedHashMap<String, FieldContext>();
        ArrayList<String> unmappedFetchPattern = new ArrayList<String>();
        boolean includeUnmapped = false;
        for (FieldAndFormat fieldAndFormat : fieldAndFormats) {
            String fieldPattern = fieldAndFormat.field;
            if (fieldAndFormat.includeUnmapped != null && fieldAndFormat.includeUnmapped.booleanValue()) {
                unmappedFetchPattern.add(fieldAndFormat.field);
                includeUnmapped = true;
            }
            String format = fieldAndFormat.format;
            Set<String> concreteFields = context.simpleMatchToIndexNames(fieldPattern);
            for (String field : concreteFields) {
                MappedFieldType ft = context.getFieldType(field);
                if (ft == null || context.isMetadataField(field)) continue;
                ValueFetcher valueFetcher = ft.valueFetcher(context, format);
                fieldContexts.put(field, new FieldContext(field, valueFetcher));
            }
        }
        CharacterRunAutomaton unmappedFetchAutomaton = new CharacterRunAutomaton(Automata.makeEmpty());
        if (!unmappedFetchPattern.isEmpty()) {
            unmappedFetchAutomaton = new CharacterRunAutomaton(Regex.simpleMatchToAutomaton(unmappedFetchPattern.toArray(new String[unmappedFetchPattern.size()])));
        }
        return new FieldFetcher(fieldContexts, unmappedFetchAutomaton, includeUnmapped);
    }

    private FieldFetcher(Map<String, FieldContext> fieldContexts, CharacterRunAutomaton unmappedFetchAutomaton, boolean includeUnmapped) {
        this.fieldContexts = fieldContexts;
        this.unmappedFetchAutomaton = unmappedFetchAutomaton;
        this.includeUnmapped = includeUnmapped;
    }

    public Map<String, DocumentField> fetch(SourceLookup sourceLookup, Set<String> ignoredFields) throws IOException {
        HashMap<String, DocumentField> documentFields = new HashMap<String, DocumentField>();
        for (FieldContext context : this.fieldContexts.values()) {
            ValueFetcher valueFetcher;
            List<Object> parsedValues;
            String field = context.fieldName;
            if (ignoredFields.contains(field) || (parsedValues = (valueFetcher = context.valueFetcher).fetchValues(sourceLookup)).isEmpty()) continue;
            documentFields.put(field, new DocumentField(field, parsedValues));
        }
        if (this.includeUnmapped) {
            this.collectUnmapped(documentFields, sourceLookup.loadSourceIfNeeded(), "", 0);
        }
        return documentFields;
    }

    private void collectUnmapped(Map<String, DocumentField> documentFields, Map<String, Object> source, String parentPath, int lastState) {
        for (String key : source.keySet()) {
            Object value = source.get(key);
            String currentPath = parentPath + key;
            int currentState = FieldFetcher.step(this.unmappedFetchAutomaton, key, lastState);
            if (currentState == -1) continue;
            if (value instanceof Map) {
                this.collectUnmapped(documentFields, (Map)value, currentPath + ".", FieldFetcher.step(this.unmappedFetchAutomaton, ".", currentState));
                continue;
            }
            if (value instanceof List) {
                this.collectUnmappedList(documentFields, (List)value, currentPath, currentState);
                continue;
            }
            if (!this.unmappedFetchAutomaton.isAccept(currentState) || this.fieldContexts.containsKey(currentPath) || value == null) continue;
            DocumentField currentEntry = documentFields.get(currentPath);
            if (currentEntry == null) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(value);
                documentFields.put(currentPath, new DocumentField(currentPath, list));
                continue;
            }
            currentEntry.getValues().add(value);
        }
    }

    private void collectUnmappedList(Map<String, DocumentField> documentFields, Iterable<?> iterable, String parentPath, int lastState) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : iterable) {
            if (value instanceof Map) {
                this.collectUnmapped(documentFields, (Map)value, parentPath + ".", FieldFetcher.step(this.unmappedFetchAutomaton, ".", lastState));
                continue;
            }
            if (value instanceof List) {
                this.collectUnmappedList(documentFields, (List)value, parentPath, lastState);
                continue;
            }
            if (!this.unmappedFetchAutomaton.isAccept(lastState) || this.fieldContexts.containsKey(parentPath)) continue;
            list.add(value);
        }
        if (!list.isEmpty()) {
            DocumentField currentEntry = documentFields.get(parentPath);
            if (currentEntry == null) {
                documentFields.put(parentPath, new DocumentField(parentPath, list));
            } else {
                currentEntry.getValues().addAll(list);
            }
        }
    }

    private static int step(CharacterRunAutomaton automaton, String key, int state) {
        for (int i = 0; state != -1 && i < key.length(); ++i) {
            state = automaton.step(state, (int)key.charAt(i));
        }
        return state;
    }

    public void setNextReader(LeafReaderContext readerContext) {
        for (FieldContext field : this.fieldContexts.values()) {
            field.valueFetcher.setNextReader(readerContext);
        }
    }

    private static class FieldContext {
        final String fieldName;
        final ValueFetcher valueFetcher;

        FieldContext(String fieldName, ValueFetcher valueFetcher) {
            this.fieldName = fieldName;
            this.valueFetcher = valueFetcher;
        }
    }
}

