/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;

public class FetchDocValuesContext {
    private final List<FieldAndFormat> fields = new ArrayList<FieldAndFormat>();

    public FetchDocValuesContext(QueryShardContext shardContext, List<FieldAndFormat> fieldPatterns) {
        for (FieldAndFormat field : fieldPatterns) {
            Set<String> fieldNames = shardContext.simpleMatchToIndexNames(field.field);
            for (String fieldName : fieldNames) {
                if (!shardContext.isFieldMapped(fieldName)) continue;
                this.fields.add(new FieldAndFormat(fieldName, field.format, field.includeUnmapped));
            }
        }
        int maxAllowedDocvalueFields = shardContext.getIndexSettings().getMaxDocvalueFields();
        if (this.fields.size() > maxAllowedDocvalueFields) {
            throw new IllegalArgumentException("Trying to retrieve too many docvalue_fields. Must be less than or equal to: [" + maxAllowedDocvalueFields + "] but was [" + this.fields.size() + "]. This limit can be set by changing the [" + IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING.getKey() + "] index level setting.");
        }
    }

    public List<FieldAndFormat> fields() {
        return this.fields;
    }
}

