/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.HashMap;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.profile.aggregation.InternalAggregationProfileTree;

public abstract class AdaptingAggregator
extends Aggregator {
    private final Aggregator parent;
    private final Aggregator delegate;

    public AdaptingAggregator(Aggregator parent, AggregatorFactories subAggregators, CheckedFunction<AggregatorFactories, Aggregator, IOException> delegate) throws IOException {
        this.parent = parent;
        this.delegate = (Aggregator)delegate.apply((Object)subAggregators.fixParent(this));
        assert (this.delegate.parent() == parent) : "invalid parent set on delegate";
    }

    protected abstract InternalAggregation adapt(InternalAggregation var1);

    @Override
    public final void close() {
        this.delegate.close();
    }

    public final ScoreMode scoreMode() {
        return this.delegate.scoreMode();
    }

    @Override
    public final String name() {
        return this.delegate.name();
    }

    @Override
    public final Aggregator parent() {
        return this.parent;
    }

    @Override
    public final Aggregator subAggregator(String name) {
        return this.delegate.subAggregator(name);
    }

    @Override
    public final LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        return this.delegate.getLeafCollector(ctx);
    }

    @Override
    public final void preCollection() throws IOException {
        this.delegate.preCollection();
    }

    @Override
    public final void postCollection() throws IOException {
        this.delegate.postCollection();
    }

    @Override
    public final InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        InternalAggregation[] delegateResults = this.delegate.buildAggregations(owningBucketOrds);
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            result[ordIdx] = this.adapt(delegateResults[ordIdx]);
        }
        return result;
    }

    @Override
    public final InternalAggregation buildEmptyAggregation() {
        return this.adapt(this.delegate.buildEmptyAggregation());
    }

    @Override
    public final Aggregator[] subAggregators() {
        return this.delegate.subAggregators();
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("delegate", InternalAggregationProfileTree.typeFromAggregator(this.delegate));
        HashMap delegateDebug = new HashMap();
        this.delegate.collectDebugInfo(delegateDebug::put);
        add.accept("delegate_debug", delegateDebug);
    }

    public Aggregator delegate() {
        return this.delegate;
    }
}

