/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.ObjectObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DynamicRuntimeFieldsBuilder;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RuntimeFieldType;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;

public abstract class ParseContext {
    public abstract Iterable<Document> nonRootDocuments();

    public abstract void addIgnoredField(String var1);

    public abstract Collection<String> getIgnoredFields();

    public abstract Mapper.TypeParser.ParserContext parserContext(DateFormatter var1);

    public final ParseContext createCopyToContext() {
        return new FilterParseContext(this){

            @Override
            public boolean isWithinCopyTo() {
                return true;
            }
        };
    }

    public boolean isWithinCopyTo() {
        return false;
    }

    public final ParseContext createMultiFieldContext() {
        return new FilterParseContext(this){

            @Override
            public boolean isWithinMultiFields() {
                return true;
            }
        };
    }

    public final ParseContext createNestedContext(String fullPath) {
        Document doc = new Document(fullPath, this.doc());
        this.addDoc(doc);
        return this.switchDoc(doc);
    }

    public final ParseContext switchDoc(final Document document) {
        return new FilterParseContext(this){

            @Override
            public Document doc() {
                return document;
            }
        };
    }

    public final ParseContext overridePath(final ContentPath path) {
        return new FilterParseContext(this){

            @Override
            public ContentPath path() {
                return path;
            }
        };
    }

    public boolean isWithinMultiFields() {
        return false;
    }

    public abstract IndexSettings indexSettings();

    public abstract SourceToParse sourceToParse();

    public abstract ContentPath path();

    public abstract XContentParser parser();

    public abstract Document rootDoc();

    public abstract List<Document> docs();

    public abstract Document doc();

    protected abstract void addDoc(Document var1);

    public abstract RootObjectMapper root();

    public abstract DocumentMapper docMapper();

    public abstract IndexAnalyzers indexAnalyzers();

    public abstract Field version();

    public abstract void version(Field var1);

    public abstract SeqNoFieldMapper.SequenceIDFields seqID();

    public abstract void seqID(SeqNoFieldMapper.SequenceIDFields var1);

    public final ParseContext createExternalValueContext(final Object externalValue) {
        return new FilterParseContext(this){

            @Override
            public boolean externalValueSet() {
                return true;
            }

            @Override
            public Object externalValue() {
                return externalValue;
            }
        };
    }

    public boolean externalValueSet() {
        return false;
    }

    public Object externalValue() {
        throw new IllegalStateException("External value is not set");
    }

    public final <T> T parseExternalValue(Class<T> clazz) {
        if (!this.externalValueSet() || this.externalValue() == null) {
            return null;
        }
        if (!clazz.isInstance(this.externalValue())) {
            throw new IllegalArgumentException("illegal external value class [" + this.externalValue().getClass().getName() + "]. Should be " + clazz.getName());
        }
        return clazz.cast(this.externalValue());
    }

    public abstract void addDynamicMapper(Mapper var1);

    public abstract ObjectMapper getObjectMapper(String var1);

    public abstract List<Mapper> getDynamicMappers();

    public abstract void addDynamicRuntimeField(RuntimeFieldType var1);

    public abstract List<RuntimeFieldType> getDynamicRuntimeFields();

    public abstract DynamicRuntimeFieldsBuilder getDynamicRuntimeFieldsBuilder();

    public static class Document
    implements Iterable<IndexableField> {
        private final Document parent;
        private final String path;
        private final String prefix;
        private final List<IndexableField> fields = new ArrayList<IndexableField>();
        private ObjectObjectMap<Object, IndexableField> keyedFields;

        private Document(String path, Document parent) {
            this.path = path;
            this.prefix = path.isEmpty() ? "" : path + ".";
            this.parent = parent;
        }

        public Document() {
            this("", null);
        }

        public String getPath() {
            return this.path;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Document getParent() {
            return this.parent;
        }

        @Override
        public Iterator<IndexableField> iterator() {
            return this.fields.iterator();
        }

        public List<IndexableField> getFields() {
            return this.fields;
        }

        public void addAll(List<? extends IndexableField> fields) {
            this.fields.addAll(fields);
        }

        public void add(IndexableField field) {
            assert (field.name().startsWith("_") || field.name().startsWith(this.prefix)) : field.name() + " " + this.prefix;
            this.fields.add(field);
        }

        public void addWithKey(Object key, IndexableField field) {
            if (this.keyedFields == null) {
                this.keyedFields = new ObjectObjectHashMap();
            } else if (this.keyedFields.containsKey(key)) {
                throw new IllegalStateException("Only one field can be stored per key");
            }
            this.keyedFields.put(key, (Object)field);
            this.add(field);
        }

        public IndexableField getByKey(Object key) {
            return this.keyedFields == null ? null : (IndexableField)this.keyedFields.get(key);
        }

        public IndexableField[] getFields(String name) {
            ArrayList<IndexableField> f = new ArrayList<IndexableField>();
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name)) continue;
                f.add(field);
            }
            return f.toArray(new IndexableField[f.size()]);
        }

        public IndexableField getField(String name) {
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name)) continue;
                return field;
            }
            return null;
        }

        public String get(String name) {
            for (IndexableField f : this.fields) {
                if (!f.name().equals(name) || f.stringValue() == null) continue;
                return f.stringValue();
            }
            return null;
        }

        public BytesRef getBinaryValue(String name) {
            for (IndexableField f : this.fields) {
                if (!f.name().equals(name) || f.binaryValue() == null) continue;
                return f.binaryValue();
            }
            return null;
        }
    }

    public static class InternalParseContext
    extends ParseContext {
        private final DocumentMapper docMapper;
        private final Function<DateFormatter, Mapper.TypeParser.ParserContext> parserContextFunction;
        private final ContentPath path = new ContentPath(0);
        private final XContentParser parser;
        private final Document document;
        private final List<Document> documents = new ArrayList<Document>();
        private final SourceToParse sourceToParse;
        private final long maxAllowedNumNestedDocs;
        private final List<Mapper> dynamicMappers = new ArrayList<Mapper>();
        private final Map<String, ObjectMapper> dynamicObjectMappers = new HashMap<String, ObjectMapper>();
        private final List<RuntimeFieldType> dynamicRuntimeFields = new ArrayList<RuntimeFieldType>();
        private final DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder;
        private final Set<String> ignoredFields = new HashSet<String>();
        private Field version;
        private SeqNoFieldMapper.SequenceIDFields seqID;
        private long numNestedDocs;
        private boolean docsReversed = false;

        public InternalParseContext(DocumentMapper docMapper, Function<DateFormatter, Mapper.TypeParser.ParserContext> parserContextFunction, DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder, SourceToParse source, XContentParser parser) {
            this.docMapper = docMapper;
            this.parserContextFunction = parserContextFunction;
            this.dynamicRuntimeFieldsBuilder = dynamicRuntimeFieldsBuilder;
            this.parser = parser;
            this.document = new Document();
            this.documents.add(this.document);
            this.version = null;
            this.sourceToParse = source;
            this.maxAllowedNumNestedDocs = docMapper.indexSettings().getMappingNestedDocsLimit();
            this.numNestedDocs = 0L;
        }

        @Override
        public Mapper.TypeParser.ParserContext parserContext(DateFormatter dateFormatter) {
            return this.parserContextFunction.apply(dateFormatter);
        }

        @Override
        public IndexSettings indexSettings() {
            return this.docMapper.indexSettings();
        }

        @Override
        public SourceToParse sourceToParse() {
            return this.sourceToParse;
        }

        @Override
        public ContentPath path() {
            return this.path;
        }

        @Override
        public XContentParser parser() {
            return this.parser;
        }

        @Override
        public Document rootDoc() {
            return this.documents.get(0);
        }

        @Override
        public List<Document> docs() {
            return this.documents;
        }

        @Override
        public Document doc() {
            return this.document;
        }

        @Override
        protected void addDoc(Document doc) {
            ++this.numNestedDocs;
            if (this.numNestedDocs > this.maxAllowedNumNestedDocs) {
                throw new MapperParsingException("The number of nested documents has exceeded the allowed limit of [" + this.maxAllowedNumNestedDocs + "]. This limit can be set by changing the [" + MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING.getKey() + "] index level setting.");
            }
            this.documents.add(doc);
        }

        @Override
        public RootObjectMapper root() {
            return this.docMapper.root();
        }

        @Override
        public DocumentMapper docMapper() {
            return this.docMapper;
        }

        @Override
        public IndexAnalyzers indexAnalyzers() {
            return this.docMapper.indexAnalyzers();
        }

        @Override
        public Field version() {
            return this.version;
        }

        @Override
        public void version(Field version) {
            this.version = version;
        }

        @Override
        public SeqNoFieldMapper.SequenceIDFields seqID() {
            return this.seqID;
        }

        @Override
        public void seqID(SeqNoFieldMapper.SequenceIDFields seqID) {
            this.seqID = seqID;
        }

        @Override
        public void addDynamicMapper(Mapper mapper) {
            if (mapper instanceof ObjectMapper) {
                this.dynamicObjectMappers.put(mapper.name(), (ObjectMapper)mapper);
            }
            this.dynamicMappers.add(mapper);
        }

        @Override
        public List<Mapper> getDynamicMappers() {
            return this.dynamicMappers;
        }

        @Override
        public ObjectMapper getObjectMapper(String name) {
            return this.dynamicObjectMappers.get(name);
        }

        @Override
        public void addDynamicRuntimeField(RuntimeFieldType runtimeField) {
            this.dynamicRuntimeFields.add(runtimeField);
        }

        @Override
        public List<RuntimeFieldType> getDynamicRuntimeFields() {
            return Collections.unmodifiableList(this.dynamicRuntimeFields);
        }

        @Override
        public DynamicRuntimeFieldsBuilder getDynamicRuntimeFieldsBuilder() {
            return this.dynamicRuntimeFieldsBuilder;
        }

        @Override
        public Iterable<Document> nonRootDocuments() {
            if (this.docsReversed) {
                throw new IllegalStateException("documents are already reversed");
            }
            return this.documents.subList(1, this.documents.size());
        }

        void postParse() {
            if (this.documents.size() > 1) {
                this.docsReversed = true;
                if (this.indexSettings().getIndexVersionCreated().onOrAfter(Version.V_6_5_0)) {
                    List<Document> newDocs = this.reorderParent(this.documents);
                    this.documents.clear();
                    this.documents.addAll(newDocs);
                } else {
                    Collections.reverse(this.documents);
                }
            }
        }

        private List<Document> reorderParent(List<Document> docs) {
            ArrayList<Document> newDocs = new ArrayList<Document>(docs.size());
            LinkedList<Document> parents = new LinkedList<Document>();
            for (Document doc : docs) {
                while (parents.peek() != doc.getParent()) {
                    newDocs.add((Document)parents.poll());
                }
                parents.add(0, doc);
            }
            newDocs.addAll(parents);
            return newDocs;
        }

        @Override
        public void addIgnoredField(String field) {
            this.ignoredFields.add(field);
        }

        @Override
        public Collection<String> getIgnoredFields() {
            return Collections.unmodifiableCollection(this.ignoredFields);
        }
    }

    private static class FilterParseContext
    extends ParseContext {
        private final ParseContext in;

        private FilterParseContext(ParseContext in) {
            this.in = in;
        }

        @Override
        public ObjectMapper getObjectMapper(String name) {
            return this.in.getObjectMapper(name);
        }

        @Override
        public Iterable<Document> nonRootDocuments() {
            return this.in.nonRootDocuments();
        }

        @Override
        public Mapper.TypeParser.ParserContext parserContext(DateFormatter dateFormatter) {
            return this.in.parserContext(dateFormatter);
        }

        @Override
        public boolean isWithinCopyTo() {
            return this.in.isWithinCopyTo();
        }

        @Override
        public boolean isWithinMultiFields() {
            return this.in.isWithinMultiFields();
        }

        @Override
        public IndexSettings indexSettings() {
            return this.in.indexSettings();
        }

        @Override
        public SourceToParse sourceToParse() {
            return this.in.sourceToParse();
        }

        @Override
        public ContentPath path() {
            return this.in.path();
        }

        @Override
        public XContentParser parser() {
            return this.in.parser();
        }

        @Override
        public Document rootDoc() {
            return this.in.rootDoc();
        }

        @Override
        public List<Document> docs() {
            return this.in.docs();
        }

        @Override
        public Document doc() {
            return this.in.doc();
        }

        @Override
        protected void addDoc(Document doc) {
            this.in.addDoc(doc);
        }

        @Override
        public RootObjectMapper root() {
            return this.in.root();
        }

        @Override
        public DocumentMapper docMapper() {
            return this.in.docMapper();
        }

        @Override
        public IndexAnalyzers indexAnalyzers() {
            return this.in.indexAnalyzers();
        }

        @Override
        public Field version() {
            return this.in.version();
        }

        @Override
        public void version(Field version) {
            this.in.version(version);
        }

        @Override
        public SeqNoFieldMapper.SequenceIDFields seqID() {
            return this.in.seqID();
        }

        @Override
        public void seqID(SeqNoFieldMapper.SequenceIDFields seqID) {
            this.in.seqID(seqID);
        }

        @Override
        public boolean externalValueSet() {
            return this.in.externalValueSet();
        }

        @Override
        public Object externalValue() {
            return this.in.externalValue();
        }

        @Override
        public void addDynamicMapper(Mapper update) {
            this.in.addDynamicMapper(update);
        }

        @Override
        public List<Mapper> getDynamicMappers() {
            return this.in.getDynamicMappers();
        }

        @Override
        public void addDynamicRuntimeField(RuntimeFieldType runtimeField) {
            this.in.addDynamicRuntimeField(runtimeField);
        }

        @Override
        public List<RuntimeFieldType> getDynamicRuntimeFields() {
            return this.in.getDynamicRuntimeFields();
        }

        @Override
        public DynamicRuntimeFieldsBuilder getDynamicRuntimeFieldsBuilder() {
            return this.in.getDynamicRuntimeFieldsBuilder();
        }

        @Override
        public void addIgnoredField(String field) {
            this.in.addIgnoredField(field);
        }

        @Override
        public Collection<String> getIgnoredFields() {
            return this.in.getIgnoredFields();
        }
    }
}

