/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RuntimeFieldType;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;

public class MappingLookup {
    public static final MappingLookup EMPTY = new MappingLookup("_doc", List.of(), List.of(), List.of(), List.of(), 0, soucreToParse -> null, false);
    private final CacheKey cacheKey = new CacheKey();
    private final Map<String, Mapper> fieldMappers;
    private final Map<String, ObjectMapper> objectMappers;
    private final boolean hasNested;
    private final FieldTypeLookup fieldTypeLookup;
    private final int metadataFieldCount;
    private final Map<String, NamedAnalyzer> indexAnalyzers = new HashMap<String, NamedAnalyzer>();
    private final Function<SourceToParse, ParsedDocument> documentParser;
    private final boolean sourceEnabled;

    public static MappingLookup fromMapping(Mapping mapping, Function<SourceToParse, ParsedDocument> documentParser) {
        ArrayList<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
        ArrayList<FieldAliasMapper> newFieldAliasMappers = new ArrayList<FieldAliasMapper>();
        for (MetadataFieldMapper metadataMapper : mapping.metadataMappers) {
            if (metadataMapper == null) continue;
            newFieldMappers.add(metadataMapper);
        }
        for (Mapper child : mapping.root) {
            MappingLookup.collect(child, newObjectMappers, newFieldMappers, newFieldAliasMappers);
        }
        return new MappingLookup(mapping.root().name(), newFieldMappers, newObjectMappers, newFieldAliasMappers, mapping.root.runtimeFieldTypes(), mapping.metadataMappers.length, documentParser, mapping.metadataMapper(SourceFieldMapper.class).enabled());
    }

    private static void collect(Mapper mapper, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        if (mapper instanceof ObjectMapper) {
            objectMappers.add((ObjectMapper)mapper);
        } else if (mapper instanceof FieldMapper) {
            fieldMappers.add((FieldMapper)mapper);
        } else if (mapper instanceof FieldAliasMapper) {
            fieldAliasMappers.add((FieldAliasMapper)mapper);
        } else {
            throw new IllegalStateException("Unrecognized mapper type [" + mapper.getClass().getSimpleName() + "].");
        }
        for (Mapper child : mapper) {
            MappingLookup.collect(child, objectMappers, fieldMappers, fieldAliasMappers);
        }
    }

    public MappingLookup(String type, Collection<FieldMapper> mappers, Collection<ObjectMapper> objectMappers, Collection<FieldAliasMapper> aliasMappers, Collection<RuntimeFieldType> runtimeFieldTypes, int metadataFieldCount, Function<SourceToParse, ParsedDocument> documentParser, boolean sourceEnabled) {
        this.documentParser = documentParser;
        this.sourceEnabled = sourceEnabled;
        HashMap<String, Mapper> fieldMappers = new HashMap<String, Mapper>();
        HashMap<String, ObjectMapper> objects = new HashMap<String, ObjectMapper>();
        boolean hasNested = false;
        for (ObjectMapper objectMapper : objectMappers) {
            if (objects.put(objectMapper.fullPath(), objectMapper) != null) {
                throw new MapperParsingException("Object mapper [" + objectMapper.fullPath() + "] is defined more than once");
            }
            if (!objectMapper.nested().isNested()) continue;
            hasNested = true;
        }
        this.hasNested = hasNested;
        for (FieldMapper fieldMapper : mappers) {
            if (objects.containsKey(fieldMapper.name())) {
                throw new MapperParsingException("Field [" + fieldMapper.name() + "] is defined both as an object and a field");
            }
            if (fieldMappers.put(fieldMapper.name(), fieldMapper) != null) {
                throw new MapperParsingException("Field [" + fieldMapper.name() + "] is defined more than once");
            }
            this.indexAnalyzers.putAll(fieldMapper.indexAnalyzers());
        }
        this.metadataFieldCount = metadataFieldCount;
        for (FieldAliasMapper fieldAliasMapper : aliasMappers) {
            if (objects.containsKey(fieldAliasMapper.name())) {
                throw new MapperParsingException("Alias [" + fieldAliasMapper.name() + "] is defined both as an object and an alias");
            }
            if (fieldMappers.put(fieldAliasMapper.name(), fieldAliasMapper) == null) continue;
            throw new MapperParsingException("Alias [" + fieldAliasMapper.name() + "] is defined both as an alias and a concrete field");
        }
        this.fieldTypeLookup = new FieldTypeLookup(type, mappers, aliasMappers, runtimeFieldTypes);
        this.fieldMappers = Collections.unmodifiableMap(fieldMappers);
        this.objectMappers = Collections.unmodifiableMap(objects);
    }

    public Mapper getMapper(String field) {
        return this.fieldMappers.get(field);
    }

    FieldTypeLookup fieldTypes() {
        return this.fieldTypeLookup;
    }

    public NamedAnalyzer indexAnalyzer(String field, Function<String, NamedAnalyzer> unmappedFieldAnalyzer) {
        if (this.indexAnalyzers.containsKey(field)) {
            return this.indexAnalyzers.get(field);
        }
        return unmappedFieldAnalyzer.apply(field);
    }

    public Iterable<Mapper> fieldMappers() {
        return this.fieldMappers.values();
    }

    void checkLimits(IndexSettings settings) {
        this.checkFieldLimit(settings.getMappingTotalFieldsLimit());
        this.checkObjectDepthLimit(settings.getMappingDepthLimit());
        this.checkFieldNameLengthLimit(settings.getMappingFieldNameLengthLimit());
        this.checkNestedLimit(settings.getMappingNestedFieldsLimit());
    }

    private void checkFieldLimit(long limit) {
        if ((long)(this.fieldMappers.size() + this.objectMappers.size() - this.metadataFieldCount) > limit) {
            throw new IllegalArgumentException("Limit of total fields [" + limit + "] has been exceeded");
        }
    }

    private void checkObjectDepthLimit(long limit) {
        for (String objectPath : this.objectMappers.keySet()) {
            int numDots = 0;
            for (int i = 0; i < objectPath.length(); ++i) {
                if (objectPath.charAt(i) != '.') continue;
                ++numDots;
            }
            int depth = numDots + 2;
            if ((long)depth <= limit) continue;
            throw new IllegalArgumentException("Limit of mapping depth [" + limit + "] has been exceeded due to object field [" + objectPath + "]");
        }
    }

    private void checkFieldNameLengthLimit(long limit) {
        Stream.of(this.objectMappers.values().stream(), this.fieldMappers.values().stream()).reduce(Stream::concat).orElseGet(Stream::empty).forEach(mapper -> {
            String name = mapper.simpleName();
            if ((long)name.length() > limit) {
                throw new IllegalArgumentException("Field name [" + name + "] is longer than the limit of [" + limit + "] characters");
            }
        });
    }

    private void checkNestedLimit(long limit) {
        long actualNestedFields = 0L;
        for (ObjectMapper objectMapper : this.objectMappers.values()) {
            if (!objectMapper.nested().isNested()) continue;
            ++actualNestedFields;
        }
        if (actualNestedFields > limit) {
            throw new IllegalArgumentException("Limit of nested fields [" + limit + "] has been exceeded");
        }
    }

    public boolean hasNested() {
        return this.hasNested;
    }

    public Map<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public boolean isMultiField(String field) {
        String sourceParent = MappingLookup.parentObject(field);
        return sourceParent != null && this.fieldMappers.containsKey(sourceParent);
    }

    public boolean isObjectField(String field) {
        return this.objectMappers.containsKey(field);
    }

    public String getNestedScope(String path) {
        String parentPath = MappingLookup.parentObject(path);
        while (parentPath != null) {
            ObjectMapper objectMapper = this.objectMappers.get(parentPath);
            if (objectMapper != null && objectMapper.nested().isNested()) {
                return parentPath;
            }
            parentPath = MappingLookup.parentObject(parentPath);
        }
        return null;
    }

    private static String parentObject(String field) {
        int lastDot = field.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return field.substring(0, lastDot);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        return this.fieldTypes().simpleMatchToFullName(pattern);
    }

    public MappedFieldType getFieldType(String field) {
        return this.fieldTypes().get(field);
    }

    public Set<String> sourcePaths(String field) {
        return this.fieldTypes().sourcePaths(field);
    }

    public ParsedDocument parseDocument(SourceToParse source) {
        return this.documentParser.apply(source);
    }

    public boolean hasMappings() {
        return this != EMPTY;
    }

    public boolean isSourceEnabled() {
        return this.sourceEnabled;
    }

    public CacheKey cacheKey() {
        return this.cacheKey;
    }

    public String getType() {
        return this.fieldTypes().getType();
    }

    public static class CacheKey {
        private CacheKey() {
        }
    }
}

