/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.RuntimeFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.script.ScriptService;

public abstract class Mapper
implements ToXContentFragment,
Iterable<Mapper> {
    private final String simpleName;

    public Mapper(String simpleName) {
        Objects.requireNonNull(simpleName);
        this.simpleName = simpleName;
    }

    public final String simpleName() {
        return this.simpleName;
    }

    public abstract String name();

    public abstract String typeName();

    public abstract Mapper merge(Mapper var1);

    public abstract void validate(MappingLookup var1);

    public static interface TypeParser {
        public Builder parse(String var1, Map<String, Object> var2, ParserContext var3) throws MapperParsingException;

        public static class ParserContext {
            private final Function<String, SimilarityProvider> similarityLookupService;
            private final Function<String, TypeParser> typeParsers;
            private final Function<String, RuntimeFieldType.Parser> runtimeTypeParsers;
            private final boolean supportsDynamicRuntimeMappings;
            private final Version indexVersionCreated;
            private final Supplier<QueryShardContext> queryShardContextSupplier;
            private final DateFormatter dateFormatter;
            private final ScriptService scriptService;
            private final IndexAnalyzers indexAnalyzers;
            private final IndexSettings indexSettings;
            private final BooleanSupplier idFieldDataEnabled;

            public ParserContext(Function<String, SimilarityProvider> similarityLookupService, Function<String, TypeParser> typeParsers, Function<String, RuntimeFieldType.Parser> runtimeTypeParsers, Version indexVersionCreated, Supplier<QueryShardContext> queryShardContextSupplier, DateFormatter dateFormatter, ScriptService scriptService, IndexAnalyzers indexAnalyzers, IndexSettings indexSettings, BooleanSupplier idFieldDataEnabled, boolean supportsDynamicRuntimeMappings) {
                this.similarityLookupService = similarityLookupService;
                this.typeParsers = typeParsers;
                this.runtimeTypeParsers = runtimeTypeParsers;
                this.indexVersionCreated = indexVersionCreated;
                this.queryShardContextSupplier = queryShardContextSupplier;
                this.dateFormatter = dateFormatter;
                this.scriptService = scriptService;
                this.indexAnalyzers = indexAnalyzers;
                this.indexSettings = indexSettings;
                this.idFieldDataEnabled = idFieldDataEnabled;
                this.supportsDynamicRuntimeMappings = supportsDynamicRuntimeMappings;
            }

            public IndexAnalyzers getIndexAnalyzers() {
                return this.indexAnalyzers;
            }

            public IndexSettings getIndexSettings() {
                return this.indexSettings;
            }

            public BooleanSupplier isIdFieldDataEnabled() {
                return this.idFieldDataEnabled;
            }

            public Settings getSettings() {
                return this.indexSettings.getSettings();
            }

            public SimilarityProvider getSimilarity(String name) {
                return this.similarityLookupService.apply(name);
            }

            public TypeParser typeParser(String type) {
                return this.typeParsers.apply(type);
            }

            public RuntimeFieldType.Parser runtimeFieldTypeParser(String type) {
                return this.runtimeTypeParsers.apply(type);
            }

            public boolean supportsDynamicRuntimeMappings() {
                return this.supportsDynamicRuntimeMappings;
            }

            public Version indexVersionCreated() {
                return this.indexVersionCreated;
            }

            public Supplier<QueryShardContext> queryShardContextSupplier() {
                return this.queryShardContextSupplier;
            }

            public DateFormatter getDateFormatter() {
                return this.dateFormatter;
            }

            public boolean isWithinMultiField() {
                return false;
            }

            public boolean isFromDynamicTemplate() {
                return false;
            }

            protected Function<String, SimilarityProvider> similarityLookupService() {
                return this.similarityLookupService;
            }

            public ScriptService scriptService() {
                return this.scriptService;
            }

            ParserContext createMultiFieldContext(ParserContext in) {
                return new MultiFieldParserContext(in);
            }

            ParserContext createDynamicTemplateFieldContext(ParserContext in) {
                return new DynamicTemplateParserContext(in);
            }

            private static class MultiFieldParserContext
            extends ParserContext {
                MultiFieldParserContext(ParserContext in) {
                    super(in.similarityLookupService, in.typeParsers, in.runtimeTypeParsers, in.indexVersionCreated, in.queryShardContextSupplier, in.dateFormatter, in.scriptService, in.indexAnalyzers, in.indexSettings, in.idFieldDataEnabled, in.supportsDynamicRuntimeMappings);
                }

                @Override
                public boolean isWithinMultiField() {
                    return true;
                }
            }

            private static class DynamicTemplateParserContext
            extends ParserContext {
                DynamicTemplateParserContext(ParserContext in) {
                    super(in.similarityLookupService, in.typeParsers, in.runtimeTypeParsers, in.indexVersionCreated, in.queryShardContextSupplier, in.dateFormatter, in.scriptService, in.indexAnalyzers, in.indexSettings, in.idFieldDataEnabled, in.supportsDynamicRuntimeMappings);
                }

                @Override
                public boolean isFromDynamicTemplate() {
                    return true;
                }
            }
        }
    }

    public static abstract class Builder {
        public String name;

        protected Builder(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract Mapper build(ContentPath var1);
    }
}

