/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;

public class DocumentMapperParser {
    private final IndexSettings indexSettings;
    private final IndexAnalyzers indexAnalyzers;
    private final Function<String, String> documentTypeResolver;
    private final DocumentParser documentParser;
    private final Function<String, Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersFunction;
    private final Supplier<Mapper.TypeParser.ParserContext> parserContextSupplier;
    private final RootObjectMapper.TypeParser rootObjectTypeParser = new RootObjectMapper.TypeParser();
    private final Map<String, MetadataFieldMapper.TypeParser> rootTypeParsers;
    private final NamedXContentRegistry xContentRegistry;

    DocumentMapperParser(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, Function<String, String> documentTypeResolver, DocumentParser documentParser, Function<String, Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersFunction, Supplier<Mapper.TypeParser.ParserContext> parserContextSupplier, Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers, NamedXContentRegistry xContentRegistry) {
        this.indexSettings = indexSettings;
        this.indexAnalyzers = indexAnalyzers;
        this.documentTypeResolver = documentTypeResolver;
        this.documentParser = documentParser;
        this.metadataMappersFunction = metadataMappersFunction;
        this.parserContextSupplier = parserContextSupplier;
        this.rootTypeParsers = metadataMapperParsers;
        this.xContentRegistry = xContentRegistry;
    }

    public DocumentMapper parse(@Nullable String type, CompressedXContent source) throws MapperParsingException {
        return this.parse(type, source, null);
    }

    public DocumentMapper parse(@Nullable String type, CompressedXContent source, String defaultSource) throws MapperParsingException {
        Map<String, Object> mapping = null;
        if (source != null) {
            Map root = (Map)XContentHelper.convertToMap(source.compressedReference(), true, XContentType.JSON).v2();
            Tuple<String, Map<String, Object>> t = this.extractMapping(type, root);
            type = (String)t.v1();
            mapping = (Map)t.v2();
        }
        if (mapping == null) {
            mapping = new HashMap<String, Object>();
        }
        return this.parse(type, mapping, defaultSource);
    }

    private DocumentMapper parse(String type, Map<String, Object> mapping, String defaultSource) throws MapperParsingException {
        Tuple<String, Map<String, Object>> t;
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        if (defaultSource != null && (t = this.extractMapping("_default_", defaultSource)).v2() != null) {
            XContentHelper.mergeDefaults(mapping, (Map)t.v2());
        }
        Mapper.TypeParser.ParserContext parserContext = this.parserContextSupplier.get();
        RootObjectMapper.Builder root = (RootObjectMapper.Builder)this.rootObjectTypeParser.parse(type, mapping, parserContext);
        DocumentMapper.Builder docBuilder = new DocumentMapper.Builder(root, this.indexSettings, this.indexAnalyzers, this.documentParser, this.metadataMappersFunction);
        Iterator<Map.Entry<String, Object>> iterator = mapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            Object fieldNode = entry.getValue();
            MetadataFieldMapper.TypeParser typeParser = this.rootTypeParsers.get(fieldName);
            if (typeParser == null) continue;
            iterator.remove();
            if (!(fieldNode instanceof Map)) {
                throw new IllegalArgumentException("[_parent] must be an object containing [type]");
            }
            Map fieldNodeMap = (Map)fieldNode;
            docBuilder.put((MetadataFieldMapper.Builder)typeParser.parse(fieldName, fieldNodeMap, parserContext));
            fieldNodeMap.remove("type");
            DocumentMapperParser.checkNoRemainingFields(fieldName, fieldNodeMap);
        }
        Map meta = (Map)mapping.remove("_meta");
        if (meta != null) {
            docBuilder.meta(Collections.unmodifiableMap(new HashMap(meta)));
        }
        DocumentMapperParser.checkNoRemainingFields(mapping, "Root mapping definition has unsupported parameters: ");
        return docBuilder.build();
    }

    public static void checkNoRemainingFields(String fieldName, Map<?, ?> fieldNodeMap) {
        DocumentMapperParser.checkNoRemainingFields(fieldNodeMap, "Mapping definition for [" + fieldName + "] has unsupported parameters: ");
    }

    public static void checkNoRemainingFields(Map<?, ?> fieldNodeMap, String message) {
        if (!fieldNodeMap.isEmpty()) {
            throw new MapperParsingException(message + DocumentMapperParser.getRemainingFields(fieldNodeMap));
        }
    }

    private static String getRemainingFields(Map<?, ?> map) {
        StringBuilder remainingFields = new StringBuilder();
        for (Object key : map.keySet()) {
            remainingFields.append(" [").append(key).append(" : ").append(map.get(key)).append("]");
        }
        return remainingFields.toString();
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, String source) throws MapperParsingException {
        Map root;
        try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, source);){
            root = parser.mapOrdered();
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse mapping definition", e);
        }
        return this.extractMapping(type, root);
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, Map<String, Object> root) throws MapperParsingException {
        if (root.size() == 0) {
            if (type != null) {
                return new Tuple((Object)type, root);
            }
            throw new MapperParsingException("malformed mapping, no type name found");
        }
        String rootName = root.keySet().iterator().next();
        Tuple mapping = type == null || type.equals(rootName) || this.documentTypeResolver.apply(type).equals(rootName) ? new Tuple((Object)rootName, (Object)((Map)root.get(rootName))) : new Tuple((Object)type, root);
        return mapping;
    }
}

