/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.ObjectArrayList;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.BytesBinaryIndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.CustomDocValuesField;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public class BinaryFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "binary";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean stored;
    private final boolean hasDocValues;

    private static BinaryFieldMapper toType(FieldMapper in) {
        return (BinaryFieldMapper)in;
    }

    protected BinaryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.stored = (Boolean)builder.stored.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        if (!this.stored && !this.hasDocValues) {
            return;
        }
        byte[] value = context.parseExternalValue(byte[].class);
        if (value == null) {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().binaryValue();
        }
        if (value == null) {
            return;
        }
        if (this.stored) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), value));
        }
        if (this.hasDocValues) {
            CustomBinaryDocValuesField field = (CustomBinaryDocValuesField)context.doc().getByKey(this.fieldType().name());
            if (field == null) {
                field = new CustomBinaryDocValuesField(this.fieldType().name(), value);
                context.doc().addWithKey(this.fieldType().name(), field);
            } else {
                field.add(value);
            }
        } else {
            this.createFieldNamesField(context);
        }
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> BinaryFieldMapper.access$300(BinaryFieldMapper.toType(m)), false);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> BinaryFieldMapper.access$200(BinaryFieldMapper.toType(m)), false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            this(name, false);
        }

        public Builder(String name, boolean hasDocValues) {
            super(name);
            this.hasDocValues.setValue(hasDocValues);
        }

        @Override
        public List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.meta, this.stored, this.hasDocValues);
        }

        @Override
        public BinaryFieldMapper build(ContentPath contentPath) {
            return new BinaryFieldMapper(this.name, (MappedFieldType)new BinaryFieldType(this.buildFullName(contentPath), this.stored.getValue(), this.hasDocValues.getValue(), this.meta.getValue()), this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), this);
        }
    }

    public static class CustomBinaryDocValuesField
    extends CustomDocValuesField {
        private final ObjectArrayList<byte[]> bytesList = new ObjectArrayList();
        private int totalSize = 0;

        public CustomBinaryDocValuesField(String name, byte[] bytes) {
            super(name);
            this.add(bytes);
        }

        public void add(byte[] bytes) {
            this.bytesList.add((Object)bytes);
            this.totalSize += bytes.length;
        }

        public BytesRef binaryValue() {
            try {
                CollectionUtils.sortAndDedup(this.bytesList);
                int size = this.bytesList.size();
                byte[] bytes = new byte[this.totalSize + (size + 1) * 5];
                ByteArrayDataOutput out = new ByteArrayDataOutput(bytes);
                out.writeVInt(size);
                for (int i = 0; i < size; ++i) {
                    byte[] value = (byte[])this.bytesList.get(i);
                    int valueLength = value.length;
                    out.writeVInt(valueLength);
                    out.writeBytes(value, 0, valueLength);
                }
                return new BytesRef(bytes, 0, out.getPosition());
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get binary value", (Throwable)e, new Object[0]);
            }
        }
    }

    public static final class BinaryFieldType
    extends MappedFieldType {
        private BinaryFieldType(String name, boolean isStored, boolean hasDocValues, Map<String, String> meta) {
            super(name, false, isStored, hasDocValues, TextSearchInfo.NONE, meta);
        }

        public BinaryFieldType(String name) {
            this(name, false, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return BinaryFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, String format) {
            return SourceValueFetcher.identity(this.name(), context, format);
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return DocValueFormat.BINARY;
        }

        @Override
        public BytesReference valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesReference bytes = value instanceof BytesRef ? new BytesArray((BytesRef)value) : (value instanceof BytesReference ? (BytesReference)value : (value instanceof byte[] ? new BytesArray((byte[])value) : new BytesArray(Base64.getDecoder().decode(value.toString()))));
            return bytes;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new BytesBinaryIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Binary fields do not support searching");
        }
    }
}

