/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;

public class AllFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_all";
    public static final String CONTENT_TYPE = "_all";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new AllFieldMapper(new Explicit<Boolean>(false, false)), c -> new Builder());
    private final Explicit<Boolean> enabled;

    private static AllFieldMapper toType(FieldMapper in) {
        return (AllFieldMapper)in;
    }

    private AllFieldMapper(Explicit<Boolean> enabled) {
        super(new AllFieldType());
        this.enabled = enabled;
    }

    @Override
    protected String contentType() {
        return "_all";
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    static final class AllFieldType
    extends StringFieldType {
        AllFieldType() {
            super("_all", false, false, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, String format) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String typeName() {
            return "_all";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchNoDocsQuery();
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Explicit<Boolean>> enabled = MetadataFieldMapper.updateableBoolParam("enabled", m -> AllFieldMapper.access$200(AllFieldMapper.toType(m)), false);

        public Builder() {
            super("_all");
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.enabled);
        }

        @Override
        public AllFieldMapper build() {
            if (this.enabled.getValue().value().booleanValue()) {
                throw new IllegalArgumentException("[_all] is disabled in this version.");
            }
            return new AllFieldMapper(this.enabled.getValue());
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.freeze();
        }
    }
}

