/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import com.carrotsearch.hppc.BitMixer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.AbstractHash;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;

public final class BytesRefHash
extends AbstractHash {
    private LongArray startOffsets;
    private ByteArray bytes;
    private IntArray hashes;
    private final BytesRef spare;

    public BytesRefHash(long capacity, BigArrays bigArrays) {
        this(capacity, 0.6f, bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesRefHash(long capacity, float maxLoadFactor, BigArrays bigArrays) {
        super(capacity, maxLoadFactor, bigArrays);
        boolean success = false;
        try {
            this.startOffsets = bigArrays.newLongArray(capacity + 1L, false);
            this.startOffsets.set(0L, 0L);
            this.bytes = bigArrays.newByteArray(capacity * 3L, false);
            this.hashes = bigArrays.newIntArray(capacity, false);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
        this.spare = new BytesRef();
    }

    private static int rehash(int hash) {
        return BitMixer.mix32((int)hash);
    }

    public BytesRef get(long id, BytesRef dest) {
        long startOffset = this.startOffsets.get(id);
        int length = (int)(this.startOffsets.get(id + 1L) - startOffset);
        this.bytes.get(startOffset, length, dest);
        return dest;
    }

    public long find(BytesRef key, int code) {
        long slot;
        long index = slot = BytesRefHash.slot(BytesRefHash.rehash(code), this.mask);
        long id;
        while ((id = this.id(index)) != -1L && !key.bytesEquals(this.get(id, this.spare))) {
            index = BytesRefHash.nextSlot(index, this.mask);
        }
        return id;
    }

    public long find(BytesRef key) {
        return this.find(key, key.hashCode());
    }

    private long set(BytesRef key, int code, long id) {
        long slot;
        assert (BytesRefHash.rehash(key.hashCode()) == code);
        assert (this.size < this.maxSize);
        long index = slot = BytesRefHash.slot(code, this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) {
                this.id(index, id);
                this.append(id, key, code);
                ++this.size;
                return id;
            }
            if (key.bytesEquals(this.get(curId, this.spare))) {
                return -1L - curId;
            }
            index = BytesRefHash.nextSlot(index, this.mask);
        }
    }

    private void append(long id, BytesRef key, int code) {
        assert (this.size == id);
        long startOffset = this.startOffsets.get(this.size);
        this.bytes = this.bigArrays.grow(this.bytes, startOffset + (long)key.length);
        this.bytes.set(startOffset, key.bytes, key.offset, key.length);
        this.startOffsets = this.bigArrays.grow(this.startOffsets, this.size + 2L);
        this.startOffsets.set(this.size + 1L, startOffset + (long)key.length);
        this.hashes = this.bigArrays.grow(this.hashes, id + 1L);
        this.hashes.set(id, code);
    }

    private boolean assertConsistent(long id, int code) {
        this.get(id, this.spare);
        return BytesRefHash.rehash(this.spare.hashCode()) == code;
    }

    private void reset(int code, long id) {
        long slot;
        assert (this.assertConsistent(id, code));
        long index = slot = BytesRefHash.slot(code, this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) break;
            index = BytesRefHash.nextSlot(index, this.mask);
        }
        this.id(index, id);
    }

    public long add(BytesRef key, int code) {
        if (this.size >= this.maxSize) {
            assert (this.size == this.maxSize);
            this.grow();
        }
        assert (this.size < this.maxSize);
        return this.set(key, BytesRefHash.rehash(code), this.size);
    }

    public long add(BytesRef key) {
        return this.add(key, key.hashCode());
    }

    @Override
    protected void removeAndAdd(long index) {
        long id = this.id(index, -1L);
        assert (id >= 0L);
        int code = this.hashes.get(id);
        this.reset(code, id);
    }

    @Override
    public void close() {
        try (Releasable releasable = Releasables.wrap(this.bytes, this.hashes, this.startOffsets);){
            super.close();
        }
    }
}

