/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Point;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.elasticsearch.common.geo.GeoPolygonDecomposer;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class GeoShapeUtils {
    public static Polygon toLucenePolygon(org.elasticsearch.geometry.Polygon polygon) {
        Polygon[] holes = new Polygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = new Polygon(polygon.getHole(i).getY(), polygon.getHole(i).getX(), new Polygon[0]);
        }
        return new Polygon(polygon.getPolygon().getY(), polygon.getPolygon().getX(), holes);
    }

    public static Polygon toLucenePolygon(org.elasticsearch.geometry.Rectangle r) {
        return new Polygon(new double[]{r.getMinLat(), r.getMinLat(), r.getMaxLat(), r.getMaxLat(), r.getMinLat()}, new double[]{r.getMinLon(), r.getMaxLon(), r.getMaxLon(), r.getMinLon(), r.getMinLon()}, new Polygon[0]);
    }

    public static Rectangle toLuceneRectangle(org.elasticsearch.geometry.Rectangle r) {
        return new Rectangle(r.getMinLat(), r.getMaxLat(), r.getMinLon(), r.getMaxLon());
    }

    public static Point toLucenePoint(org.elasticsearch.geometry.Point point) {
        return new Point(point.getLat(), point.getLon());
    }

    public static org.apache.lucene.geo.Line toLuceneLine(Line line) {
        return new org.apache.lucene.geo.Line(line.getLats(), line.getLons());
    }

    public static org.apache.lucene.geo.Circle toLuceneCircle(Circle circle) {
        return new org.apache.lucene.geo.Circle(circle.getLat(), circle.getLon(), circle.getRadiusMeters());
    }

    public static LatLonGeometry[] toLuceneGeometry(final String name, final QueryShardContext context, Geometry geometry, final List<Class<? extends Geometry>> unsupportedGeometries) {
        final ArrayList geometries = new ArrayList();
        geometry.visit((GeometryVisitor)new GeometryVisitor<Void, RuntimeException>(){

            public Void visit(Circle circle) {
                this.checkSupported((Geometry)circle);
                if (!circle.isEmpty()) {
                    geometries.add(GeoShapeUtils.toLuceneCircle(circle));
                }
                return null;
            }

            public Void visit(GeometryCollection<?> collection) {
                this.checkSupported((Geometry)collection);
                if (!collection.isEmpty()) {
                    for (Geometry shape : collection) {
                        shape.visit((GeometryVisitor)this);
                    }
                }
                return null;
            }

            public Void visit(Line line) {
                this.checkSupported((Geometry)line);
                if (!line.isEmpty()) {
                    geometries.add(GeoShapeUtils.toLuceneLine(line));
                }
                return null;
            }

            public Void visit(LinearRing ring) {
                throw new QueryShardException(context, "Field [" + name + "] found and unsupported shape LinearRing", new Object[0]);
            }

            public Void visit(MultiLine multiLine) {
                this.checkSupported((Geometry)multiLine);
                if (!multiLine.isEmpty()) {
                    for (Line line : multiLine) {
                        this.visit(line);
                    }
                }
                return null;
            }

            public Void visit(MultiPoint multiPoint) {
                this.checkSupported((Geometry)multiPoint);
                if (!multiPoint.isEmpty()) {
                    for (org.elasticsearch.geometry.Point point : multiPoint) {
                        this.visit(point);
                    }
                }
                return null;
            }

            public Void visit(MultiPolygon multiPolygon) {
                this.checkSupported((Geometry)multiPolygon);
                if (!multiPolygon.isEmpty()) {
                    for (org.elasticsearch.geometry.Polygon polygon : multiPolygon) {
                        this.visit(polygon);
                    }
                }
                return null;
            }

            public Void visit(org.elasticsearch.geometry.Point point) {
                this.checkSupported((Geometry)point);
                if (!point.isEmpty()) {
                    geometries.add(GeoShapeUtils.toLucenePoint(point));
                }
                return null;
            }

            public Void visit(org.elasticsearch.geometry.Polygon polygon) {
                this.checkSupported((Geometry)polygon);
                if (!polygon.isEmpty()) {
                    ArrayList<org.elasticsearch.geometry.Polygon> collector = new ArrayList<org.elasticsearch.geometry.Polygon>();
                    GeoPolygonDecomposer.decomposePolygon(polygon, true, collector);
                    collector.forEach(p -> geometries.add(GeoShapeUtils.toLucenePolygon(p)));
                }
                return null;
            }

            public Void visit(org.elasticsearch.geometry.Rectangle r) {
                this.checkSupported((Geometry)r);
                if (!r.isEmpty()) {
                    geometries.add(GeoShapeUtils.toLuceneRectangle(r));
                }
                return null;
            }

            private void checkSupported(Geometry geometry) {
                if (unsupportedGeometries.contains(geometry.getClass())) {
                    throw new QueryShardException(context, "Field [" + name + "] found an unsupported shape [" + geometry.type() + "]", new Object[0]);
                }
            }
        });
        return geometries.toArray(new LatLonGeometry[geometries.size()]);
    }

    private GeoShapeUtils() {
    }
}

