/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.snapshots.InFlightShardSnapshotStates;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotsService;

public class SnapshotsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final SnapshotsInProgress EMPTY = new SnapshotsInProgress(Collections.emptyList());
    private static final Version VERSION_IN_SNAPSHOT_VERSION = Version.V_7_7_0;
    public static final String TYPE = "snapshots";
    public static final String ABORTED_FAILURE_TEXT = "Snapshot was aborted by deletion";
    private final List<Entry> entries;
    private static final String REPOSITORY = "repository";
    private static final String SNAPSHOTS = "snapshots";
    private static final String SNAPSHOT = "snapshot";
    private static final String UUID = "uuid";
    private static final String INCLUDE_GLOBAL_STATE = "include_global_state";
    private static final String PARTIAL = "partial";
    private static final String STATE = "state";
    private static final String INDICES = "indices";
    private static final String DATA_STREAMS = "data_streams";
    private static final String SOURCE = "source";
    private static final String CLONES = "clones";
    private static final String START_TIME_MILLIS = "start_time_millis";
    private static final String START_TIME = "start_time";
    private static final String REPOSITORY_STATE_ID = "repository_state_id";
    private static final String SHARDS = "shards";
    private static final String INDEX = "index";
    private static final String SHARD = "shard";
    private static final String NODE = "node";

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.entries.equals(((SnapshotsInProgress)o).entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotsInProgress[");
        for (int i = 0; i < this.entries.size(); ++i) {
            builder.append(this.entries.get(i).snapshot().getSnapshotId().getName());
            if (i + 1 >= this.entries.size()) continue;
            builder.append(",");
        }
        return builder.append("]").toString();
    }

    public static Entry startedEntry(Snapshot snapshot, boolean includeGlobalState, boolean partial, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, Map<String, Object> userMetadata, Version version) {
        return new Entry(snapshot, includeGlobalState, partial, SnapshotsInProgress.completed(shards.values()) ? State.SUCCESS : State.STARTED, indices, dataStreams, startTime, repositoryStateId, shards, null, userMetadata, version);
    }

    public static Entry startClone(Snapshot snapshot, SnapshotId source, List<IndexId> indices, long startTime, long repositoryStateId, Version version) {
        return new Entry(snapshot, true, false, State.STARTED, indices, Collections.emptyList(), startTime, repositoryStateId, ImmutableOpenMap.of(), null, Collections.emptyMap(), version, source, ImmutableOpenMap.of());
    }

    public static boolean completed(ObjectContainer<ShardSnapshotStatus> shards) {
        for (ObjectCursor status : shards) {
            if (((ShardSnapshotStatus)status.value).state().completed) continue;
            return false;
        }
        return true;
    }

    private static boolean hasFailures(ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> clones) {
        for (ObjectCursor value : clones.values()) {
            if (!((ShardSnapshotStatus)value.value).state().failed()) continue;
            return true;
        }
        return false;
    }

    private static boolean assertConsistentEntries(List<Entry> entries) {
        HashMap<String, Set<Tuple<String, Integer>>> assignedShardsByRepo = new HashMap<String, Set<Tuple<String, Integer>>>();
        HashMap<String, Set<Tuple<String, Integer>>> queuedShardsByRepo = new HashMap<String, Set<Tuple<String, Integer>>>();
        for (Entry entry : entries) {
            Writeable sid;
            for (ObjectObjectCursor<ShardId, ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                sid = (ShardId)objectObjectCursor.key;
                assert (SnapshotsInProgress.assertShardStateConsistent(entries, assignedShardsByRepo, queuedShardsByRepo, entry, ((ShardId)sid).getIndexName(), ((ShardId)sid).id(), (ShardSnapshotStatus)objectObjectCursor.value));
            }
            for (ObjectObjectCursor objectObjectCursor : entry.clones()) {
                sid = (RepositoryShardId)objectObjectCursor.key;
                assert (SnapshotsInProgress.assertShardStateConsistent(entries, assignedShardsByRepo, queuedShardsByRepo, entry, ((RepositoryShardId)sid).indexName(), ((RepositoryShardId)sid).shardId(), (ShardSnapshotStatus)objectObjectCursor.value));
            }
        }
        for (String repoName : assignedShardsByRepo.keySet()) {
            InFlightShardSnapshotStates.forRepo(repoName, entries);
        }
        return true;
    }

    private static boolean assertShardStateConsistent(List<Entry> entries, Map<String, Set<Tuple<String, Integer>>> assignedShardsByRepo, Map<String, Set<Tuple<String, Integer>>> queuedShardsByRepo, Entry entry, String indexName, int shardId, ShardSnapshotStatus shardSnapshotStatus) {
        if (shardSnapshotStatus.isActive()) {
            Tuple plainShardId = Tuple.tuple((Object)indexName, (Object)shardId);
            assert (assignedShardsByRepo.computeIfAbsent(entry.repository(), k -> new HashSet()).add(plainShardId)) : "Found duplicate shard assignments in " + entries;
            assert (!queuedShardsByRepo.getOrDefault(entry.repository(), Collections.emptySet()).contains(plainShardId)) : "Found active shard assignments after queued shard assignments in " + entries;
        } else if (shardSnapshotStatus.state() == ShardState.QUEUED) {
            queuedShardsByRepo.computeIfAbsent(entry.repository(), k -> new HashSet()).add(Tuple.tuple((Object)indexName, (Object)shardId));
        }
        return true;
    }

    public static SnapshotsInProgress of(List<Entry> entries) {
        if (entries.isEmpty()) {
            return EMPTY;
        }
        return new SnapshotsInProgress(Collections.unmodifiableList(entries));
    }

    private SnapshotsInProgress(List<Entry> entries) {
        this.entries = entries;
        assert (SnapshotsInProgress.assertConsistentEntries(entries));
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Entry snapshot(Snapshot snapshot) {
        for (Entry entry : this.entries) {
            Snapshot curr = entry.snapshot();
            if (!curr.equals(snapshot)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public String getWriteableName() {
        return "snapshots";
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SnapshotsInProgress.readDiffFrom(ClusterState.Custom.class, "snapshots", in);
    }

    public SnapshotsInProgress(StreamInput in) throws IOException {
        this.entries = in.readList(x$0 -> new Entry(x$0));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.entries);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("snapshots");
        for (Entry entry : this.entries) {
            entry.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static class Entry
    implements Writeable,
    ToXContent,
    RepositoryOperation {
        private final State state;
        private final Snapshot snapshot;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards;
        private final List<IndexId> indices;
        private final List<String> dataStreams;
        private final long startTime;
        private final long repositoryStateId;
        private final Version version;
        @Nullable
        private final SnapshotId source;
        private final ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> clones;
        @Nullable
        private final Map<String, Object> userMetadata;
        @Nullable
        private final String failure;

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure, Map<String, Object> userMetadata, Version version) {
            this(snapshot, includeGlobalState, partial, state, indices, dataStreams, startTime, repositoryStateId, shards, failure, userMetadata, version, null, ImmutableOpenMap.of());
        }

        private Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure, Map<String, Object> userMetadata, Version version, @Nullable SnapshotId source, @Nullable ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> clones) {
            this.state = state;
            this.snapshot = snapshot;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.indices = indices;
            this.dataStreams = dataStreams;
            this.startTime = startTime;
            this.shards = shards;
            this.repositoryStateId = repositoryStateId;
            this.failure = failure;
            this.userMetadata = userMetadata;
            this.version = version;
            this.source = source;
            if (source == null) {
                assert (clones == null || clones.isEmpty()) : "Provided [" + clones + "] but no source";
                this.clones = ImmutableOpenMap.of();
            } else {
                this.clones = clones;
            }
            assert (Entry.assertShardsConsistent(this.source, this.state, this.indices, this.shards, this.clones));
        }

        private Entry(StreamInput in) throws IOException {
            this.snapshot = new Snapshot(in);
            this.includeGlobalState = in.readBoolean();
            this.partial = in.readBoolean();
            this.state = State.fromValue(in.readByte());
            this.indices = in.readList(IndexId::new);
            this.startTime = in.readLong();
            this.shards = in.readImmutableMap(ShardId::new, ShardSnapshotStatus::readFrom);
            this.repositoryStateId = in.readLong();
            this.failure = in.readOptionalString();
            this.userMetadata = in.getVersion().onOrAfter(SnapshotInfo.METADATA_FIELD_INTRODUCED) ? in.readMap() : null;
            this.version = in.getVersion().onOrAfter(VERSION_IN_SNAPSHOT_VERSION) ? Version.readVersion(in) : (in.getVersion().onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION) ? (in.readBoolean() ? SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION : SnapshotsService.OLD_SNAPSHOT_FORMAT) : SnapshotsService.OLD_SNAPSHOT_FORMAT);
            this.dataStreams = in.getVersion().onOrAfter(SnapshotInfo.DATA_STREAMS_IN_SNAPSHOT) ? in.readStringList() : Collections.emptyList();
            if (in.getVersion().onOrAfter(SnapshotsService.CLONE_SNAPSHOT_VERSION)) {
                this.source = in.readOptionalWriteable(SnapshotId::new);
                this.clones = in.readImmutableMap(RepositoryShardId::new, ShardSnapshotStatus::readFrom);
            } else {
                this.source = null;
                this.clones = ImmutableOpenMap.of();
            }
        }

        private static boolean assertShardsConsistent(SnapshotId source, State state, List<IndexId> indices, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> clones) {
            boolean shardsCompleted;
            if ((state == State.INIT || state == State.ABORTED) && shards.isEmpty()) {
                return true;
            }
            Set indexNames = indices.stream().map(IndexId::getName).collect(Collectors.toSet());
            HashSet indexNamesInShards = new HashSet();
            shards.iterator().forEachRemaining(s -> {
                indexNamesInShards.add(((ShardId)s.key).getIndexName());
                assert (source == null || ((ShardSnapshotStatus)s.value).nodeId == null) : "Shard snapshot must not be assigned to data node when copying from snapshot [" + source + "]";
            });
            assert (source == null || !indexNames.isEmpty()) : "No empty snapshot clones allowed";
            assert (source != null || indexNames.equals(indexNamesInShards)) : "Indices in shards " + indexNamesInShards + " differ from expected indices " + indexNames + " for state [" + (Object)((Object)state) + "]";
            boolean bl = shardsCompleted = SnapshotsInProgress.completed(shards.values()) && SnapshotsInProgress.completed(clones.values());
            if (source == null || !clones.isEmpty()) assert (state.completed() && shardsCompleted || !state.completed() && !shardsCompleted) : "Completed state must imply all shards completed but saw state [" + (Object)((Object)state) + "] and shards " + shards;
            if (source != null && state.completed()) assert (!SnapshotsInProgress.hasFailures(clones) || state == State.FAILED) : "Failed shard clones in [" + clones + "] but state was [" + (Object)((Object)state) + "]";
            return true;
        }

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, Map<String, Object> userMetadata, Version version) {
            this(snapshot, includeGlobalState, partial, state, indices, dataStreams, startTime, repositoryStateId, shards, null, userMetadata, version);
        }

        public Entry(Entry entry, State state, List<IndexId> indices, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, Version version, String failure) {
            this(entry.snapshot, entry.includeGlobalState, entry.partial, state, indices, entry.dataStreams, entry.startTime, repositoryStateId, shards, failure, entry.userMetadata, version);
        }

        public Entry withRepoGen(long newRepoGen) {
            assert (newRepoGen > this.repositoryStateId) : "Updated repository generation [" + newRepoGen + "] must be higher than current generation [" + this.repositoryStateId + "]";
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.startTime, newRepoGen, this.shards, this.failure, this.userMetadata, this.version, this.source, this.clones);
        }

        public Entry withClones(ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> updatedClones) {
            if (updatedClones.equals(this.clones)) {
                return this;
            }
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, SnapshotsInProgress.completed(updatedClones.values()) ? (SnapshotsInProgress.hasFailures(updatedClones) ? State.FAILED : State.SUCCESS) : this.state, this.indices, this.dataStreams, this.startTime, this.repositoryStateId, this.shards, this.failure, this.userMetadata, this.version, this.source, updatedClones);
        }

        @Nullable
        public Entry abort() {
            ImmutableOpenMap.Builder<ShardId, ShardSnapshotStatus> shardsBuilder = ImmutableOpenMap.builder();
            boolean completed = true;
            boolean allQueued = true;
            for (ObjectObjectCursor<ShardId, ShardSnapshotStatus> objectObjectCursor : this.shards) {
                ShardSnapshotStatus status = (ShardSnapshotStatus)objectObjectCursor.value;
                allQueued &= status.state() == ShardState.QUEUED;
                if (!status.state().completed()) {
                    String nodeId;
                    status = new ShardSnapshotStatus(nodeId, (nodeId = status.nodeId()) == null ? ShardState.FAILED : ShardState.ABORTED, "aborted by snapshot deletion", status.generation());
                }
                completed &= status.state().completed();
                shardsBuilder.put((ShardId)objectObjectCursor.key, status);
            }
            if (allQueued) {
                return null;
            }
            return this.fail(shardsBuilder.build(), completed ? State.SUCCESS : State.ABORTED, SnapshotsInProgress.ABORTED_FAILURE_TEXT);
        }

        public Entry fail(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, State state, String failure) {
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, state, this.indices, this.dataStreams, this.startTime, this.repositoryStateId, shards, failure, this.userMetadata, this.version, this.source, this.clones);
        }

        public Entry withShardStates(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            if (SnapshotsInProgress.completed(shards.values())) {
                return new Entry(this.snapshot, this.includeGlobalState, this.partial, State.SUCCESS, this.indices, this.dataStreams, this.startTime, this.repositoryStateId, shards, this.failure, this.userMetadata, this.version);
            }
            return this.withStartedShards(shards);
        }

        public Entry withStartedShards(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            Entry updated = new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.startTime, this.repositoryStateId, shards, this.failure, this.userMetadata, this.version);
            assert (!updated.state().completed() && !SnapshotsInProgress.completed(updated.shards().values())) : "Only running snapshots allowed but saw [" + updated + "]";
            return updated;
        }

        @Override
        public String repository() {
            return this.snapshot.getRepository();
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<IndexId> indices() {
            return this.indices;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public Map<String, Object> userMetadata() {
            return this.userMetadata;
        }

        public boolean partial() {
            return this.partial;
        }

        public long startTime() {
            return this.startTime;
        }

        public List<String> dataStreams() {
            return this.dataStreams;
        }

        @Override
        public long repositoryStateId() {
            return this.repositoryStateId;
        }

        public String failure() {
            return this.failure;
        }

        public Version version() {
            return this.version;
        }

        @Nullable
        public SnapshotId source() {
            return this.source;
        }

        public boolean isClone() {
            return this.source != null;
        }

        public ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> clones() {
            return this.clones;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.includeGlobalState != entry.includeGlobalState) {
                return false;
            }
            if (this.partial != entry.partial) {
                return false;
            }
            if (this.startTime != entry.startTime) {
                return false;
            }
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.dataStreams.equals(entry.dataStreams)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            if (!this.snapshot.equals(entry.snapshot)) {
                return false;
            }
            if (this.state != entry.state) {
                return false;
            }
            if (this.repositoryStateId != entry.repositoryStateId) {
                return false;
            }
            if (!Objects.equals(this.failure, ((Entry)o).failure)) {
                return false;
            }
            if (!Objects.equals(this.userMetadata, ((Entry)o).userMetadata)) {
                return false;
            }
            if (!this.version.equals(entry.version)) {
                return false;
            }
            if (!Objects.equals(this.source, ((Entry)o).source)) {
                return false;
            }
            return this.clones.equals(((Entry)o).clones);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshot.hashCode();
            result = 31 * result + (this.includeGlobalState ? 1 : 0);
            result = 31 * result + (this.partial ? 1 : 0);
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            result = 31 * result + this.dataStreams.hashCode();
            result = 31 * result + Long.hashCode(this.startTime);
            result = 31 * result + Long.hashCode(this.repositoryStateId);
            result = 31 * result + (this.failure == null ? 0 : this.failure.hashCode());
            result = 31 * result + (this.userMetadata == null ? 0 : this.userMetadata.hashCode());
            result = 31 * result + this.version.hashCode();
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + this.clones.hashCode();
            return result;
        }

        public String toString() {
            return Strings.toString(this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            ShardSnapshotStatus status;
            Writeable shardId;
            builder.startObject();
            builder.field(SnapshotsInProgress.REPOSITORY, this.snapshot.getRepository());
            builder.field(SnapshotsInProgress.SNAPSHOT, this.snapshot.getSnapshotId().getName());
            builder.field(SnapshotsInProgress.UUID, this.snapshot.getSnapshotId().getUUID());
            builder.field(SnapshotsInProgress.INCLUDE_GLOBAL_STATE, this.includeGlobalState());
            builder.field(SnapshotsInProgress.PARTIAL, this.partial);
            builder.field(SnapshotsInProgress.STATE, (Object)this.state);
            builder.startArray(SnapshotsInProgress.INDICES);
            for (IndexId indexId : this.indices) {
                indexId.toXContent(builder, params);
            }
            builder.endArray();
            builder.humanReadableField(SnapshotsInProgress.START_TIME_MILLIS, SnapshotsInProgress.START_TIME, (Object)new TimeValue(this.startTime));
            builder.field(SnapshotsInProgress.REPOSITORY_STATE_ID, this.repositoryStateId);
            builder.startArray(SnapshotsInProgress.SHARDS);
            for (ObjectObjectCursor objectObjectCursor : this.shards) {
                shardId = (ShardId)objectObjectCursor.key;
                status = (ShardSnapshotStatus)objectObjectCursor.value;
                builder.startObject();
                builder.field(SnapshotsInProgress.INDEX, (ToXContent)((ShardId)shardId).getIndex());
                builder.field(SnapshotsInProgress.SHARD, ((ShardId)shardId).getId());
                builder.field(SnapshotsInProgress.STATE, (Object)status.state());
                builder.field(SnapshotsInProgress.NODE, status.nodeId());
                builder.endObject();
            }
            builder.endArray();
            if (this.isClone()) {
                builder.field(SnapshotsInProgress.SOURCE, (ToXContent)this.source);
                builder.startArray(SnapshotsInProgress.CLONES);
                for (ObjectObjectCursor objectObjectCursor : this.clones) {
                    shardId = (RepositoryShardId)objectObjectCursor.key;
                    status = (ShardSnapshotStatus)objectObjectCursor.value;
                    builder.startObject();
                    builder.field(SnapshotsInProgress.INDEX, (ToXContent)((RepositoryShardId)shardId).index());
                    builder.field(SnapshotsInProgress.SHARD, ((RepositoryShardId)shardId).shardId());
                    builder.field(SnapshotsInProgress.STATE, (Object)status.state());
                    builder.field(SnapshotsInProgress.NODE, status.nodeId());
                    builder.endObject();
                }
                builder.endArray();
            }
            builder.array(SnapshotsInProgress.DATA_STREAMS, this.dataStreams.toArray(new String[0]));
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.snapshot.writeTo(out);
            out.writeBoolean(this.includeGlobalState);
            out.writeBoolean(this.partial);
            out.writeByte(this.state.value());
            out.writeList(this.indices);
            out.writeLong(this.startTime);
            out.writeMap(this.shards);
            out.writeLong(this.repositoryStateId);
            out.writeOptionalString(this.failure);
            if (out.getVersion().onOrAfter(SnapshotInfo.METADATA_FIELD_INTRODUCED)) {
                out.writeMap(this.userMetadata);
            }
            if (out.getVersion().onOrAfter(VERSION_IN_SNAPSHOT_VERSION)) {
                Version.writeVersion(this.version, out);
            } else if (out.getVersion().onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION)) {
                out.writeBoolean(SnapshotsService.useShardGenerations(this.version));
            }
            if (out.getVersion().onOrAfter(SnapshotInfo.DATA_STREAMS_IN_SNAPSHOT)) {
                out.writeStringCollection(this.dataStreams);
            }
            if (out.getVersion().onOrAfter(SnapshotsService.CLONE_SNAPSHOT_VERSION)) {
                out.writeOptionalWriteable(this.source);
                out.writeMap(this.clones);
            }
        }

        public boolean isFragment() {
            return false;
        }
    }

    public static enum State {
        INIT(0, false),
        STARTED(1, false),
        SUCCESS(2, true),
        FAILED(3, true),
        ABORTED(4, false);

        private final byte value;
        private final boolean completed;

        private State(byte value, boolean completed) {
            this.value = value;
            this.completed = completed;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this.completed;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }

    public static class ShardSnapshotStatus
    implements Writeable {
        public static final ShardSnapshotStatus UNASSIGNED_QUEUED = new ShardSnapshotStatus(null, ShardState.QUEUED, null);
        public static final ShardSnapshotStatus MISSING = new ShardSnapshotStatus(null, ShardState.MISSING, "missing index", null);
        private final ShardState state;
        @Nullable
        private final String nodeId;
        @Nullable
        private final String generation;
        @Nullable
        private final String reason;

        public ShardSnapshotStatus(String nodeId, String generation) {
            this(nodeId, ShardState.INIT, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, @Nullable String generation) {
            this(nodeId, state, null, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, String reason, @Nullable String generation) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
            this.generation = generation;
            assert (this.assertConsistent());
        }

        private boolean assertConsistent() {
            assert (!this.state.failed() || this.reason != null);
            assert (this.state != ShardState.INIT && this.state != ShardState.WAITING || this.nodeId != null) : "Null node id for state [" + (Object)((Object)this.state) + "]";
            return true;
        }

        public static ShardSnapshotStatus readFrom(StreamInput in) throws IOException {
            String nodeId = in.readOptionalString();
            ShardState state = ShardState.fromValue(in.readByte());
            String generation = SnapshotsService.useShardGenerations(in.getVersion()) ? in.readOptionalString() : null;
            String reason = in.readOptionalString();
            if (state == ShardState.QUEUED) {
                return UNASSIGNED_QUEUED;
            }
            return new ShardSnapshotStatus(nodeId, state, reason, generation);
        }

        public ShardState state() {
            return this.state;
        }

        @Nullable
        public String nodeId() {
            return this.nodeId;
        }

        @Nullable
        public String generation() {
            return this.generation;
        }

        public String reason() {
            return this.reason;
        }

        public boolean isActive() {
            return this.state == ShardState.INIT || this.state == ShardState.ABORTED || this.state == ShardState.WAITING;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            if (SnapshotsService.useShardGenerations(out.getVersion())) {
                out.writeOptionalString(this.generation);
            }
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardSnapshotStatus status = (ShardSnapshotStatus)o;
            return Objects.equals(this.nodeId, status.nodeId) && Objects.equals(this.reason, status.reason) && Objects.equals(this.generation, status.generation) && this.state == status.state;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            result = 31 * result + (this.generation != null ? this.generation.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ShardSnapshotStatus[state=" + (Object)((Object)this.state) + ", nodeId=" + this.nodeId + ", reason=" + this.reason + ", generation=" + this.generation + "]";
        }
    }

    public static enum ShardState {
        INIT(0, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false),
        QUEUED(7, false, false);

        private final byte value;
        private final boolean completed;
        private final boolean failed;

        private ShardState(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static ShardState fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return MISSING;
                }
                case 6: {
                    return WAITING;
                }
                case 7: {
                    return QUEUED;
                }
            }
            throw new IllegalArgumentException("No shard snapshot state for value [" + value + "]");
        }
    }
}

