/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLPermission;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.URIParameter;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.sql.SQLPermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.kerberos.DelegationPermission;
import javax.security.auth.kerberos.ServicePermission;
import org.elasticsearch.bootstrap.PluginPolicyInfo;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.script.ClassPermission;

public class PolicyUtil {
    static final List<String> ALLOW_ALL_NAMES = org.elasticsearch.common.collect.List.of((Object)"ALLOW ALL NAMES SENTINEL");
    private static final PermissionMatcher ALLOWED_PLUGIN_PERMISSIONS;
    private static final PermissionMatcher ALLOWED_MODULE_PERMISSIONS;

    @SuppressForbidden(reason="create permission for test")
    private static FilePermission createFilePermission(String path, String actions) {
        return new FilePermission(path, actions);
    }

    @SuppressForbidden(reason="find URL path")
    public static Map<String, URL> getCodebaseJarMap(Set<URL> urls) {
        LinkedHashMap<String, URL> codebases = new LinkedHashMap<String, URL>();
        for (URL url : urls) {
            try {
                String fileName = PathUtils.get((URI)url.toURI()).getFileName().toString();
                if (!fileName.endsWith(".jar")) continue;
                codebases.put(fileName, url);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return codebases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    public static Policy readPolicy(URL policyFile, Map<String, URL> codebases) {
        Policy policy;
        Properties originalProps = System.getProperties();
        final HashSet unknownCodebases = new HashSet();
        final HashMap<String, String> codebaseProperties = new HashMap<String, String>();
        Properties tempProps = new Properties(originalProps){

            @Override
            public String getProperty(String key) {
                if (key.startsWith("codebase.")) {
                    String value = (String)codebaseProperties.get(key);
                    if (value == null) {
                        unknownCodebases.add(key);
                    }
                    return value;
                }
                return super.getProperty(key);
            }
        };
        try {
            System.setProperties(tempProps);
            for (Map.Entry<String, URL> codebase : codebases.entrySet()) {
                String previous;
                String name = codebase.getKey();
                URL url = codebase.getValue();
                String property = "codebase." + name;
                String aliasProperty = "codebase." + name.replaceFirst("-\\d+\\.\\d+.*\\.jar", "");
                if (!aliasProperty.equals(property) && (previous = codebaseProperties.put(aliasProperty, url.toString())) != null) {
                    throw new IllegalStateException("codebase property already set: " + aliasProperty + " -> " + previous + ", cannot set to " + url.toString());
                }
                previous = codebaseProperties.put(property, url.toString());
                if (previous == null) continue;
                throw new IllegalStateException("codebase property already set: " + property + " -> " + previous + ", cannot set to " + url.toString());
            }
            Policy policy2 = Policy.getInstance("JavaPolicy", new URIParameter(policyFile.toURI()));
            if (!unknownCodebases.isEmpty()) {
                throw new IllegalArgumentException("Unknown codebases " + unknownCodebases + " in policy file [" + policyFile + "]\nAvailable codebases: " + codebaseProperties.keySet());
            }
            policy = policy2;
        }
        catch (Throwable throwable) {
            try {
                System.setProperties(originalProps);
                throw throwable;
            }
            catch (URISyntaxException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("unable to parse policy file `" + policyFile + "`", e);
            }
        }
        System.setProperties(originalProps);
        return policy;
    }

    static PluginPolicyInfo readPolicyInfo(Path pluginRoot) throws IOException {
        Path policyFile = pluginRoot.resolve("plugin-security.policy");
        if (!Files.exists(policyFile, new LinkOption[0])) {
            return null;
        }
        LinkedHashSet<URL> jars = new LinkedHashSet<URL>();
        try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(pluginRoot, "*.jar");){
            for (Path jar : jarStream) {
                URL url = jar.toRealPath(new LinkOption[0]).toUri().toURL();
                if (jars.add(url)) continue;
                throw new IllegalStateException("duplicate module/plugin: " + url);
            }
        }
        Policy policy = PolicyUtil.readPolicy(policyFile.toUri().toURL(), PolicyUtil.getCodebaseJarMap(jars));
        return new PluginPolicyInfo(policyFile, jars, policy);
    }

    private static void validatePolicyPermissionsForJar(String type, Path file, URL jar, Policy policy, PermissionMatcher allowedPermissions, Path tmpDir) throws IOException {
        Set<Permission> jarPermissions = PolicyUtil.getPolicyPermissions(jar, policy, tmpDir);
        for (Permission permission : jarPermissions) {
            if (allowedPermissions.test(permission)) continue;
            String scope = jar == null ? " in global grant" : " for jar " + jar;
            throw new IllegalArgumentException(type + " policy [" + file + "] contains illegal permission " + permission + scope);
        }
    }

    private static void validatePolicyPermissions(String type, PluginPolicyInfo info, PermissionMatcher allowedPermissions, Path tmpDir) throws IOException {
        if (info == null) {
            return;
        }
        PolicyUtil.validatePolicyPermissionsForJar(type, info.file, null, info.policy, allowedPermissions, tmpDir);
        for (URL jar : info.jars) {
            PolicyUtil.validatePolicyPermissionsForJar(type, info.file, jar, info.policy, allowedPermissions, tmpDir);
        }
    }

    public static PluginPolicyInfo getPluginPolicyInfo(Path pluginRoot, Path tmpDir) throws IOException {
        PluginPolicyInfo info = PolicyUtil.readPolicyInfo(pluginRoot);
        PolicyUtil.validatePolicyPermissions("plugin", info, ALLOWED_PLUGIN_PERMISSIONS, tmpDir);
        return info;
    }

    public static PluginPolicyInfo getModulePolicyInfo(Path moduleRoot, Path tmpDir) throws IOException {
        PluginPolicyInfo info = PolicyUtil.readPolicyInfo(moduleRoot);
        PolicyUtil.validatePolicyPermissions("module", info, ALLOWED_MODULE_PERMISSIONS, tmpDir);
        return info;
    }

    public static Set<Permission> getPolicyPermissions(URL url, Policy policy, Path tmpDir) throws IOException {
        Policy emptyPolicy;
        Path emptyPolicyFile = Files.createTempFile(tmpDir, "empty", "tmp", new FileAttribute[0]);
        try {
            emptyPolicy = Policy.getInstance("JavaPolicy", new URIParameter(emptyPolicyFile.toUri()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        IOUtils.rm((Path[])new Path[]{emptyPolicyFile});
        ProtectionDomain protectionDomain = url == null ? PolicyUtil.class.getProtectionDomain() : new ProtectionDomain(new CodeSource(url, (Certificate[])null), null);
        PermissionCollection permissions = policy.getPermissions(protectionDomain);
        if (permissions == Policy.UNSUPPORTED_EMPTY_COLLECTION) {
            throw new UnsupportedOperationException("JavaPolicy implementation does not support retrieving permissions");
        }
        HashSet<Permission> actualPermissions = new HashSet<Permission>();
        for (Permission permission : Collections.list(permissions.elements())) {
            if (emptyPolicy.implies(protectionDomain, permission)) continue;
            actualPermissions.add(permission);
        }
        return actualPermissions;
    }

    static {
        List namedPermissions = org.elasticsearch.common.collect.List.of((Object[])new Permission[]{PolicyUtil.createFilePermission("<<ALL FILES>>", "read"), new ReflectPermission("suppressAccessChecks"), new RuntimePermission("createClassLoader"), new RuntimePermission("getClassLoader"), new RuntimePermission("setContextClassLoader"), new RuntimePermission("setFactory"), new RuntimePermission("loadLibrary.*"), new RuntimePermission("accessClassInPackage.*"), new RuntimePermission("accessDeclaredMembers"), new NetPermission("requestPasswordAuthentication"), new NetPermission("getProxySelector"), new NetPermission("getCookieHandler"), new NetPermission("getResponseCache"), new SocketPermission("*", "accept,connect,listen,resolve"), new SecurityPermission("createAccessControlContext"), new SecurityPermission("insertProvider"), new SecurityPermission("putProviderProperty.*"), new SecurityPermission("org.apache.*"), new PropertyPermission("*", "read,write"), new AuthPermission("doAs"), new AuthPermission("doAsPrivileged"), new AuthPermission("getSubject"), new AuthPermission("getSubjectFromDomainCombiner"), new AuthPermission("setReadOnly"), new AuthPermission("modifyPrincipals"), new AuthPermission("modifyPublicCredentials"), new AuthPermission("modifyPrivateCredentials"), new AuthPermission("refreshCredential"), new AuthPermission("destroyCredential"), new AuthPermission("createLoginContext.*"), new AuthPermission("getLoginConfiguration"), new AuthPermission("setLoginConfiguration"), new AuthPermission("createLoginConfiguration.*"), new AuthPermission("refreshLoginConfiguration")});
        Map<String, List<String>> classPermissions = org.elasticsearch.common.collect.Map.of(URLPermission.class, ALLOW_ALL_NAMES, DelegationPermission.class, ALLOW_ALL_NAMES, ServicePermission.class, ALLOW_ALL_NAMES, PrivateCredentialPermission.class, ALLOW_ALL_NAMES, SQLPermission.class, (Object)org.elasticsearch.common.collect.List.of((Object)"callAbort", (Object)"setNetworkTimeout"), ClassPermission.class, ALLOW_ALL_NAMES).entrySet().stream().collect(Collectors.toMap(e -> ((Class)e.getKey()).getCanonicalName(), Map.Entry::getValue));
        Permissions pluginPermissionCollection = new Permissions();
        namedPermissions.forEach(pluginPermissionCollection::add);
        pluginPermissionCollection.setReadOnly();
        ALLOWED_PLUGIN_PERMISSIONS = new PermissionMatcher(pluginPermissionCollection, classPermissions);
        List modulePermissions = org.elasticsearch.common.collect.List.of((Object[])new Permission[]{PolicyUtil.createFilePermission("<<ALL FILES>>", "read,write"), new RuntimePermission("getFileStoreAttributes"), new RuntimePermission("accessUserInformation"), new AuthPermission("modifyPrivateCredentials")});
        Permissions modulePermissionCollection = new Permissions();
        namedPermissions.forEach(modulePermissionCollection::add);
        modulePermissions.forEach(modulePermissionCollection::add);
        modulePermissionCollection.setReadOnly();
        ALLOWED_MODULE_PERMISSIONS = new PermissionMatcher(modulePermissionCollection, classPermissions);
    }

    static class PermissionMatcher
    implements Predicate<Permission> {
        PermissionCollection namedPermissions;
        Map<String, List<String>> classPermissions;

        PermissionMatcher(PermissionCollection namedPermissions, Map<String, List<String>> classPermissions) {
            this.namedPermissions = namedPermissions;
            this.classPermissions = classPermissions;
        }

        @Override
        public boolean test(Permission permission) {
            List<String> allowedNames;
            if (this.namedPermissions.implies(permission)) {
                return true;
            }
            String clazz = permission.getClass().getCanonicalName();
            String name = permission.getName();
            if (permission.getClass().equals(UnresolvedPermission.class)) {
                UnresolvedPermission up = (UnresolvedPermission)permission;
                clazz = up.getUnresolvedType();
                name = up.getUnresolvedName();
            }
            return (allowedNames = this.classPermissions.get(clazz)) != null && (allowedNames == ALLOW_ALL_NAMES || allowedNames.contains(name));
        }
    }
}

