/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.Collections;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateIndexAction
extends TransportMasterNodeAction<CreateIndexRequest, CreateIndexResponse> {
    private final MetadataCreateIndexService createIndexService;
    private final SystemIndices systemIndices;

    @Inject
    public TransportCreateIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/create", transportService, clusterService, threadPool, actionFilters, CreateIndexRequest::new, indexNameExpressionResolver, CreateIndexResponse::new, "same");
        this.createIndexService = createIndexService;
        this.systemIndices = systemIndices;
    }

    @Override
    protected ClusterBlockException checkBlock(CreateIndexRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.index());
    }

    @Override
    protected void masterOperation(CreateIndexRequest request, ClusterState state, ActionListener<CreateIndexResponse> listener) {
        String indexName;
        SystemIndexDescriptor descriptor;
        String cause = request.cause();
        if (cause.isEmpty()) {
            cause = "api";
        }
        CreateIndexClusterStateUpdateRequest updateRequest = (descriptor = this.systemIndices.findMatchingDescriptor(indexName = this.indexNameExpressionResolver.resolveDateMathExpression(request.index()))) != null && descriptor.isAutomaticallyManaged() ? this.buildSystemIndexUpdateRequest(request, cause, descriptor) : this.buildUpdateRequest(request, cause, indexName);
        this.createIndexService.createIndex(updateRequest, listener.map(response -> new CreateIndexResponse(response.isAcknowledged(), response.isShardsAcknowledged(), indexName)));
    }

    private CreateIndexClusterStateUpdateRequest buildUpdateRequest(CreateIndexRequest request, String cause, String indexName) {
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(cause, indexName, request.index()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).settings(request.settings()).mappings(request.mappings()).aliases(request.aliases()).waitForActiveShards(request.waitForActiveShards());
    }

    private CreateIndexClusterStateUpdateRequest buildSystemIndexUpdateRequest(CreateIndexRequest request, String cause, SystemIndexDescriptor descriptor) {
        Settings settings = descriptor.getSettings();
        if (settings == null) {
            settings = Settings.EMPTY;
        }
        Set<Object> aliases = descriptor.getAliasName() == null ? Collections.emptySet() : Collections.singleton(new Alias(descriptor.getAliasName()));
        CreateIndexClusterStateUpdateRequest updateRequest = new CreateIndexClusterStateUpdateRequest(cause, descriptor.getPrimaryIndex(), request.index());
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)updateRequest.ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).aliases(aliases).waitForActiveShards(ActiveShardCount.ALL).mappings(Collections.singletonMap("_doc", descriptor.getMappings())).settings(settings);
    }
}

