/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.stats.AnalysisStats;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.action.admin.cluster.stats.MappingStats;
import org.elasticsearch.action.admin.cluster.stats.VersionStats;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public class TransportClusterStatsAction
extends TransportNodesAction<ClusterStatsRequest, ClusterStatsResponse, ClusterStatsNodeRequest, ClusterStatsNodeResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterStatsAction.class);
    private static final CommonStatsFlags SHARD_STATS_FLAGS = new CommonStatsFlags(CommonStatsFlags.Flag.Docs, CommonStatsFlags.Flag.Store, CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.Completion, CommonStatsFlags.Flag.Segments);
    private final NodeService nodeService;
    private final IndicesService indicesService;
    private final Object statsMutex = new Object();
    private MappingStats mappingStats;
    private AnalysisStats analysisStats;
    private long metaVersion = -1L;

    @Inject
    public TransportClusterStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, IndicesService indicesService, ActionFilters actionFilters) {
        super("cluster:monitor/stats", threadPool, clusterService, transportService, actionFilters, ClusterStatsRequest::new, ClusterStatsNodeRequest::new, "management", "management", ClusterStatsNodeResponse.class);
        this.nodeService = nodeService;
        this.indicesService = indicesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClusterStatsResponse newResponse(ClusterStatsRequest request, List<ClusterStatsNodeResponse> responses, List<FailedNodeException> failures) {
        assert (Transports.assertNotTransportThread("Constructor of ClusterStatsResponse runs expensive computations on mappings found in the cluster state that are too slow for a transport thread"));
        ClusterState state = this.clusterService.state();
        Metadata metadata = state.metadata();
        MappingStats currentMappingStats = null;
        AnalysisStats currentAnalysisStats = null;
        Object object = this.statsMutex;
        synchronized (object) {
            if (metadata.version() == this.metaVersion) {
                logger.trace("Found cached mapping and analysis stats for metadata version [{}]", (Object)metadata.version());
                currentMappingStats = this.mappingStats;
                currentAnalysisStats = this.analysisStats;
            }
        }
        if (currentMappingStats == null) {
            logger.trace("Computing mapping and analysis stats for metadata version [{}]", (Object)metadata.version());
            currentMappingStats = MappingStats.of(metadata);
            currentAnalysisStats = AnalysisStats.of(metadata);
            object = this.statsMutex;
            synchronized (object) {
                if (metadata.version() > this.metaVersion) {
                    logger.trace("Caching mapping and analysis stats for metadata version [{}]", (Object)metadata.version());
                    this.metaVersion = metadata.version();
                    this.mappingStats = currentMappingStats;
                    this.analysisStats = currentAnalysisStats;
                }
            }
        }
        VersionStats versionStats = VersionStats.of(metadata, responses);
        return new ClusterStatsResponse(System.currentTimeMillis(), state.metadata().clusterUUID(), this.clusterService.getClusterName(), responses, failures, currentMappingStats, currentAnalysisStats, versionStats);
    }

    @Override
    protected ClusterStatsNodeRequest newNodeRequest(ClusterStatsRequest request) {
        return new ClusterStatsNodeRequest(request);
    }

    @Override
    protected ClusterStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ClusterStatsNodeResponse(in);
    }

    @Override
    protected ClusterStatsNodeResponse nodeOperation(ClusterStatsNodeRequest nodeRequest) {
        NodeInfo nodeInfo = this.nodeService.info(true, true, false, true, false, true, false, true, false, false, false);
        NodeStats nodeStats = this.nodeService.stats(CommonStatsFlags.NONE, true, true, true, false, true, false, false, false, false, false, true, false, false, false);
        ArrayList<ShardStats> shardsStats = new ArrayList<ShardStats>();
        for (IndexService indexService : this.indicesService) {
            for (IndexShard indexShard : indexService) {
                RetentionLeaseStats retentionLeaseStats;
                SeqNoStats seqNoStats;
                CommitStats commitStats;
                if (indexShard.routingEntry() == null || !indexShard.routingEntry().active()) continue;
                try {
                    commitStats = indexShard.commitStats();
                    seqNoStats = indexShard.seqNoStats();
                    retentionLeaseStats = indexShard.getRetentionLeaseStats();
                }
                catch (AlreadyClosedException e) {
                    commitStats = null;
                    seqNoStats = null;
                    retentionLeaseStats = null;
                }
                shardsStats.add(new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), new CommonStats(this.indicesService.getIndicesQueryCache(), indexShard, SHARD_STATS_FLAGS), commitStats, seqNoStats, retentionLeaseStats));
            }
        }
        ClusterHealthStatus clusterStatus = null;
        if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            clusterStatus = new ClusterStateHealth(this.clusterService.state()).getStatus();
        }
        return new ClusterStatsNodeResponse(nodeInfo.getNode(), clusterStatus, nodeInfo, nodeStats, shardsStats.toArray(new ShardStats[shardsStats.size()]));
    }

    public static class ClusterStatsNodeRequest
    extends BaseNodeRequest {
        ClusterStatsRequest request;

        public ClusterStatsNodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new ClusterStatsRequest(in);
        }

        ClusterStatsNodeRequest(ClusterStatsRequest request) {
            this.request = request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

