/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.util.Map;
import java.util.function.BiConsumer;

public final class MappingVisitor {
    private MappingVisitor() {
    }

    public static void visitMapping(Map<String, ?> mapping, BiConsumer<String, Map<String, ?>> fieldMappingConsumer) {
        MappingVisitor.visitMapping(mapping, "", fieldMappingConsumer);
    }

    private static void visitMapping(Map<String, ?> mapping, String path, BiConsumer<String, Map<String, ?>> fieldMappingConsumer) {
        Object properties = mapping.get("properties");
        if (properties instanceof Map) {
            Map propertiesAsMap = (Map)properties;
            for (String field : propertiesAsMap.keySet()) {
                Object v = propertiesAsMap.get(field);
                if (!(v instanceof Map)) continue;
                Map fieldMapping = (Map)v;
                fieldMappingConsumer.accept(path + field, fieldMapping);
                MappingVisitor.visitMapping(fieldMapping, path + field + ".", fieldMappingConsumer);
                Object fieldsO = fieldMapping.get("fields");
                if (!(fieldsO instanceof Map)) continue;
                Map fields = (Map)fieldsO;
                for (String subfield : fields.keySet()) {
                    Object v2 = fields.get(subfield);
                    if (!(v2 instanceof Map)) continue;
                    Map fieldMapping2 = (Map)v2;
                    fieldMappingConsumer.accept(path + field + "." + subfield, fieldMapping2);
                }
            }
        }
    }
}

