/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.uhighlight.CustomFieldHighlighter;
import org.apache.lucene.search.uhighlight.FieldHighlighter;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.LabelledCharArrayMatcher;
import org.apache.lucene.search.uhighlight.NoOpOffsetStrategy;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.Snippet;
import org.apache.lucene.search.uhighlight.SplittingBreakIterator;
import org.apache.lucene.search.uhighlight.UHComponents;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.index.IndexSettings;

public class CustomUnifiedHighlighter
extends UnifiedHighlighter {
    public static final char MULTIVAL_SEP_CHAR = '\u0000';
    private static final Snippet[] EMPTY_SNIPPET = new Snippet[0];
    private final UnifiedHighlighter.OffsetSource offsetSource;
    private final PassageFormatter passageFormatter;
    private final BreakIterator breakIterator;
    private final String index;
    private final String field;
    private final Locale breakIteratorLocale;
    private final int noMatchSize;
    private final FieldHighlighter fieldHighlighter;
    private final int maxAnalyzedOffset;

    public CustomUnifiedHighlighter(IndexSearcher searcher, Analyzer analyzer, UnifiedHighlighter.OffsetSource offsetSource, PassageFormatter passageFormatter, @Nullable Locale breakIteratorLocale, @Nullable BreakIterator breakIterator, String index, String field, Query query, int noMatchSize, int maxPassages, Predicate<String> fieldMatcher, int maxAnalyzedOffset) throws IOException {
        super(searcher, analyzer);
        this.offsetSource = offsetSource;
        this.breakIterator = breakIterator;
        this.breakIteratorLocale = breakIteratorLocale == null ? Locale.ROOT : breakIteratorLocale;
        this.passageFormatter = passageFormatter;
        this.index = index;
        this.field = field;
        this.noMatchSize = noMatchSize;
        this.setFieldMatcher(fieldMatcher);
        this.maxAnalyzedOffset = maxAnalyzedOffset;
        this.fieldHighlighter = this.getFieldHighlighter(field, query, CustomUnifiedHighlighter.extractTerms((Query)query), maxPassages);
    }

    public Snippet[] highlightField(LeafReader reader, int docId, CheckedSupplier<String, IOException> loadFieldValue) throws IOException {
        if (this.fieldHighlighter.fieldOffsetStrategy == NoOpOffsetStrategy.INSTANCE && this.noMatchSize == 0) {
            return EMPTY_SNIPPET;
        }
        String fieldValue = loadFieldValue.get();
        if (fieldValue == null) {
            return null;
        }
        int fieldValueLength = fieldValue.length();
        if (this.offsetSource == UnifiedHighlighter.OffsetSource.ANALYSIS && fieldValueLength > this.maxAnalyzedOffset) {
            throw new IllegalArgumentException("The length of [" + this.field + "] field of [" + docId + "] doc of [" + this.index + "] index has exceeded [" + this.maxAnalyzedOffset + "] - maximum allowed to be analyzed for highlighting. This maximum can be set by changing the [" + IndexSettings.MAX_ANALYZED_OFFSET_SETTING.getKey() + "] index level setting. For large texts, indexing with offsets or term vectors is recommended!");
        }
        Snippet[] result = (Snippet[])this.fieldHighlighter.highlightFieldForDoc(reader, docId, fieldValue);
        return result == null ? EMPTY_SNIPPET : result;
    }

    protected BreakIterator getBreakIterator(String field) {
        return this.breakIterator;
    }

    public PassageFormatter getFormatter() {
        return this.passageFormatter;
    }

    protected PassageFormatter getFormatter(String field) {
        return this.passageFormatter;
    }

    protected FieldHighlighter getFieldHighlighter(String field, Query query, Set<Term> allTerms, int maxPassages) {
        Predicate fieldMatcher = this.getFieldMatcher(field);
        BytesRef[] terms = CustomUnifiedHighlighter.filterExtractedTerms((Predicate)fieldMatcher, allTerms);
        Set highlightFlags = this.getFlags(field);
        PhraseHelper phraseHelper = this.getPhraseHelper(field, query, highlightFlags);
        LabelledCharArrayMatcher[] automata = this.getAutomata(field, query, highlightFlags);
        UHComponents components = new UHComponents(field, fieldMatcher, query, terms, phraseHelper, automata, false, highlightFlags);
        UnifiedHighlighter.OffsetSource offsetSource = this.getOptimizedOffsetSource(components);
        SplittingBreakIterator breakIterator = new SplittingBreakIterator(this.getBreakIterator(field), '\u0000');
        FieldOffsetStrategy strategy = this.getOffsetStrategy(offsetSource, components);
        return new CustomFieldHighlighter(field, strategy, this.breakIteratorLocale, (BreakIterator)breakIterator, this.getScorer(field), maxPassages, this.noMatchSize > 0 ? 1 : 0, this.getFormatter(field), this.noMatchSize);
    }

    protected Collection<Query> preSpanQueryRewrite(Query query) {
        return this.rewriteCustomQuery(query);
    }

    private Collection<Query> rewriteCustomQuery(Query query) {
        if (query instanceof MultiPhrasePrefixQuery) {
            MultiPhrasePrefixQuery mpq = (MultiPhrasePrefixQuery)query;
            Term[][] terms = mpq.getTerms();
            int[] positions = mpq.getPositions();
            SpanQuery[] positionSpanQueries = new SpanQuery[positions.length];
            int sizeMinus1 = terms.length - 1;
            for (int i = 0; i < positions.length; ++i) {
                SpanQuery[] innerQueries = new SpanQuery[terms[i].length];
                for (int j = 0; j < terms[i].length; ++j) {
                    innerQueries[j] = i == sizeMinus1 ? new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(terms[i][j])) : new SpanTermQuery(terms[i][j]);
                }
                positionSpanQueries[i] = innerQueries.length > 1 ? new SpanOrQuery(innerQueries) : innerQueries[0];
            }
            if (positionSpanQueries.length == 1) {
                return Collections.singletonList(positionSpanQueries[0]);
            }
            int positionGaps = 0;
            if (positions.length >= 2) {
                positionGaps = Math.max(0, positions[positions.length - 1] - positions[0] - positions.length + 1);
            }
            boolean inorder = mpq.getSlop() == 0;
            return Collections.singletonList(new SpanNearQuery(positionSpanQueries, mpq.getSlop() + positionGaps, inorder));
        }
        return null;
    }

    protected UnifiedHighlighter.OffsetSource getOffsetSource(String field) {
        if (this.offsetSource == null) {
            return super.getOffsetSource(field);
        }
        return this.offsetSource;
    }
}

