/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.MapStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.NumericTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public class TermsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    static Boolean REMAP_GLOBAL_ORDS;
    static Boolean COLLECT_SEGMENT_ORDS;
    private final BucketOrder order;
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final boolean showTermDocCountError;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(TermsAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.BYTES, CoreValuesSourceType.IP), TermsAggregatorFactory.bytesSupplier(), true);
        builder.register(TermsAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.NUMERIC), TermsAggregatorFactory.numericSupplier(), true);
    }

    private static TermsAggregatorSupplier bytesSupplier() {
        return new TermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                long maxOrd;
                ExecutionMode execution = null;
                if (executionHint != null) {
                    execution = ExecutionMode.fromString(executionHint);
                }
                if (!(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                    execution = ExecutionMode.MAP;
                }
                if (execution == null) {
                    execution = ExecutionMode.GLOBAL_ORDINALS;
                }
                long l = maxOrd = execution == ExecutionMode.GLOBAL_ORDINALS ? TermsAggregatorFactory.getMaxOrd(valuesSource, context.searcher()) : -1L;
                if (subAggCollectMode == null) {
                    subAggCollectMode = TermsAggregatorFactory.pickSubAggColectMode(factories, bucketCountThresholds.getShardSize(), maxOrd);
                }
                if (includeExclude != null && includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                    throw new AggregationExecutionException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
                }
                return execution.create(name, factories, valuesSource, order, format, bucketCountThresholds, includeExclude, context, parent, subAggCollectMode, showTermDocCountError, cardinality, metadata);
            }
        };
    }

    private static TermsAggregatorSupplier numericSupplier() {
        return new TermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                Function<NumericTermsAggregator, NumericTermsAggregator.ResultStrategy<?, ?>> resultStrategy;
                if (includeExclude != null && includeExclude.isRegexBased()) {
                    throw new AggregationExecutionException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
                }
                if (subAggCollectMode == null) {
                    subAggCollectMode = TermsAggregatorFactory.pickSubAggColectMode(factories, bucketCountThresholds.getShardSize(), -1L);
                }
                ValuesSource.Numeric numericValuesSource = (ValuesSource.Numeric)valuesSource;
                IncludeExclude.LongFilter longFilter = null;
                if (numericValuesSource.isFloatingPoint()) {
                    if (includeExclude != null) {
                        longFilter = includeExclude.convertToDoubleFilter();
                    }
                    resultStrategy = agg -> {
                        NumericTermsAggregator numericTermsAggregator = agg;
                        Objects.requireNonNull(numericTermsAggregator);
                        return new NumericTermsAggregator.DoubleTermsResults(numericTermsAggregator, showTermDocCountError);
                    };
                } else {
                    if (includeExclude != null) {
                        longFilter = includeExclude.convertToLongFilter(format);
                    }
                    resultStrategy = agg -> {
                        NumericTermsAggregator numericTermsAggregator = agg;
                        Objects.requireNonNull(numericTermsAggregator);
                        return new NumericTermsAggregator.LongTermsResults(numericTermsAggregator, showTermDocCountError);
                    };
                }
                return new NumericTermsAggregator(name, factories, resultStrategy, numericValuesSource, format, order, bucketCountThresholds, context, parent, subAggCollectMode, longFilter, cardinality, metadata);
            }
        };
    }

    TermsAggregatorFactory(String name, ValuesSourceConfig config, BucketOrder order, IncludeExclude includeExclude, String executionHint, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, boolean showTermDocCountError, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.order = order;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.collectMode = collectMode;
        this.bucketCountThresholds = bucketCountThresholds;
        this.showTermDocCountError = showTermDocCountError;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedTerms aggregation = new UnmappedTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), metadata);
        NonCollectingAggregator agg = new NonCollectingAggregator(this.name, searchContext, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
        this.order.validate(agg);
        return agg;
    }

    private static boolean isAggregationSort(BucketOrder order) {
        if (order instanceof InternalOrder.Aggregation) {
            return true;
        }
        if (order instanceof InternalOrder.CompoundOrder) {
            InternalOrder.CompoundOrder compoundOrder = (InternalOrder.CompoundOrder)order;
            return compoundOrder.orderElements().stream().anyMatch(TermsAggregatorFactory::isAggregationSort);
        }
        return false;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        TermsAggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(TermsAggregationBuilder.REGISTRY_KEY, this.config);
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (!InternalOrder.isKeyOrder(this.order) && bucketCountThresholds.getShardSize() == TermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        bucketCountThresholds.ensureValidity();
        return aggregatorSupplier.build(this.name, this.factories, this.config.getValuesSource(), this.order, this.config.format(), bucketCountThresholds, this.includeExclude, this.executionHint, searchContext, parent, this.collectMode, this.showTermDocCountError, cardinality, metadata);
    }

    static Aggregator.SubAggCollectionMode pickSubAggColectMode(AggregatorFactories factories, int expectedSize, long maxOrd) {
        if (factories.countAggregators() == 0) {
            return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
        }
        if (expectedSize == Integer.MAX_VALUE) {
            return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
        }
        if (maxOrd == -1L || maxOrd > (long)expectedSize) {
            return Aggregator.SubAggCollectionMode.BREADTH_FIRST;
        }
        return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
    }

    private static long getMaxOrd(ValuesSource source, IndexSearcher searcher) throws IOException {
        if (source instanceof ValuesSource.Bytes.WithOrdinals) {
            ValuesSource.Bytes.WithOrdinals valueSourceWithOrdinals = (ValuesSource.Bytes.WithOrdinals)source;
            return valueSourceWithOrdinals.globalMaxOrd(searcher);
        }
        return -1L;
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format);
                return new MapStringTermsAggregator(name, factories, new MapStringTermsAggregator.ValuesSourceCollectorSource(valuesSource), a -> {
                    MapStringTermsAggregator mapStringTermsAggregator = a;
                    Objects.requireNonNull(mapStringTermsAggregator);
                    return new MapStringTermsAggregator.StandardTermsResults(mapStringTermsAggregator, valuesSource);
                }, order, format, bucketCountThresholds, filter, context, parent, subAggCollectMode, showTermDocCountError, cardinality, metadata);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                boolean remapGlobalOrds;
                IncludeExclude.OrdinalsFilter filter;
                long maxOrd = TermsAggregatorFactory.getMaxOrd(valuesSource, context.searcher());
                assert (maxOrd != -1L);
                double ratio = (double)maxOrd / (double)context.searcher().getIndexReader().numDocs();
                assert (valuesSource instanceof ValuesSource.Bytes.WithOrdinals);
                ValuesSource.Bytes.WithOrdinals ordinalsValuesSource = (ValuesSource.Bytes.WithOrdinals)valuesSource;
                if (factories == AggregatorFactories.EMPTY && includeExclude == null && cardinality == CardinalityUpperBound.ONE && ordinalsValuesSource.supportsGlobalOrdinalsMapping() && (COLLECT_SEGMENT_ORDS != null ? COLLECT_SEGMENT_ORDS != false : ratio <= 0.5 && maxOrd <= 2048L)) {
                    return new GlobalOrdinalsStringTermsAggregator.LowCardinality(name, factories, a -> new GlobalOrdinalsStringTermsAggregator.StandardTermsResults((GlobalOrdinalsStringTermsAggregator)a), ordinalsValuesSource, order, format, bucketCountThresholds, context, parent, false, subAggCollectMode, showTermDocCountError, metadata);
                }
                IncludeExclude.OrdinalsFilter ordinalsFilter = filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(format);
                if (cardinality == CardinalityUpperBound.ONE && REMAP_GLOBAL_ORDS != null) {
                    remapGlobalOrds = REMAP_GLOBAL_ORDS;
                } else {
                    remapGlobalOrds = true;
                    if (includeExclude == null && cardinality == CardinalityUpperBound.ONE && (factories == AggregatorFactories.EMPTY || !TermsAggregatorFactory.isAggregationSort(order) && subAggCollectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST)) {
                        remapGlobalOrds = false;
                    }
                }
                return new GlobalOrdinalsStringTermsAggregator(name, factories, a -> new GlobalOrdinalsStringTermsAggregator.StandardTermsResults((GlobalOrdinalsStringTermsAggregator)a), ordinalsValuesSource, order, format, bucketCountThresholds, filter, context, parent, remapGlobalOrds, subAggCollectMode, showTermDocCountError, cardinality, metadata);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value) {
            switch (value) {
                case "global_ordinals": {
                    return GLOBAL_ORDINALS;
                }
                case "map": {
                    return MAP;
                }
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map, global_ordinals]");
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, BucketOrder var4, DocValueFormat var5, TermsAggregator.BucketCountThresholds var6, IncludeExclude var7, SearchContext var8, Aggregator var9, Aggregator.SubAggCollectionMode var10, boolean var11, CardinalityUpperBound var12, Map<String, Object> var13) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

