/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptedMetricAggContexts;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricAggregatorFactory;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptedMetricAggregationBuilder
extends AbstractAggregationBuilder<ScriptedMetricAggregationBuilder> {
    public static final String NAME = "scripted_metric";
    private static final Logger logger = LogManager.getLogger(ScriptedMetricAggregationBuilder.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    private static final ParseField INIT_SCRIPT_FIELD = new ParseField("init_script", new String[0]);
    private static final ParseField MAP_SCRIPT_FIELD = new ParseField("map_script", new String[0]);
    private static final ParseField COMBINE_SCRIPT_FIELD = new ParseField("combine_script", new String[0]);
    private static final ParseField REDUCE_SCRIPT_FIELD = new ParseField("reduce_script", new String[0]);
    private static final ParseField PARAMS_FIELD = new ParseField("params", new String[0]);
    private Script initScript;
    private Script mapScript;
    private Script combineScript;
    private Script reduceScript;
    private Map<String, Object> params;

    public ScriptedMetricAggregationBuilder(String name) {
        super(name);
    }

    protected ScriptedMetricAggregationBuilder(ScriptedMetricAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.initScript = clone.initScript;
        this.mapScript = clone.mapScript;
        this.combineScript = clone.combineScript;
        this.reduceScript = clone.reduceScript;
        this.params = clone.params;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new ScriptedMetricAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public ScriptedMetricAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.initScript = in.readOptionalWriteable(Script::new);
        this.mapScript = in.readOptionalWriteable(Script::new);
        this.combineScript = in.readOptionalWriteable(Script::new);
        this.reduceScript = in.readOptionalWriteable(Script::new);
        if (in.readBoolean()) {
            this.params = in.readMap();
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.initScript);
        out.writeOptionalWriteable(this.mapScript);
        out.writeOptionalWriteable(this.combineScript);
        out.writeOptionalWriteable(this.reduceScript);
        boolean hasParams = this.params != null;
        out.writeBoolean(hasParams);
        if (hasParams) {
            out.writeMap(this.params);
        }
    }

    public ScriptedMetricAggregationBuilder initScript(Script initScript) {
        if (initScript == null) {
            throw new IllegalArgumentException("[initScript] must not be null: [" + this.name + "]");
        }
        this.initScript = initScript;
        return this;
    }

    public Script initScript() {
        return this.initScript;
    }

    public ScriptedMetricAggregationBuilder mapScript(Script mapScript) {
        if (mapScript == null) {
            throw new IllegalArgumentException("[mapScript] must not be null: [" + this.name + "]");
        }
        this.mapScript = mapScript;
        return this;
    }

    public Script mapScript() {
        return this.mapScript;
    }

    public ScriptedMetricAggregationBuilder combineScript(Script combineScript) {
        if (combineScript == null) {
            throw new IllegalArgumentException("[combineScript] must not be null: [" + this.name + "]");
        }
        this.combineScript = combineScript;
        return this;
    }

    public Script combineScript() {
        return this.combineScript;
    }

    public ScriptedMetricAggregationBuilder reduceScript(Script reduceScript) {
        if (reduceScript == null) {
            throw new IllegalArgumentException("[reduceScript] must not be null: [" + this.name + "]");
        }
        this.reduceScript = reduceScript;
        return this;
    }

    public Script reduceScript() {
        return this.reduceScript;
    }

    public ScriptedMetricAggregationBuilder params(Map<String, Object> params) {
        if (params == null) {
            throw new IllegalArgumentException("[params] must not be null: [" + this.name + "]");
        }
        this.params = params;
        return this;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    protected ScriptedMetricAggregatorFactory doBuild(SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        Map<String, Object> combineScriptParams;
        ScriptedMetricAggContexts.CombineScript.Factory compiledCombineScript;
        Map<String, Object> initScriptParams;
        ScriptedMetricAggContexts.InitScript.Factory compiledInitScript;
        if (this.combineScript == null) {
            deprecationLogger.deprecated("[combineScript] must be provided for metric aggregations.", new Object[0]);
        }
        if (this.reduceScript == null) {
            deprecationLogger.deprecated("[reduceScript] must be provided for metric aggregations.", new Object[0]);
        }
        QueryShardContext queryShardContext = context.getQueryShardContext();
        if (this.initScript != null) {
            compiledInitScript = queryShardContext.getScriptService().compile(this.initScript, ScriptedMetricAggContexts.InitScript.CONTEXT);
            initScriptParams = this.initScript.getParams();
        } else {
            compiledInitScript = (p, a) -> null;
            initScriptParams = Collections.emptyMap();
        }
        ScriptedMetricAggContexts.MapScript.Factory compiledMapScript = queryShardContext.getScriptService().compile(this.mapScript, ScriptedMetricAggContexts.MapScript.CONTEXT);
        Map<String, Object> mapScriptParams = this.mapScript.getParams();
        if (this.combineScript != null) {
            compiledCombineScript = queryShardContext.getScriptService().compile(this.combineScript, ScriptedMetricAggContexts.CombineScript.CONTEXT);
            combineScriptParams = this.combineScript.getParams();
        } else {
            compiledCombineScript = (p, a) -> null;
            combineScriptParams = Collections.emptyMap();
        }
        return new ScriptedMetricAggregatorFactory(this.name, compiledMapScript, mapScriptParams, compiledInitScript, initScriptParams, compiledCombineScript, combineScriptParams, this.reduceScript, this.params, queryShardContext.lookup(), context, parent, subfactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject();
        if (this.initScript != null) {
            builder.field(INIT_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.initScript);
        }
        if (this.mapScript != null) {
            builder.field(MAP_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.mapScript);
        }
        if (this.combineScript != null) {
            builder.field(COMBINE_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.combineScript);
        }
        if (this.reduceScript != null) {
            builder.field(REDUCE_SCRIPT_FIELD.getPreferredName(), (ToXContent)this.reduceScript);
        }
        if (this.params != null) {
            builder.field(PARAMS_FIELD.getPreferredName());
            builder.map(this.params);
        }
        builder.endObject();
        return builder;
    }

    public static ScriptedMetricAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        Script initScript = null;
        Script mapScript = null;
        Script combineScript = null;
        Script reduceScript = null;
        Map params = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.VALUE_STRING) {
                if (INIT_SCRIPT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    initScript = Script.parse(parser);
                    continue;
                }
                if (MAP_SCRIPT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    mapScript = Script.parse(parser);
                    continue;
                }
                if (COMBINE_SCRIPT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    combineScript = Script.parse(parser);
                    continue;
                }
                if (REDUCE_SCRIPT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    reduceScript = Script.parse(parser);
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT && PARAMS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    params = parser.map();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " in [" + aggregationName + "].", new Object[0]);
        }
        if (mapScript == null) {
            throw new ParsingException(parser.getTokenLocation(), "map_script field is required in [" + aggregationName + "].", new Object[0]);
        }
        ScriptedMetricAggregationBuilder factory = new ScriptedMetricAggregationBuilder(aggregationName);
        if (initScript != null) {
            factory.initScript(initScript);
        }
        if (mapScript != null) {
            factory.mapScript(mapScript);
        }
        if (combineScript != null) {
            factory.combineScript(combineScript);
        }
        if (reduceScript != null) {
            factory.reduceScript(reduceScript);
        }
        if (params != null) {
            factory.params(params);
        }
        return factory;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.initScript, this.mapScript, this.combineScript, this.reduceScript, this.params);
    }

    @Override
    protected boolean doEquals(Object obj) {
        ScriptedMetricAggregationBuilder other = (ScriptedMetricAggregationBuilder)obj;
        return Objects.equals(this.initScript, other.initScript) && Objects.equals(this.mapScript, other.mapScript) && Objects.equals(this.combineScript, other.combineScript) && Objects.equals(this.reduceScript, other.reduceScript) && Objects.equals(this.params, other.params);
    }
}

