/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.MetaDataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.rest.RestStatus;

public class MetaData
implements Iterable<IndexMetaData>,
Diffable<MetaData>,
ToXContentFragment {
    private static final Logger logger = LogManager.getLogger(MetaData.class);
    public static final String ALL = "_all";
    public static EnumSet<XContentContext> API_ONLY = EnumSet.of(XContentContext.API);
    public static EnumSet<XContentContext> API_AND_GATEWAY = EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
    public static EnumSet<XContentContext> API_AND_SNAPSHOT = EnumSet.of(XContentContext.API, XContentContext.SNAPSHOT);
    public static EnumSet<XContentContext> ALL_CONTEXTS = EnumSet.allOf(XContentContext.class);
    public static final Setting<Integer> SETTING_CLUSTER_MAX_SHARDS_PER_NODE = Setting.intSetting("cluster.max_shards_per_node", 1000, 1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_READ_ONLY_SETTING = Setting.boolSetting("cluster.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Setting<Boolean> SETTING_READ_ONLY_ALLOW_DELETE_SETTING = Setting.boolSetting("cluster.blocks.read_only_allow_delete", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(13, "cluster read-only / allow delete (api)", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final MetaData EMPTY_META_DATA = MetaData.builder().build();
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = XContentContext.SNAPSHOT.toString();
    public static final String CONTEXT_MODE_GATEWAY = XContentContext.GATEWAY.toString();
    public static final String GLOBAL_STATE_FILE_PREFIX = "global-";
    private static final NamedDiffableValueSerializer<Custom> CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Custom>(Custom.class);
    private final String clusterUUID;
    private final long version;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final ImmutableOpenMap<String, IndexMetaData> indices;
    private final ImmutableOpenMap<String, IndexTemplateMetaData> templates;
    private final ImmutableOpenMap<String, Custom> customs;
    private final transient int totalNumberOfShards;
    private final int totalOpenIndexShards;
    private final int numberOfShards;
    private final String[] allIndices;
    private final String[] allOpenIndices;
    private final String[] allClosedIndices;
    private final SortedMap<String, AliasOrIndex> aliasAndIndexLookup;
    private static final ToXContent.Params FORMAT_PARAMS;
    public static final MetaDataStateFormat<MetaData> FORMAT;

    MetaData(String clusterUUID, long version, Settings transientSettings, Settings persistentSettings, ImmutableOpenMap<String, IndexMetaData> indices, ImmutableOpenMap<String, IndexTemplateMetaData> templates, ImmutableOpenMap<String, Custom> customs, String[] allIndices, String[] allOpenIndices, String[] allClosedIndices, SortedMap<String, AliasOrIndex> aliasAndIndexLookup) {
        this.clusterUUID = clusterUUID;
        this.version = version;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = Settings.builder().put(persistentSettings).put(transientSettings).build();
        this.indices = indices;
        this.customs = customs;
        this.templates = templates;
        int totalNumberOfShards = 0;
        int totalOpenIndexShards = 0;
        int numberOfShards = 0;
        for (ObjectCursor cursor : indices.values()) {
            totalNumberOfShards += ((IndexMetaData)cursor.value).getTotalNumberOfShards();
            numberOfShards += ((IndexMetaData)cursor.value).getNumberOfShards();
            if (!IndexMetaData.State.OPEN.equals((Object)((IndexMetaData)cursor.value).getState())) continue;
            totalOpenIndexShards += ((IndexMetaData)cursor.value).getTotalNumberOfShards();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        this.totalOpenIndexShards = totalOpenIndexShards;
        this.numberOfShards = numberOfShards;
        this.allIndices = allIndices;
        this.allOpenIndices = allOpenIndices;
        this.allClosedIndices = allClosedIndices;
        this.aliasAndIndexLookup = aliasAndIndexLookup;
    }

    public long version() {
        return this.version;
    }

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public boolean hasAlias(String alias) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)this.getAliasAndIndexLookup().get(alias);
        if (aliasOrIndex != null) {
            return aliasOrIndex.isAlias();
        }
        return false;
    }

    public boolean equalsAliases(MetaData other) {
        for (ObjectCursor cursor : other.indices().values()) {
            IndexMetaData otherIndex = (IndexMetaData)cursor.value;
            IndexMetaData thisIndex = this.index(otherIndex.getIndex());
            if (thisIndex == null) {
                return false;
            }
            if (otherIndex.getAliases().equals(thisIndex.getAliases())) continue;
            return false;
        }
        return true;
    }

    public SortedMap<String, AliasOrIndex> getAliasAndIndexLookup() {
        return this.aliasAndIndexLookup;
    }

    public ImmutableOpenMap<String, List<AliasMetaData>> findAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        boolean matchAllAliases = MetaData.matchAllAliases(aliases);
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        for (String index : concreteIndices) {
            IndexMetaData indexMetaData = this.indices.get(index);
            ArrayList<AliasMetaData> filteredValues = new ArrayList<AliasMetaData>();
            for (ObjectCursor cursor : indexMetaData.getAliases().values()) {
                AliasMetaData value = (AliasMetaData)cursor.value;
                if (!matchAllAliases && !Regex.simpleMatch(aliases, value.alias())) continue;
                filteredValues.add(value);
            }
            if (filteredValues.isEmpty()) continue;
            CollectionUtil.timSort(filteredValues, Comparator.comparing(AliasMetaData::alias));
            mapBuilder.put(index, Collections.unmodifiableList(filteredValues));
        }
        return mapBuilder.build();
    }

    private static boolean matchAllAliases(String[] aliases) {
        for (String alias : aliases) {
            if (!alias.equals(ALL)) continue;
            return true;
        }
        return aliases.length == 0;
    }

    public boolean hasAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return false;
        }
        Iterable<String> intersection = HppcMaps.intersection(ObjectHashSet.from((Object[])concreteIndices), this.indices.keys());
        for (String index : intersection) {
            IndexMetaData indexMetaData = this.indices.get(index);
            ArrayList<AliasMetaData> filteredValues = new ArrayList<AliasMetaData>();
            for (ObjectCursor cursor : indexMetaData.getAliases().values()) {
                AliasMetaData value = (AliasMetaData)cursor.value;
                if (!Regex.simpleMatch(aliases, value.alias())) continue;
                filteredValues.add(value);
            }
            if (filteredValues.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> findMappings(String[] concreteIndices, String[] types, Function<String, Predicate<String>> fieldFilter) throws IOException {
        assert (types != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        boolean isAllTypes = MetaData.isAllTypes(types);
        ImmutableOpenMap.Builder indexMapBuilder = ImmutableOpenMap.builder();
        Iterable<String> intersection = HppcMaps.intersection(ObjectHashSet.from((Object[])concreteIndices), this.indices.keys());
        for (String index : intersection) {
            IndexMetaData indexMetaData = this.indices.get(index);
            Predicate<String> fieldPredicate = fieldFilter.apply(index);
            if (isAllTypes) {
                indexMapBuilder.put(index, MetaData.filterFields(indexMetaData.getMappings(), fieldPredicate));
                continue;
            }
            ImmutableOpenMap.Builder<String, MappingMetaData> filteredMappings = ImmutableOpenMap.builder();
            for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMetaData.getMappings()) {
                if (!Regex.simpleMatch(types, (String)objectObjectCursor.key)) continue;
                filteredMappings.put((String)objectObjectCursor.key, MetaData.filterFields((MappingMetaData)objectObjectCursor.value, fieldPredicate));
            }
            if (filteredMappings.isEmpty()) continue;
            indexMapBuilder.put(index, filteredMappings.build());
        }
        return indexMapBuilder.build();
    }

    private static ImmutableOpenMap<String, MappingMetaData> filterFields(ImmutableOpenMap<String, MappingMetaData> mappings, Predicate<String> fieldPredicate) throws IOException {
        if (fieldPredicate == MapperPlugin.NOOP_FIELD_PREDICATE) {
            return mappings;
        }
        ImmutableOpenMap.Builder<String, MappingMetaData> builder = ImmutableOpenMap.builder(mappings.size());
        for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : mappings) {
            builder.put((String)objectObjectCursor.key, MetaData.filterFields((MappingMetaData)objectObjectCursor.value, fieldPredicate));
        }
        return builder.build();
    }

    private static MappingMetaData filterFields(MappingMetaData mappingMetaData, Predicate<String> fieldPredicate) throws IOException {
        if (fieldPredicate == MapperPlugin.NOOP_FIELD_PREDICATE) {
            return mappingMetaData;
        }
        Map sourceAsMap = (Map)XContentHelper.convertToMap(mappingMetaData.source().compressedReference(), true).v2();
        Map mapping = sourceAsMap.size() == 1 && sourceAsMap.containsKey(mappingMetaData.type()) ? (Map)sourceAsMap.get(mappingMetaData.type()) : sourceAsMap;
        Map properties = (Map)mapping.get("properties");
        if (properties == null || properties.isEmpty()) {
            return mappingMetaData;
        }
        MetaData.filterFields("", properties, fieldPredicate);
        return new MappingMetaData(mappingMetaData.type(), sourceAsMap);
    }

    private static boolean filterFields(String currentPath, Map<String, Object> fields, Predicate<String> fieldPredicate) {
        assert (fieldPredicate != MapperPlugin.NOOP_FIELD_PREDICATE);
        Iterator<Map.Entry<String, Object>> entryIterator = fields.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map map;
            Map.Entry<String, Object> entry = entryIterator.next();
            String newPath = MetaData.mergePaths(currentPath, entry.getKey());
            Object value = entry.getValue();
            boolean mayRemove = true;
            boolean isMultiField = false;
            if (value instanceof Map) {
                map = (Map)value;
                Map properties = (Map)map.get("properties");
                if (properties != null) {
                    mayRemove = MetaData.filterFields(newPath, properties, fieldPredicate);
                } else {
                    Map subFields = (Map)map.get("fields");
                    if (subFields != null) {
                        isMultiField = true;
                        mayRemove = MetaData.filterFields(newPath, subFields, fieldPredicate);
                        if (mayRemove) {
                            map.remove("fields");
                        }
                    }
                }
            } else {
                throw new IllegalStateException("cannot filter mappings, found unknown element of type [" + value.getClass() + "]");
            }
            if (fieldPredicate.test(newPath)) continue;
            if (mayRemove) {
                entryIterator.remove();
                continue;
            }
            if (!isMultiField) continue;
            map = (Map)value;
            Map subFields = (Map)map.get("fields");
            assert (subFields.size() > 0);
            map.put("properties", subFields);
            map.remove("fields");
            map.remove("type");
        }
        return fields.size() == 0;
    }

    private static String mergePaths(String path, String field) {
        if (path.length() == 0) {
            return field;
        }
        return path + "." + field;
    }

    public String[] getConcreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public String resolveWriteIndexRouting(@Nullable String parent, @Nullable String routing, String aliasOrIndex) {
        if (aliasOrIndex == null) {
            return this.routingOrParent(parent, routing);
        }
        AliasOrIndex result = (AliasOrIndex)this.getAliasAndIndexLookup().get(aliasOrIndex);
        if (result == null || !result.isAlias()) {
            return this.routingOrParent(parent, routing);
        }
        AliasOrIndex.Alias alias = (AliasOrIndex.Alias)result;
        IndexMetaData writeIndex = alias.getWriteIndex();
        if (writeIndex == null) {
            throw new IllegalArgumentException("alias [" + aliasOrIndex + "] does not have a write index");
        }
        AliasMetaData aliasMd = writeIndex.getAliases().get(alias.getAliasName());
        if (aliasMd.indexRouting() != null) {
            if (aliasMd.indexRouting().indexOf(44) != -1) {
                throw new IllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + aliasMd.getIndexRouting() + "] that resolved to several routing values, rejecting operation");
            }
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            return aliasMd.indexRouting();
        }
        return this.routingOrParent(parent, routing);
    }

    public String resolveIndexRouting(@Nullable String parent, @Nullable String routing, String aliasOrIndex) {
        AliasMetaData aliasMd;
        if (aliasOrIndex == null) {
            return this.routingOrParent(parent, routing);
        }
        AliasOrIndex result = (AliasOrIndex)this.getAliasAndIndexLookup().get(aliasOrIndex);
        if (result == null || !result.isAlias()) {
            return this.routingOrParent(parent, routing);
        }
        AliasOrIndex.Alias alias = (AliasOrIndex.Alias)result;
        if (result.getIndices().size() > 1) {
            this.rejectSingleIndexOperation(aliasOrIndex, result);
        }
        if ((aliasMd = alias.getFirstAliasMetaData()).indexRouting() != null) {
            if (aliasMd.indexRouting().indexOf(44) != -1) {
                throw new IllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + aliasMd.getIndexRouting() + "] that resolved to several routing values, rejecting operation");
            }
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            return aliasMd.indexRouting();
        }
        return this.routingOrParent(parent, routing);
    }

    private void rejectSingleIndexOperation(String aliasOrIndex, AliasOrIndex result) {
        Object[] indexNames = new String[result.getIndices().size()];
        int i = 0;
        for (IndexMetaData indexMetaData : result.getIndices()) {
            indexNames[i++] = indexMetaData.getIndex().getName();
        }
        throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + Arrays.toString(indexNames) + "], can't execute a single index op");
    }

    private String routingOrParent(@Nullable String parent, @Nullable String routing) {
        if (routing == null) {
            return parent;
        }
        return routing;
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasConcreteIndex(String index) {
        return this.getAliasAndIndexLookup().containsKey(index);
    }

    public IndexMetaData index(String index) {
        return this.indices.get(index);
    }

    public IndexMetaData index(Index index) {
        IndexMetaData metaData = this.index(index.getName());
        if (metaData != null && metaData.getIndexUUID().equals(index.getUUID())) {
            return metaData;
        }
        return null;
    }

    public boolean hasIndexMetaData(IndexMetaData indexMetaData) {
        return this.indices.get(indexMetaData.getIndex().getName()) == indexMetaData;
    }

    public IndexMetaData getIndexSafe(Index index) {
        IndexMetaData metaData = this.index(index.getName());
        if (metaData != null) {
            if (metaData.getIndexUUID().equals(index.getUUID())) {
                return metaData;
            }
            throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + metaData.getIndexUUID() + "]"));
        }
        throw new IndexNotFoundException(index);
    }

    public ImmutableOpenMap<String, IndexMetaData> indices() {
        return this.indices;
    }

    public ImmutableOpenMap<String, IndexMetaData> getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, IndexTemplateMetaData> templates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, IndexTemplateMetaData> getTemplates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public IndexGraveyard indexGraveyard() {
        return (IndexGraveyard)this.custom("index-graveyard");
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalOpenIndexShards() {
        return this.totalOpenIndexShards;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public static boolean isAllTypes(String[] types) {
        return types == null || types.length == 0 || MetaData.isExplicitAllType(types);
    }

    public static boolean isExplicitAllType(String[] types) {
        return types != null && types.length == 1 && ALL.equals(types[0]);
    }

    public boolean routingRequired(String concreteIndex, String type) {
        MappingMetaData mappingMetaData;
        IndexMetaData indexMetaData = this.indices.get(concreteIndex);
        if (indexMetaData != null && (mappingMetaData = indexMetaData.getMappings().get(indexMetaData.resolveDocumentType(type))) != null) {
            return mappingMetaData.routing().required();
        }
        return false;
    }

    @Override
    public Iterator<IndexMetaData> iterator() {
        return this.indices.valuesIt();
    }

    public static boolean isGlobalStateEquals(MetaData metaData1, MetaData metaData2) {
        if (!metaData1.persistentSettings.equals(metaData2.persistentSettings)) {
            return false;
        }
        if (!metaData1.templates.equals(metaData2.templates())) {
            return false;
        }
        int customCount1 = 0;
        for (ObjectObjectCursor<String, Custom> objectObjectCursor : metaData1.customs) {
            if (!((Custom)objectObjectCursor.value).context().contains((Object)XContentContext.GATEWAY)) continue;
            if (!((Custom)objectObjectCursor.value).equals(metaData2.custom((String)objectObjectCursor.key))) {
                return false;
            }
            ++customCount1;
        }
        int customCount2 = 0;
        for (ObjectCursor cursor : metaData2.customs.values()) {
            if (!((Custom)cursor.value).context().contains((Object)XContentContext.GATEWAY)) continue;
            ++customCount2;
        }
        return customCount1 == customCount2;
    }

    @Override
    public Diff<MetaData> diff(MetaData previousState) {
        return new MetaDataDiff(previousState, this);
    }

    public static Diff<MetaData> readDiffFrom(StreamInput in) throws IOException {
        return new MetaDataDiff(in);
    }

    public static MetaData fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    public static MetaData readFrom(StreamInput in) throws IOException {
        int i;
        Builder builder = new Builder();
        builder.version = in.readLong();
        builder.clusterUUID = in.readString();
        builder.transientSettings(Settings.readSettingsFromStream(in));
        builder.persistentSettings(Settings.readSettingsFromStream(in));
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexMetaData.readFrom(in), false);
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexTemplateMetaData.readFrom(in));
        }
        int customSize = in.readVInt();
        for (int i2 = 0; i2 < customSize; ++i2) {
            Custom customIndexMetaData = in.readNamedWriteable(Custom.class);
            builder.putCustom(customIndexMetaData.getWriteableName(), customIndexMetaData);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeString(this.clusterUUID);
        Settings.writeSettingsToStream(this.transientSettings, out);
        Settings.writeSettingsToStream(this.persistentSettings, out);
        out.writeVInt(this.indices.size());
        for (IndexMetaData indexMetaData : this) {
            indexMetaData.writeTo(out);
        }
        out.writeVInt(this.templates.size());
        for (ObjectCursor cursor : this.templates.values()) {
            ((IndexTemplateMetaData)cursor.value).writeTo(out);
        }
        int numberOfCustoms = 0;
        for (ObjectCursor cursor : this.customs.values()) {
            if (!ClusterState.FeatureAware.shouldSerialize(out, (Custom)cursor.value)) continue;
            ++numberOfCustoms;
        }
        out.writeVInt(numberOfCustoms);
        for (ObjectCursor cursor : this.customs.values()) {
            if (!ClusterState.FeatureAware.shouldSerialize(out, (Custom)cursor.value)) continue;
            out.writeNamedWriteable((NamedWriteable)cursor.value);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetaData metaData) {
        return new Builder(metaData);
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("binary", "true");
        params.put(CONTEXT_MODE_PARAM, CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
        FORMAT = new MetaDataStateFormat<MetaData>(GLOBAL_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, MetaData state) throws IOException {
                Builder.toXContent(state, builder, FORMAT_PARAMS);
            }

            @Override
            public MetaData fromXContent(XContentParser parser) throws IOException {
                return Builder.fromXContent(parser);
            }
        };
    }

    public static class Builder {
        private String clusterUUID;
        private long version;
        private Settings transientSettings = Settings.Builder.EMPTY_SETTINGS;
        private Settings persistentSettings = Settings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, IndexMetaData> indices;
        private final ImmutableOpenMap.Builder<String, IndexTemplateMetaData> templates;
        private final ImmutableOpenMap.Builder<String, Custom> customs;

        public Builder() {
            this.clusterUUID = "_na_";
            this.indices = ImmutableOpenMap.builder();
            this.templates = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
            this.indexGraveyard(IndexGraveyard.builder().build());
        }

        public Builder(MetaData metaData) {
            this.clusterUUID = metaData.clusterUUID;
            this.transientSettings = metaData.transientSettings;
            this.persistentSettings = metaData.persistentSettings;
            this.version = metaData.version;
            this.indices = ImmutableOpenMap.builder(metaData.indices);
            this.templates = ImmutableOpenMap.builder(metaData.templates);
            this.customs = ImmutableOpenMap.builder(metaData.customs);
        }

        public Builder put(IndexMetaData.Builder indexMetaDataBuilder) {
            indexMetaDataBuilder.version(indexMetaDataBuilder.version() + 1L);
            IndexMetaData indexMetaData = indexMetaDataBuilder.build();
            this.indices.put(indexMetaData.getIndex().getName(), indexMetaData);
            return this;
        }

        public Builder put(IndexMetaData indexMetaData, boolean incrementVersion) {
            if (this.indices.get(indexMetaData.getIndex().getName()) == indexMetaData) {
                return this;
            }
            if (incrementVersion) {
                indexMetaData = IndexMetaData.builder(indexMetaData).version(indexMetaData.getVersion() + 1L).build();
            }
            this.indices.put(indexMetaData.getIndex().getName(), indexMetaData);
            return this;
        }

        public IndexMetaData get(String index) {
            return this.indices.get(index);
        }

        public IndexMetaData getSafe(Index index) {
            IndexMetaData indexMetaData = this.get(index.getName());
            if (indexMetaData != null) {
                if (indexMetaData.getIndexUUID().equals(index.getUUID())) {
                    return indexMetaData;
                }
                throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + indexMetaData.getIndexUUID() + "]"));
            }
            throw new IndexNotFoundException(index);
        }

        public Builder remove(String index) {
            this.indices.remove(index);
            return this;
        }

        public Builder removeAllIndices() {
            this.indices.clear();
            return this;
        }

        public Builder indices(ImmutableOpenMap<String, IndexMetaData> indices) {
            this.indices.putAll(indices);
            return this;
        }

        public Builder put(IndexTemplateMetaData.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetaData template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder templates(ImmutableOpenMap<String, IndexTemplateMetaData> templates) {
            this.templates.putAll(templates);
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, custom);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(ImmutableOpenMap<String, Custom> customs) {
            this.customs.putAll(customs);
            return this;
        }

        public Builder indexGraveyard(IndexGraveyard indexGraveyard) {
            this.putCustom("index-graveyard", indexGraveyard);
            return this;
        }

        public IndexGraveyard indexGraveyard() {
            IndexGraveyard graveyard = (IndexGraveyard)this.getCustom("index-graveyard");
            return graveyard;
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = (String[])this.indices.keys().toArray(String.class);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetaData.builder(indexMetaData).settings(Settings.builder().put(indexMetaData.getSettings()).put(settings)));
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String[] indices) {
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetaData.builder(indexMetaData).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder generateClusterUuidIfNeeded() {
            if (this.clusterUUID.equals("_na_")) {
                this.clusterUUID = UUIDs.randomBase64UUID();
            }
            return this;
        }

        public MetaData build() {
            HashSet<String> allIndices = new HashSet<String>(this.indices.size());
            ArrayList<String> allOpenIndices = new ArrayList<String>();
            ArrayList<String> allClosedIndices = new ArrayList<String>();
            HashSet duplicateAliasesIndices = new HashSet();
            for (Object cursor : this.indices.values()) {
                IndexMetaData indexMetaData = (IndexMetaData)((ObjectCursor)cursor).value;
                String name = indexMetaData.getIndex().getName();
                boolean added = allIndices.add(name);
                assert (added) : "double index named [" + (String)name + "]";
                if (indexMetaData.getState() == IndexMetaData.State.OPEN) {
                    allOpenIndices.add(indexMetaData.getIndex().getName());
                } else if (indexMetaData.getState() == IndexMetaData.State.CLOSE) {
                    allClosedIndices.add(indexMetaData.getIndex().getName());
                }
                indexMetaData.getAliases().keysIt().forEachRemaining(duplicateAliasesIndices::add);
            }
            duplicateAliasesIndices.retainAll(allIndices);
            if (!duplicateAliasesIndices.isEmpty()) {
                ArrayList<String> duplicates = new ArrayList<String>();
                for (ObjectCursor cursor : this.indices.values()) {
                    for (String alias : duplicateAliasesIndices) {
                        if (!((IndexMetaData)cursor.value).getAliases().containsKey(alias)) continue;
                        duplicates.add(alias + " (alias of " + ((IndexMetaData)cursor.value).getIndex() + ")");
                    }
                }
                assert (duplicates.size() > 0);
                throw new IllegalStateException("index and alias names need to be unique, but the following duplicates were found [" + Strings.collectionToCommaDelimitedString(duplicates) + "]");
            }
            SortedMap<String, AliasOrIndex> aliasAndIndexLookup = Collections.unmodifiableSortedMap(this.buildAliasAndIndexLookup());
            String[] allIndicesArray = allIndices.toArray(new String[allIndices.size()]);
            String[] allOpenIndicesArray = allOpenIndices.toArray(new String[allOpenIndices.size()]);
            String[] allClosedIndicesArray = allClosedIndices.toArray(new String[allClosedIndices.size()]);
            return new MetaData(this.clusterUUID, this.version, this.transientSettings, this.persistentSettings, this.indices.build(), this.templates.build(), this.customs.build(), allIndicesArray, allOpenIndicesArray, allClosedIndicesArray, aliasAndIndexLookup);
        }

        private SortedMap<String, AliasOrIndex> buildAliasAndIndexLookup() {
            TreeMap<String, AliasOrIndex> aliasAndIndexLookup = new TreeMap<String, AliasOrIndex>();
            for (ObjectCursor cursor : this.indices.values()) {
                IndexMetaData indexMetaData = (IndexMetaData)cursor.value;
                AliasOrIndex existing = aliasAndIndexLookup.put(indexMetaData.getIndex().getName(), new AliasOrIndex.Index(indexMetaData));
                assert (existing == null) : "duplicate for " + indexMetaData.getIndex();
                for (ObjectObjectCursor<String, AliasMetaData> aliasCursor : indexMetaData.getAliases()) {
                    AliasMetaData aliasMetaData = (AliasMetaData)aliasCursor.value;
                    aliasAndIndexLookup.compute(aliasMetaData.getAlias(), (aliasName, alias) -> {
                        if (alias == null) {
                            return new AliasOrIndex.Alias(aliasMetaData, indexMetaData);
                        }
                        assert (alias instanceof AliasOrIndex.Alias) : alias.getClass().getName();
                        ((AliasOrIndex.Alias)alias).addIndex(indexMetaData);
                        return alias;
                    });
                }
            }
            aliasAndIndexLookup.values().stream().filter(AliasOrIndex::isAlias).forEach(alias -> ((AliasOrIndex.Alias)alias).computeAndValidateWriteIndex());
            return aliasAndIndexLookup;
        }

        public static String toXContent(MetaData metaData) throws IOException {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            builder.startObject();
            Builder.toXContent(metaData, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            return Strings.toString(builder);
        }

        public static void toXContent(MetaData metaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            XContentContext context = XContentContext.valueOf(params.param(MetaData.CONTEXT_MODE_PARAM, "API"));
            builder.startObject("meta-data");
            builder.field("version", metaData.version());
            builder.field("cluster_uuid", metaData.clusterUUID);
            if (!metaData.persistentSettings().isEmpty()) {
                builder.startObject("settings");
                metaData.persistentSettings().toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                builder.endObject();
            }
            if (context == XContentContext.API && !metaData.transientSettings().isEmpty()) {
                builder.startObject("transient_settings");
                metaData.transientSettings().toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                builder.endObject();
            }
            builder.startObject("templates");
            for (ObjectObjectCursor<String, Custom> cursor : metaData.templates().values()) {
                IndexTemplateMetaData.Builder.toXContent((IndexTemplateMetaData)cursor.value, builder, params);
            }
            builder.endObject();
            if (context == XContentContext.API && !metaData.indices().isEmpty()) {
                builder.startObject("indices");
                for (IndexMetaData indexMetaData : metaData) {
                    IndexMetaData.Builder.toXContent(indexMetaData, builder, params);
                }
                builder.endObject();
            }
            for (ObjectObjectCursor<String, Custom> cursor : metaData.customs()) {
                if (!((Custom)cursor.value).context().contains((Object)context)) continue;
                builder.startObject((String)cursor.key);
                ((Custom)cursor.value).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }

        public static MetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                    if (token != XContentParser.Token.FIELD_NAME) {
                        throw new IllegalArgumentException("Expected a field name but got " + token);
                    }
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
            }
            if (!"meta-data".equals(parser.currentName())) {
                throw new IllegalArgumentException("Expected [meta-data] as a field name but got " + currentFieldName);
            }
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Expected a START_OBJECT but got " + token);
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(Settings.fromXContent(parser));
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetaData.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexTemplateMetaData.Builder.fromXContent(parser, parser.currentName()));
                        }
                        continue;
                    }
                    try {
                        Custom custom = (Custom)parser.namedObject(Custom.class, currentFieldName, null);
                        builder.putCustom(custom.getWriteableName(), custom);
                    }
                    catch (NamedObjectNotFoundException ex) {
                        logger.warn("Skipping unknown custom object with type {}", (Object)currentFieldName);
                        parser.skipChildren();
                    }
                    continue;
                }
                if (token.isValue()) {
                    if ("version".equals(currentFieldName)) {
                        builder.version = parser.longValue();
                        continue;
                    }
                    if ("cluster_uuid".equals(currentFieldName) || "uuid".equals(currentFieldName)) {
                        builder.clusterUUID = parser.text();
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + token);
            }
            return builder.build();
        }
    }

    private static class MetaDataDiff
    implements Diff<MetaData> {
        private long version;
        private String clusterUUID;
        private Settings transientSettings;
        private Settings persistentSettings;
        private Diff<ImmutableOpenMap<String, IndexMetaData>> indices;
        private Diff<ImmutableOpenMap<String, IndexTemplateMetaData>> templates;
        private Diff<ImmutableOpenMap<String, Custom>> customs;

        MetaDataDiff(MetaData before, MetaData after) {
            this.clusterUUID = after.clusterUUID;
            this.version = after.version;
            this.transientSettings = after.transientSettings;
            this.persistentSettings = after.persistentSettings;
            this.indices = DiffableUtils.diff(before.indices, after.indices, DiffableUtils.getStringKeySerializer());
            this.templates = DiffableUtils.diff(before.templates, after.templates, DiffableUtils.getStringKeySerializer());
            this.customs = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        MetaDataDiff(StreamInput in) throws IOException {
            this.clusterUUID = in.readString();
            this.version = in.readLong();
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.indices = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), IndexMetaData::readFrom, IndexMetaData::readDiffFrom);
            this.templates = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), IndexTemplateMetaData::readFrom, IndexTemplateMetaData::readDiffFrom);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterUUID);
            out.writeLong(this.version);
            Settings.writeSettingsToStream(this.transientSettings, out);
            Settings.writeSettingsToStream(this.persistentSettings, out);
            this.indices.writeTo(out);
            this.templates.writeTo(out);
            this.customs.writeTo(out);
        }

        @Override
        public MetaData apply(MetaData part) {
            Builder builder = MetaData.builder();
            builder.clusterUUID(this.clusterUUID);
            builder.version(this.version);
            builder.transientSettings(this.transientSettings);
            builder.persistentSettings(this.persistentSettings);
            builder.indices(this.indices.apply(part.indices));
            builder.templates(this.templates.apply(part.templates));
            builder.customs(this.customs.apply(part.customs));
            return builder.build();
        }
    }

    public static interface Custom
    extends NamedDiffable<Custom>,
    ToXContentFragment,
    ClusterState.FeatureAware {
        public EnumSet<XContentContext> context();
    }

    public static enum XContentContext {
        API,
        GATEWAY,
        SNAPSHOT;

    }
}

