/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;

public interface AliasOrIndex {
    public boolean isAlias();

    public List<IndexMetaData> getIndices();

    public static class Alias
    implements AliasOrIndex {
        private final String aliasName;
        private final List<IndexMetaData> referenceIndexMetaDatas;
        private SetOnce<IndexMetaData> writeIndex = new SetOnce();

        public Alias(AliasMetaData aliasMetaData, IndexMetaData indexMetaData) {
            this.aliasName = aliasMetaData.getAlias();
            this.referenceIndexMetaDatas = new ArrayList<IndexMetaData>();
            this.referenceIndexMetaDatas.add(indexMetaData);
        }

        @Override
        public boolean isAlias() {
            return true;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        @Override
        public List<IndexMetaData> getIndices() {
            return this.referenceIndexMetaDatas;
        }

        @Nullable
        public IndexMetaData getWriteIndex() {
            return (IndexMetaData)this.writeIndex.get();
        }

        public Iterable<Tuple<String, AliasMetaData>> getConcreteIndexAndAliasMetaDatas() {
            return new Iterable<Tuple<String, AliasMetaData>>(){

                @Override
                public Iterator<Tuple<String, AliasMetaData>> iterator() {
                    return new Iterator<Tuple<String, AliasMetaData>>(){
                        int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < referenceIndexMetaDatas.size();
                        }

                        @Override
                        public Tuple<String, AliasMetaData> next() {
                            IndexMetaData indexMetaData = (IndexMetaData)referenceIndexMetaDatas.get(this.index++);
                            return new Tuple((Object)indexMetaData.getIndex().getName(), (Object)indexMetaData.getAliases().get(aliasName));
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        public AliasMetaData getFirstAliasMetaData() {
            return this.referenceIndexMetaDatas.get(0).getAliases().get(this.aliasName);
        }

        void addIndex(IndexMetaData indexMetaData) {
            this.referenceIndexMetaDatas.add(indexMetaData);
        }

        public void computeAndValidateWriteIndex() {
            List writeIndices = this.referenceIndexMetaDatas.stream().filter(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(this.aliasName).writeIndex())).collect(Collectors.toList());
            if (writeIndices.isEmpty() && this.referenceIndexMetaDatas.size() == 1 && this.referenceIndexMetaDatas.get(0).getAliases().get(this.aliasName).writeIndex() == null) {
                writeIndices.add(this.referenceIndexMetaDatas.get(0));
            }
            if (writeIndices.size() == 1) {
                this.writeIndex.set((Object)((IndexMetaData)writeIndices.get(0)));
            } else if (writeIndices.size() > 1) {
                List writeIndicesStrings = writeIndices.stream().map(i -> i.getIndex().getName()).collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] has more than one write index [" + Strings.collectionToCommaDelimitedString(writeIndicesStrings) + "]");
            }
        }
    }

    public static class Index
    implements AliasOrIndex {
        private final IndexMetaData concreteIndex;

        public Index(IndexMetaData indexMetaData) {
            this.concreteIndex = indexMetaData;
        }

        @Override
        public boolean isAlias() {
            return false;
        }

        @Override
        public List<IndexMetaData> getIndices() {
            return Collections.singletonList(this.concreteIndex);
        }

        public IndexMetaData getIndex() {
            return this.concreteIndex;
        }
    }
}

