/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.NodePersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksExecutorRegistry;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;

public class PersistentTasksNodeService
extends AbstractComponent
implements ClusterStateListener {
    private final Map<Long, AllocatedPersistentTask> runningTasks = new HashMap<Long, AllocatedPersistentTask>();
    private final PersistentTasksService persistentTasksService;
    private final PersistentTasksExecutorRegistry persistentTasksExecutorRegistry;
    private final TaskManager taskManager;
    private final NodePersistentTasksExecutor nodePersistentTasksExecutor;

    public PersistentTasksNodeService(Settings settings, PersistentTasksService persistentTasksService, PersistentTasksExecutorRegistry persistentTasksExecutorRegistry, TaskManager taskManager, NodePersistentTasksExecutor nodePersistentTasksExecutor) {
        super(settings);
        this.persistentTasksService = persistentTasksService;
        this.persistentTasksExecutorRegistry = persistentTasksExecutorRegistry;
        this.taskManager = taskManager;
        this.nodePersistentTasksExecutor = nodePersistentTasksExecutor;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        PersistentTasksCustomMetaData previousTasks;
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)event.state().getMetaData().custom("persistent_tasks");
        if (!Objects.equals(tasks, previousTasks = (PersistentTasksCustomMetaData)event.previousState().getMetaData().custom("persistent_tasks")) || event.nodesChanged()) {
            String localNodeId = event.state().getNodes().getLocalNodeId();
            HashSet<Long> notVisitedTasks = new HashSet<Long>(this.runningTasks.keySet());
            if (tasks != null) {
                for (PersistentTasksCustomMetaData.PersistentTask persistentTask : tasks.tasks()) {
                    if (!localNodeId.equals(persistentTask.getExecutorNode())) continue;
                    Long allocationId = persistentTask.getAllocationId();
                    AllocatedPersistentTask persistentTask2 = this.runningTasks.get(allocationId);
                    if (persistentTask2 == null) {
                        this.startTask(persistentTask);
                        continue;
                    }
                    notVisitedTasks.remove(allocationId);
                }
            }
            for (Long l : notVisitedTasks) {
                AllocatedPersistentTask task = this.runningTasks.get(l);
                if (task.getState() == AllocatedPersistentTask.State.COMPLETED) {
                    this.logger.trace("Found completed persistent task [{}] with id [{}] and allocation id [{}] - removing", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                    this.runningTasks.remove(l);
                    continue;
                }
                this.logger.trace("Found unregistered persistent task [{}] with id [{}] and allocation id [{}] - cancelling", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                this.cancelTask(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Params extends PersistentTaskParams> void startTask(final PersistentTasksCustomMetaData.PersistentTask<Params> taskInProgress) {
        final PersistentTasksExecutor executor = this.persistentTasksExecutorRegistry.getPersistentTaskExecutorSafe(taskInProgress.getTaskName());
        TaskAwareRequest request = new TaskAwareRequest(){
            TaskId parentTaskId;
            {
                this.parentTaskId = new TaskId("cluster", taskInProgress.getAllocationId());
            }

            @Override
            public void setParentTask(TaskId taskId) {
                throw new UnsupportedOperationException("parent task if for persistent tasks shouldn't change");
            }

            @Override
            public TaskId getParentTask() {
                return this.parentTaskId;
            }

            @Override
            public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
                return executor.createTask(id, type, action, parentTaskId, taskInProgress, headers);
            }
        };
        AllocatedPersistentTask task = (AllocatedPersistentTask)this.taskManager.register("persistent", taskInProgress.getTaskName() + "[c]", request);
        boolean processed = false;
        try {
            task.init(this.persistentTasksService, this.taskManager, this.logger, taskInProgress.getId(), taskInProgress.getAllocationId());
            this.logger.trace("Persistent task [{}] with id [{}] and allocation id [{}] was created", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
            try {
                this.runningTasks.put(taskInProgress.getAllocationId(), task);
                this.nodePersistentTasksExecutor.executeTask(taskInProgress.getParams(), taskInProgress.getStatus(), task, executor);
            }
            catch (Exception e) {
                task.markAsFailed(e);
            }
            processed = true;
        }
        finally {
            if (!processed) {
                this.logger.warn("Persistent task [{}] with id [{}] and allocation id [{}] failed to create", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                this.taskManager.unregister(task);
            }
        }
    }

    private void cancelTask(Long allocationId) {
        final AllocatedPersistentTask task = this.runningTasks.remove(allocationId);
        if (task.markAsCancelled()) {
            this.persistentTasksService.sendTaskManagerCancellation(task.getId(), new ActionListener<CancelTasksResponse>(){

                @Override
                public void onResponse(CancelTasksResponse cancelTasksResponse) {
                    PersistentTasksNodeService.this.logger.trace("Persistent task [{}] with id [{}] and allocation id [{}] was cancelled", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                }

                @Override
                public void onFailure(Exception e) {
                    PersistentTasksNodeService.this.logger.warn(() -> new ParameterizedMessage("failed to cancel task [{}] with id [{}] and allocation id [{}]", new Object[]{task.getAction(), task.getPersistentTaskId(), task.getAllocationId()}), (Throwable)e);
                }
            });
        }
    }

    public static class Status
    implements Task.Status {
        public static final String NAME = "persistent_executor";
        private final AllocatedPersistentTask.State state;

        public Status(AllocatedPersistentTask.State state) {
            this.state = Objects.requireNonNull(state, "State cannot be null");
        }

        public Status(StreamInput in) throws IOException {
            this.state = AllocatedPersistentTask.State.valueOf(in.readString());
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("state", this.state.toString());
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.state.toString());
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public AllocatedPersistentTask.State getState() {
            return this.state;
        }

        public boolean isFragment() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.state == status.state;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state});
        }
    }
}

