/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import com.carrotsearch.hppc.LongObjectHashMap;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.index.seqno.SeqNoStats;

public class LocalCheckpointTracker {
    static final int BIT_SET_SIZE = 1024;
    final LongObjectHashMap<FixedBitSet> processedSeqNo = new LongObjectHashMap();
    volatile long checkpoint;
    private volatile long nextSeqNo;

    public LocalCheckpointTracker(long maxSeqNo, long localCheckpoint) {
        if (localCheckpoint < 0L && localCheckpoint != -1L) {
            throw new IllegalArgumentException("local checkpoint must be non-negative or [-1] but was [" + localCheckpoint + "]");
        }
        if (maxSeqNo < 0L && maxSeqNo != -1L) {
            throw new IllegalArgumentException("max seq. no. must be non-negative or [-1] but was [" + maxSeqNo + "]");
        }
        this.nextSeqNo = maxSeqNo == -1L ? 0L : maxSeqNo + 1L;
        this.checkpoint = localCheckpoint;
    }

    synchronized long generateSeqNo() {
        return this.nextSeqNo++;
    }

    public synchronized void markSeqNoAsCompleted(long seqNo) {
        if (seqNo >= this.nextSeqNo) {
            this.nextSeqNo = seqNo + 1L;
        }
        if (seqNo <= this.checkpoint) {
            return;
        }
        FixedBitSet bitSet = this.getBitSetForSeqNo(seqNo);
        int offset = this.seqNoToBitSetOffset(seqNo);
        bitSet.set(offset);
        if (seqNo == this.checkpoint + 1L) {
            this.updateCheckpoint();
        }
    }

    synchronized void resetCheckpoint(long checkpoint) {
        assert (checkpoint != -2L);
        assert (checkpoint <= this.checkpoint);
        this.processedSeqNo.clear();
        this.checkpoint = checkpoint;
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    long getMaxSeqNo() {
        return this.nextSeqNo - 1L;
    }

    synchronized SeqNoStats getStats(long globalCheckpoint) {
        return new SeqNoStats(this.getMaxSeqNo(), this.getCheckpoint(), globalCheckpoint);
    }

    @SuppressForbidden(reason="Object#wait")
    synchronized void waitForOpsToComplete(long seqNo) throws InterruptedException {
        while (this.checkpoint < seqNo) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="Object#notifyAll")
    private void updateCheckpoint() {
        assert (Thread.holdsLock(this));
        assert (this.getBitSetForSeqNo(this.checkpoint + 1L).get(this.seqNoToBitSetOffset(this.checkpoint + 1L))) : "updateCheckpoint is called but the bit following the checkpoint is not set";
        try {
            long bitSetKey = this.getBitSetKey(this.checkpoint);
            FixedBitSet current = (FixedBitSet)this.processedSeqNo.get(bitSetKey);
            if (current == null) {
                assert (this.checkpoint % 1024L == 1023L);
                current = (FixedBitSet)this.processedSeqNo.get(++bitSetKey);
            }
            do {
                ++this.checkpoint;
                if (this.checkpoint != this.lastSeqNoInBitSet(bitSetKey)) continue;
                assert (current != null);
                FixedBitSet removed = (FixedBitSet)this.processedSeqNo.remove(bitSetKey);
                assert (removed == current);
                current = (FixedBitSet)this.processedSeqNo.get(++bitSetKey);
            } while (current != null && current.get(this.seqNoToBitSetOffset(this.checkpoint + 1L)));
        }
        finally {
            this.notifyAll();
        }
    }

    private long lastSeqNoInBitSet(long bitSetKey) {
        return (1L + bitSetKey) * 1024L - 1L;
    }

    private long getBitSetKey(long seqNo) {
        assert (Thread.holdsLock(this));
        return seqNo / 1024L;
    }

    private FixedBitSet getBitSetForSeqNo(long seqNo) {
        FixedBitSet bitSet;
        assert (Thread.holdsLock(this));
        long bitSetKey = this.getBitSetKey(seqNo);
        int index = this.processedSeqNo.indexOf(bitSetKey);
        if (this.processedSeqNo.indexExists(index)) {
            bitSet = (FixedBitSet)this.processedSeqNo.indexGet(index);
        } else {
            bitSet = new FixedBitSet(1024);
            this.processedSeqNo.indexInsert(index, bitSetKey, (Object)bitSet);
        }
        return bitSet;
    }

    private int seqNoToBitSetOffset(long seqNo) {
        assert (Thread.holdsLock(this));
        return Math.toIntExact(seqNo % 1024L);
    }
}

