/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.QueryRescoreMode;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.rescore.Rescorer;

public final class QueryRescorer
implements Rescorer {
    public static final Rescorer INSTANCE = new QueryRescorer();
    public static final String NAME = "query";
    private static final Comparator<ScoreDoc> SCORE_DOC_COMPARATOR = new Comparator<ScoreDoc>(){

        @Override
        public int compare(ScoreDoc o1, ScoreDoc o2) {
            int cmp = Float.compare(o2.score, o1.score);
            return cmp == 0 ? Integer.compare(o1.doc, o2.doc) : cmp;
        }
    };

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public TopDocs rescore(TopDocs topDocs, SearchContext context, RescoreSearchContext rescoreContext) throws IOException {
        assert (rescoreContext != null);
        if (topDocs == null || topDocs.totalHits == 0L || topDocs.scoreDocs.length == 0) {
            return topDocs;
        }
        final QueryRescoreContext rescore = (QueryRescoreContext)rescoreContext;
        org.apache.lucene.search.QueryRescorer rescorer = new org.apache.lucene.search.QueryRescorer(rescore.query()){

            protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                if (secondPassMatches) {
                    return rescore.scoreMode.combine(firstPassScore * rescore.queryWeight(), secondPassScore * rescore.rescoreQueryWeight());
                }
                return firstPassScore * rescore.queryWeight();
            }
        };
        TopDocs topNFirstPass = this.topN(topDocs, rescoreContext.window());
        TopDocs rescored = rescorer.rescore((IndexSearcher)context.searcher(), topNFirstPass, rescoreContext.window());
        return this.combine(topDocs, rescored, (QueryRescoreContext)rescoreContext);
    }

    @Override
    public Explanation explain(int topLevelDocId, SearchContext context, RescoreSearchContext rescoreContext, Explanation sourceExplanation) throws IOException {
        QueryRescoreContext rescore = (QueryRescoreContext)rescoreContext;
        ContextIndexSearcher searcher = context.searcher();
        if (sourceExplanation == null) {
            return Explanation.noMatch((String)"nothing matched", (Explanation[])new Explanation[0]);
        }
        Explanation rescoreExplain = searcher.explain(rescore.query(), topLevelDocId);
        float primaryWeight = rescore.queryWeight();
        Explanation prim = sourceExplanation.isMatch() ? Explanation.match((float)(sourceExplanation.getValue() * primaryWeight), (String)"product of:", (Explanation[])new Explanation[]{sourceExplanation, Explanation.match((float)primaryWeight, (String)"primaryWeight", (Explanation[])new Explanation[0])}) : Explanation.noMatch((String)"First pass did not match", (Explanation[])new Explanation[]{sourceExplanation});
        if (rescoreExplain != null && rescoreExplain.isMatch()) {
            float secondaryWeight = rescore.rescoreQueryWeight();
            Explanation sec = Explanation.match((float)(rescoreExplain.getValue() * secondaryWeight), (String)"product of:", (Explanation[])new Explanation[]{rescoreExplain, Explanation.match((float)secondaryWeight, (String)"secondaryWeight", (Explanation[])new Explanation[0])});
            QueryRescoreMode scoreMode = rescore.scoreMode();
            return Explanation.match((float)scoreMode.combine(prim.getValue(), sec.getValue()), (String)(scoreMode + " of:"), (Explanation[])new Explanation[]{prim, sec});
        }
        return prim;
    }

    private TopDocs topN(TopDocs in, int topN) {
        if (in.totalHits < (long)topN) {
            assert ((long)in.scoreDocs.length == in.totalHits);
            return in;
        }
        ScoreDoc[] subset = new ScoreDoc[topN];
        System.arraycopy(in.scoreDocs, 0, subset, 0, topN);
        return new TopDocs(in.totalHits, subset, in.getMaxScore());
    }

    private TopDocs combine(TopDocs in, TopDocs resorted, QueryRescoreContext ctx) {
        System.arraycopy(resorted.scoreDocs, 0, in.scoreDocs, 0, resorted.scoreDocs.length);
        if (in.scoreDocs.length > resorted.scoreDocs.length) {
            for (int i = resorted.scoreDocs.length; i < in.scoreDocs.length; ++i) {
                in.scoreDocs[i].score *= ctx.queryWeight();
            }
            Arrays.sort(in.scoreDocs, SCORE_DOC_COMPARATOR);
        }
        in.setMaxScore(in.scoreDocs[0].score);
        return in;
    }

    @Override
    public void extractTerms(SearchContext context, RescoreSearchContext rescoreContext, Set<Term> termsSet) {
        try {
            context.searcher().createNormalizedWeight(((QueryRescoreContext)rescoreContext).query(), false).extractTerms(termsSet);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to extract terms", e);
        }
    }

    public static class QueryRescoreContext
    extends RescoreSearchContext {
        static final int DEFAULT_WINDOW_SIZE = 10;
        private Query query;
        private float queryWeight = 1.0f;
        private float rescoreQueryWeight = 1.0f;
        private QueryRescoreMode scoreMode = QueryRescoreMode.Total;

        public QueryRescoreContext(QueryRescorer rescorer) {
            super(QueryRescorer.NAME, 10, rescorer);
        }

        public void setQuery(Query query) {
            this.query = query;
        }

        public Query query() {
            return this.query;
        }

        public float queryWeight() {
            return this.queryWeight;
        }

        public float rescoreQueryWeight() {
            return this.rescoreQueryWeight;
        }

        public QueryRescoreMode scoreMode() {
            return this.scoreMode;
        }

        public void setRescoreQueryWeight(float rescoreQueryWeight) {
            this.rescoreQueryWeight = rescoreQueryWeight;
        }

        public void setQueryWeight(float queryWeight) {
            this.queryWeight = queryWeight;
        }

        public void setScoreMode(QueryRescoreMode scoreMode) {
            this.scoreMode = scoreMode;
        }

        public void setScoreMode(String scoreMode) {
            this.setScoreMode(QueryRescoreMode.fromString(scoreMode));
        }
    }
}

