/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.resync;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

public final class ResyncReplicationRequest
extends ReplicatedWriteRequest<ResyncReplicationRequest> {
    private List<Translog.Operation> operations;

    ResyncReplicationRequest() {
    }

    public ResyncReplicationRequest(ShardId shardId, List<Translog.Operation> operations) {
        super(shardId);
        this.operations = operations;
    }

    public List<Translog.Operation> getOperations() {
        return this.operations;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.operations = in.readList(Translog.Operation::readType);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.operations);
    }

    @Override
    public String toString() {
        return "TransportResyncReplicationAction.Request{shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + '\'' + ", ops=" + this.operations.size() + "}";
    }
}

