/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.ckb.SoraniAnalyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lt.LithuanianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.elasticsearch.Version;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.analysis.PatternAnalyzer;
import org.elasticsearch.index.analysis.SnowballAnalyzer;
import org.elasticsearch.index.analysis.StandardHtmlStripAnalyzer;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public enum PreBuiltAnalyzers {
    STANDARD(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version) {
            StandardAnalyzer a = new StandardAnalyzer(CharArraySet.EMPTY_SET);
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    DEFAULT(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version) {
            return STANDARD.getAnalyzer(version);
        }
    }
    ,
    KEYWORD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Analyzer create(Version version) {
            return new KeywordAnalyzer();
        }
    }
    ,
    STOP{

        @Override
        protected Analyzer create(Version version) {
            StopAnalyzer a = new StopAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    WHITESPACE{

        @Override
        protected Analyzer create(Version version) {
            WhitespaceAnalyzer a = new WhitespaceAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    SIMPLE{

        @Override
        protected Analyzer create(Version version) {
            SimpleAnalyzer a = new SimpleAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    CLASSIC{

        @Override
        protected Analyzer create(Version version) {
            ClassicAnalyzer a = new ClassicAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    SNOWBALL{

        @Override
        protected Analyzer create(Version version) {
            SnowballAnalyzer analyzer = new SnowballAnalyzer("English", StopAnalyzer.ENGLISH_STOP_WORDS_SET);
            analyzer.setVersion(version.luceneVersion);
            return analyzer;
        }
    }
    ,
    PATTERN(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version) {
            return new PatternAnalyzer(Regex.compile("\\W+", null), true, CharArraySet.EMPTY_SET);
        }
    }
    ,
    STANDARD_HTML_STRIP(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version) {
            StandardHtmlStripAnalyzer analyzer = new StandardHtmlStripAnalyzer(CharArraySet.EMPTY_SET);
            analyzer.setVersion(version.luceneVersion);
            return analyzer;
        }
    }
    ,
    ARABIC{

        @Override
        protected Analyzer create(Version version) {
            ArabicAnalyzer a = new ArabicAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    ARMENIAN{

        @Override
        protected Analyzer create(Version version) {
            ArmenianAnalyzer a = new ArmenianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    BASQUE{

        @Override
        protected Analyzer create(Version version) {
            BasqueAnalyzer a = new BasqueAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    BRAZILIAN{

        @Override
        protected Analyzer create(Version version) {
            BrazilianAnalyzer a = new BrazilianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    BULGARIAN{

        @Override
        protected Analyzer create(Version version) {
            BulgarianAnalyzer a = new BulgarianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    CATALAN{

        @Override
        protected Analyzer create(Version version) {
            CatalanAnalyzer a = new CatalanAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    CHINESE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Analyzer create(Version version) {
            StandardAnalyzer a = new StandardAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    CJK{

        @Override
        protected Analyzer create(Version version) {
            CJKAnalyzer a = new CJKAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    CZECH{

        @Override
        protected Analyzer create(Version version) {
            CzechAnalyzer a = new CzechAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    DUTCH{

        @Override
        protected Analyzer create(Version version) {
            DutchAnalyzer a = new DutchAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    DANISH{

        @Override
        protected Analyzer create(Version version) {
            DanishAnalyzer a = new DanishAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    ENGLISH{

        @Override
        protected Analyzer create(Version version) {
            EnglishAnalyzer a = new EnglishAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    FINNISH{

        @Override
        protected Analyzer create(Version version) {
            FinnishAnalyzer a = new FinnishAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    FRENCH{

        @Override
        protected Analyzer create(Version version) {
            FrenchAnalyzer a = new FrenchAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    GALICIAN{

        @Override
        protected Analyzer create(Version version) {
            GalicianAnalyzer a = new GalicianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    GERMAN{

        @Override
        protected Analyzer create(Version version) {
            GermanAnalyzer a = new GermanAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    GREEK{

        @Override
        protected Analyzer create(Version version) {
            GreekAnalyzer a = new GreekAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    HINDI{

        @Override
        protected Analyzer create(Version version) {
            HindiAnalyzer a = new HindiAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    HUNGARIAN{

        @Override
        protected Analyzer create(Version version) {
            HungarianAnalyzer a = new HungarianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    INDONESIAN{

        @Override
        protected Analyzer create(Version version) {
            IndonesianAnalyzer a = new IndonesianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    IRISH{

        @Override
        protected Analyzer create(Version version) {
            IrishAnalyzer a = new IrishAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    ITALIAN{

        @Override
        protected Analyzer create(Version version) {
            ItalianAnalyzer a = new ItalianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    LATVIAN{

        @Override
        protected Analyzer create(Version version) {
            LatvianAnalyzer a = new LatvianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    LITHUANIAN{

        @Override
        protected Analyzer create(Version version) {
            LithuanianAnalyzer a = new LithuanianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    NORWEGIAN{

        @Override
        protected Analyzer create(Version version) {
            NorwegianAnalyzer a = new NorwegianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    PERSIAN{

        @Override
        protected Analyzer create(Version version) {
            PersianAnalyzer a = new PersianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    PORTUGUESE{

        @Override
        protected Analyzer create(Version version) {
            PortugueseAnalyzer a = new PortugueseAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    ROMANIAN{

        @Override
        protected Analyzer create(Version version) {
            RomanianAnalyzer a = new RomanianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    RUSSIAN{

        @Override
        protected Analyzer create(Version version) {
            RussianAnalyzer a = new RussianAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    SORANI{

        @Override
        protected Analyzer create(Version version) {
            SoraniAnalyzer a = new SoraniAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    SPANISH{

        @Override
        protected Analyzer create(Version version) {
            SpanishAnalyzer a = new SpanishAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    SWEDISH{

        @Override
        protected Analyzer create(Version version) {
            SwedishAnalyzer a = new SwedishAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    TURKISH{

        @Override
        protected Analyzer create(Version version) {
            TurkishAnalyzer a = new TurkishAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    }
    ,
    THAI{

        @Override
        protected Analyzer create(Version version) {
            ThaiAnalyzer a = new ThaiAnalyzer();
            a.setVersion(version.luceneVersion);
            return a;
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<Analyzer> cache;

    protected abstract Analyzer create(Version var1);

    private PreBuiltAnalyzers() {
        this(PreBuiltCacheFactory.CachingStrategy.LUCENE);
    }

    private PreBuiltAnalyzers(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    PreBuiltCacheFactory.PreBuiltCache<Analyzer> getCache() {
        return this.cache;
    }

    public synchronized Analyzer getAnalyzer(Version version) {
        Analyzer analyzer = this.cache.get(version);
        if (analyzer == null) {
            analyzer = this.create(version);
            this.cache.put(version, analyzer);
        }
        return analyzer;
    }

    public static PreBuiltAnalyzers getOrDefault(String name, PreBuiltAnalyzers defaultAnalyzer) {
        try {
            return PreBuiltAnalyzers.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultAnalyzer;
        }
    }
}

