/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetStoredScriptRequest
extends MasterNodeReadRequest<GetStoredScriptRequest> {
    protected String id;
    protected String lang;

    GetStoredScriptRequest() {
    }

    public GetStoredScriptRequest(String id, String lang) {
        this.id = id;
        this.lang = lang;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null || this.id.isEmpty()) {
            validationException = ValidateActions.addValidationError("must specify id for stored script", validationException);
        } else if (this.id.contains("#")) {
            validationException = ValidateActions.addValidationError("id cannot contain '#' for stored script", validationException);
        }
        if (this.lang != null && this.lang.contains("#")) {
            validationException = ValidateActions.addValidationError("lang cannot contain '#' for stored script", validationException);
        }
        return validationException;
    }

    public String id() {
        return this.id;
    }

    public GetStoredScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public String lang() {
        return this.lang;
    }

    public GetStoredScriptRequest lang(String lang) {
        this.lang = lang;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.lang = in.readString();
        if (this.lang.isEmpty()) {
            this.lang = null;
        }
        this.id = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.lang == null ? "" : this.lang);
        out.writeString(this.id);
    }

    public String toString() {
        return "get script [" + this.lang + "][" + this.id + "]";
    }
}

