/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LegacyTokenCountFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;

public class TokenCountFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "token_count";
    private NamedAnalyzer analyzer;
    private boolean enablePositionIncrements;

    protected TokenCountFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, NamedAnalyzer analyzer, boolean enablePositionIncrements, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.analyzer = analyzer;
        this.enablePositionIncrements = enablePositionIncrements;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        int tokenCount = value == null ? (Integer)this.fieldType().nullValue() : TokenCountFieldMapper.countPositions((Analyzer)this.analyzer, this.name(), value, this.enablePositionIncrements);
        boolean indexed = this.fieldType().indexOptions() != IndexOptions.NONE;
        boolean docValued = this.fieldType().hasDocValues();
        boolean stored = this.fieldType().stored();
        fields.addAll(NumberFieldMapper.NumberType.INTEGER.createFields(this.fieldType().name(), tokenCount, indexed, docValued, stored));
    }

    static int countPositions(Analyzer analyzer, String fieldName, String fieldValue, boolean enablePositionIncrements) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, fieldValue);){
            int count = 0;
            PositionIncrementAttribute position = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                if (enablePositionIncrements) {
                    count += position.getPositionIncrement();
                    continue;
                }
                count += Math.min(1, position.getPositionIncrement());
            }
            tokenStream.end();
            if (enablePositionIncrements) {
                count += position.getPositionIncrement();
            }
            int n = count;
            return n;
        }
    }

    public String analyzer() {
        return this.analyzer.name();
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        this.analyzer = ((TokenCountFieldMapper)mergeWith).analyzer;
        this.enablePositionIncrements = ((TokenCountFieldMapper)mergeWith).enablePositionIncrements;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        builder.field("analyzer", this.analyzer());
        if (includeDefaults || !this.enablePositionIncrements()) {
            builder.field("enable_position_increments", this.enablePositionIncrements());
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha2)) {
                return new LegacyTokenCountFieldMapper.TypeParser().parse(name, node, parserContext);
            }
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    builder.nullValue(XContentMapValues.nodeIntegerValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("analyzer")) {
                    NamedAnalyzer analyzer = parserContext.getIndexAnalyzers().get(propNode.toString());
                    if (analyzer == null) {
                        throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                    }
                    builder.analyzer(analyzer);
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("enable_position_increments")) continue;
                builder.enablePositionIncrements(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
            }
            TypeParsers.parseField(builder, name, node, parserContext);
            if (builder.analyzer() == null) {
                throw new MapperParsingException("Analyzer must be set for field [" + name + "] but wasn't.");
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, TokenCountFieldMapper> {
        private NamedAnalyzer analyzer;
        private boolean enablePositionIncrements = true;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder analyzer(NamedAnalyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public NamedAnalyzer analyzer() {
            return this.analyzer;
        }

        public Builder enablePositionIncrements(boolean enablePositionIncrements) {
            this.enablePositionIncrements = enablePositionIncrements;
            return this;
        }

        public boolean enablePositionIncrements() {
            return this.enablePositionIncrements;
        }

        @Override
        public TokenCountFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new TokenCountFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.analyzer, this.enablePositionIncrements, this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new NumberFieldMapper.NumberFieldType(NumberFieldMapper.NumberType.INTEGER);
        public static final boolean DEFAULT_POSITION_INCREMENTS = true;
    }
}

