/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.MinDocQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.grouping.CollapsingTopDocsCollector;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.MinimumScoreCollector;
import org.elasticsearch.common.lucene.search.FilteredCollector;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.profile.SearchProfileShardResults;
import org.elasticsearch.search.profile.query.InternalProfileCollector;
import org.elasticsearch.search.query.CancellableCollector;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescorePhase;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestPhase;

public class QueryPhase
implements SearchPhase {
    private final AggregationPhase aggregationPhase = new AggregationPhase();
    private final SuggestPhase suggestPhase;
    private RescorePhase rescorePhase;

    public QueryPhase(Settings settings) {
        this.suggestPhase = new SuggestPhase(settings);
        this.rescorePhase = new RescorePhase(settings);
    }

    @Override
    public void preProcess(SearchContext context) {
        context.preProcess(true);
    }

    @Override
    public void execute(SearchContext searchContext) throws QueryPhaseExecutionException {
        if (searchContext.hasOnlySuggest()) {
            this.suggestPhase.execute(searchContext);
            searchContext.queryResult().topDocs(new TopDocs(0, Lucene.EMPTY_SCORE_DOCS, 0.0f), new DocValueFormat[0]);
            return;
        }
        this.aggregationPhase.preProcess(searchContext);
        boolean rescore = QueryPhase.execute(searchContext, searchContext.searcher());
        if (rescore) {
            this.rescorePhase.execute(searchContext);
        }
        this.suggestPhase.execute(searchContext);
        this.aggregationPhase.execute(searchContext);
        if (searchContext.getProfilers() != null) {
            ProfileShardResult shardResults = SearchProfileShardResults.buildShardResults(searchContext.getProfilers());
            searchContext.queryResult().profileResults(shardResults);
        }
    }

    private static boolean returnsDocsInOrder(Query query, SortAndFormats sf) {
        if (sf == null || Sort.RELEVANCE.equals((Object)sf.sort)) {
            return query.getClass() == ConstantScoreQuery.class || query.getClass() == MatchAllDocsQuery.class;
        }
        return Sort.INDEXORDER.equals((Object)sf.sort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean execute(SearchContext searchContext, final IndexSearcher searcher) throws QueryPhaseExecutionException {
        QuerySearchResult queryResult = searchContext.queryResult();
        queryResult.searchTimedOut(false);
        boolean doProfile = searchContext.getProfilers() != null;
        boolean rescore = false;
        try {
            Object child;
            boolean timeoutSet;
            Object child2;
            boolean terminateAfterSet;
            Callable<TopDocs> topDocsCallable;
            Object collector;
            queryResult.from(searchContext.from());
            queryResult.size(searchContext.size());
            Query query = searchContext.query();
            int totalNumDocs = searcher.getIndexReader().numDocs();
            int numDocs = Math.min(searchContext.from() + searchContext.size(), totalNumDocs);
            DocValueFormat[] sortValueFormats = new DocValueFormat[]{};
            assert (query == searcher.rewrite(query));
            if (searchContext.size() == 0) {
                TotalHitCountCollector totalHitCountCollector;
                collector = totalHitCountCollector = new TotalHitCountCollector();
                if (searchContext.getProfilers() != null) {
                    collector = new InternalProfileCollector((Collector)collector, "search_count", Collections.emptyList());
                }
                topDocsCallable = () -> new TopDocs(totalHitCountCollector.getTotalHits(), Lucene.EMPTY_SCORE_DOCS, 0.0f);
            } else {
                TopFieldCollector topDocsCollector;
                ScrollContext scrollContext = searchContext.scrollContext();
                assert (scrollContext != null == (searchContext.request().scroll() != null));
                FieldDoc after = null;
                if (searchContext.request().scroll() != null) {
                    numDocs = Math.min(searchContext.size(), totalNumDocs);
                    after = scrollContext.lastEmittedDoc;
                    if (QueryPhase.returnsDocsInOrder(query, searchContext.sort())) {
                        if (scrollContext.totalHits == -1) {
                            assert (scrollContext.lastEmittedDoc == null);
                        } else {
                            if (scrollContext.lastEmittedDoc != null) {
                                BooleanQuery bq = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new MinDocQuery(after.doc + 1), BooleanClause.Occur.FILTER).build();
                                query = bq;
                            }
                            searchContext.terminateAfter(numDocs);
                        }
                    }
                } else {
                    after = searchContext.searchAfter();
                }
                if (totalNumDocs == 0) {
                    numDocs = 1;
                }
                assert (numDocs > 0);
                if (searchContext.collapse() == null) {
                    if (searchContext.sort() != null) {
                        SortAndFormats sf = searchContext.sort();
                        topDocsCollector = TopFieldCollector.create((Sort)sf.sort, (int)numDocs, (FieldDoc)after, (boolean)true, (boolean)searchContext.trackScores(), (boolean)searchContext.trackScores());
                        sortValueFormats = sf.formats;
                    } else {
                        rescore = !searchContext.rescore().isEmpty();
                        for (RescoreSearchContext rescoreContext : searchContext.rescore()) {
                            numDocs = Math.max(rescoreContext.window(), numDocs);
                        }
                        topDocsCollector = TopScoreDocCollector.create((int)numDocs, (ScoreDoc)after);
                    }
                } else {
                    Sort sort = Sort.RELEVANCE;
                    if (searchContext.sort() != null) {
                        sort = searchContext.sort().sort;
                    }
                    CollapseContext collapse = searchContext.collapse();
                    topDocsCollector = collapse.createTopDocs(sort, numDocs, searchContext.trackScores());
                    sortValueFormats = searchContext.sort() == null ? new DocValueFormat[]{DocValueFormat.RAW} : searchContext.sort().formats;
                }
                collector = topDocsCollector;
                if (doProfile) {
                    collector = new InternalProfileCollector((Collector)collector, "search_top_hits", Collections.emptyList());
                }
                topDocsCallable = () -> QueryPhase.lambda$execute$1((Collector)topDocsCollector, scrollContext, searchContext);
            }
            boolean bl = terminateAfterSet = searchContext.terminateAfter() != 0;
            if (terminateAfterSet) {
                child2 = collector;
                collector = Lucene.wrapCountBasedEarlyTerminatingCollector((Collector)collector, searchContext.terminateAfter());
                if (doProfile) {
                    collector = new InternalProfileCollector((Collector)collector, "search_terminate_after_count", Collections.singletonList((InternalProfileCollector)child2));
                }
            }
            if (searchContext.parsedPostFilter() != null) {
                child2 = collector;
                Weight filterWeight = searcher.createNormalizedWeight(searchContext.parsedPostFilter().query(), false);
                collector = new FilteredCollector((Collector)collector, filterWeight);
                if (doProfile) {
                    collector = new InternalProfileCollector((Collector)collector, "search_post_filter", Collections.singletonList((InternalProfileCollector)child2));
                }
            }
            final ArrayList<Object> subCollectors = new ArrayList<Object>();
            subCollectors.add(collector);
            subCollectors.addAll(searchContext.queryCollectors().values());
            collector = MultiCollector.wrap(subCollectors);
            if (doProfile && !(collector instanceof InternalProfileCollector)) {
                AbstractList<InternalProfileCollector> children = new AbstractList<InternalProfileCollector>(){

                    @Override
                    public InternalProfileCollector get(int index) {
                        return (InternalProfileCollector)subCollectors.get(index);
                    }

                    @Override
                    public int size() {
                        return subCollectors.size();
                    }
                };
                collector = new InternalProfileCollector((Collector)collector, "search_multi", (List<InternalProfileCollector>)children);
            }
            if (searchContext.minimumScore() != null) {
                TotalHitCountCollector child3 = collector;
                collector = new MinimumScoreCollector((Collector)collector, searchContext.minimumScore().floatValue());
                if (doProfile) {
                    collector = new InternalProfileCollector((Collector)collector, "search_min_score", Collections.singletonList((InternalProfileCollector)child3));
                }
            }
            if (collector.getClass() == TotalHitCountCollector.class) {
                while (query instanceof ConstantScoreQuery) {
                    query = ((ConstantScoreQuery)query).getQuery();
                }
                if (query.getClass() == MatchAllDocsQuery.class) {
                    collector = null;
                    topDocsCallable = new Callable<TopDocs>(){

                        @Override
                        public TopDocs call() throws Exception {
                            int count = searcher.getIndexReader().numDocs();
                            return new TopDocs(count, Lucene.EMPTY_SCORE_DOCS, 0.0f);
                        }
                    };
                } else if (query.getClass() == TermQuery.class && !searcher.getIndexReader().hasDeletions()) {
                    final Term term = ((TermQuery)query).getTerm();
                    collector = null;
                    topDocsCallable = new Callable<TopDocs>(){

                        @Override
                        public TopDocs call() throws Exception {
                            int count = 0;
                            for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
                                count += context.reader().docFreq(term);
                            }
                            return new TopDocs(count, Lucene.EMPTY_SCORE_DOCS, 0.0f);
                        }
                    };
                }
            }
            boolean bl2 = timeoutSet = searchContext.timeout() != null && !searchContext.timeout().equals(SearchService.NO_TIMEOUT);
            if (timeoutSet && collector != null) {
                child = collector;
                collector = Lucene.wrapTimeLimitingCollector((Collector)collector, searchContext.timeEstimateCounter(), searchContext.timeout().millis());
                if (doProfile) {
                    collector = new InternalProfileCollector((Collector)collector, "search_timeout", Collections.singletonList((InternalProfileCollector)child));
                }
            }
            if (collector != null) {
                child = collector;
                collector = new CancellableCollector(searchContext.getTask()::isCancelled, searchContext.lowLevelCancellation(), (Collector)collector);
                if (doProfile) {
                    collector = new InternalProfileCollector((Collector)collector, "search_cancelled", Collections.singletonList((InternalProfileCollector)child));
                }
            }
            try {
                if (collector != null) {
                    if (doProfile) {
                        searchContext.getProfilers().getCurrentQueryProfiler().setCollector((InternalProfileCollector)collector);
                    }
                    searcher.search(query, (Collector)collector);
                }
            }
            catch (TimeLimitingCollector.TimeExceededException e) {
                assert (timeoutSet) : "TimeExceededException thrown even though timeout wasn't set";
                queryResult.searchTimedOut(true);
            }
            catch (Lucene.EarlyTerminationException e) {
                assert (terminateAfterSet) : "EarlyTerminationException thrown even though terminateAfter wasn't set";
                queryResult.terminatedEarly(true);
            }
            finally {
                searchContext.clearReleasables(SearchContext.Lifetime.COLLECTION);
            }
            if (terminateAfterSet && queryResult.terminatedEarly() == null) {
                queryResult.terminatedEarly(false);
            }
            queryResult.topDocs((TopDocs)topDocsCallable.call(), sortValueFormats);
            if (searchContext.getProfilers() != null) {
                ProfileShardResult shardResults = SearchProfileShardResults.buildShardResults(searchContext.getProfilers());
                searchContext.queryResult().profileResults(shardResults);
            }
            return rescore;
        }
        catch (Exception e) {
            throw new QueryPhaseExecutionException(searchContext, "Failed to execute main query", (Throwable)e);
        }
    }

    private static /* synthetic */ TopDocs lambda$execute$1(Collector topDocsCollector, ScrollContext scrollContext, SearchContext searchContext) throws Exception {
        Object topDocs;
        if (topDocsCollector instanceof TopDocsCollector) {
            topDocs = ((TopDocsCollector)topDocsCollector).topDocs();
        } else if (topDocsCollector instanceof CollapsingTopDocsCollector) {
            topDocs = ((CollapsingTopDocsCollector)topDocsCollector).getTopDocs();
        } else {
            throw new IllegalStateException("Unknown top docs collector " + topDocsCollector.getClass().getName());
        }
        if (scrollContext != null) {
            if (scrollContext.totalHits == -1) {
                scrollContext.totalHits = topDocs.totalHits;
                scrollContext.maxScore = topDocs.getMaxScore();
            } else {
                topDocs.totalHits = scrollContext.totalHits;
                topDocs.setMaxScore(scrollContext.maxScore);
            }
            if (searchContext.request().numberOfShards() == 1 && topDocs.scoreDocs.length > 0) {
                scrollContext.lastEmittedDoc = topDocs.scoreDocs[topDocs.scoreDocs.length - 1];
            }
        }
        return topDocs;
    }
}

