/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class InternalSignificantTerms<A extends InternalSignificantTerms<A, B>, B extends Bucket<B>>
extends InternalMultiBucketAggregation<A, B>
implements SignificantTerms,
ToXContent {
    protected final int requiredSize;
    protected final long minDocCount;

    protected InternalSignificantTerms(String name, int requiredSize, long minDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
    }

    protected InternalSignificantTerms(StreamInput in) throws IOException {
        super(in);
        this.requiredSize = InternalSignificantTerms.readSize(in);
        this.minDocCount = in.readVLong();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        InternalSignificantTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        this.writeTermTypeInfoTo(out);
    }

    protected abstract void writeTermTypeInfoTo(StreamOutput var1) throws IOException;

    @Override
    public Iterator<SignificantTerms.Bucket> iterator() {
        return this.getBuckets().iterator();
    }

    @Override
    public List<SignificantTerms.Bucket> getBuckets() {
        return Collections.unmodifiableList(this.getBucketsInternal());
    }

    protected abstract List<B> getBucketsInternal();

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        void var12_17;
        long globalSubsetSize = 0L;
        long globalSupersetSize = 0L;
        for (InternalAggregation internalAggregation : aggregations) {
            InternalSignificantTerms terms = (InternalSignificantTerms)internalAggregation;
            globalSubsetSize += terms.getSubsetSize();
            globalSupersetSize += terms.getSupersetSize();
        }
        HashMap buckets = new HashMap();
        for (InternalAggregation aggregation : aggregations) {
            InternalSignificantTerms terms = (InternalSignificantTerms)aggregation;
            for (Bucket bucket : terms.getBucketsInternal()) {
                ArrayList existingBuckets = (ArrayList)buckets.get(bucket.getKeyAsString());
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList(aggregations.size());
                    buckets.put(bucket.getKeyAsString(), existingBuckets);
                }
                existingBuckets.add(bucket.newBucket(bucket.getSubsetDf(), globalSubsetSize, bucket.getSupersetDf(), globalSupersetSize, bucket.aggregations));
            }
        }
        SignificanceHeuristic significanceHeuristic = this.getSignificanceHeuristic().rewrite(reduceContext);
        int size = !reduceContext.isFinalReduce() ? buckets.size() : Math.min(this.requiredSize, buckets.size());
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        for (Map.Entry entry : buckets.entrySet()) {
            List sameTermBuckets = (List)entry.getValue();
            Object b = ((Bucket)sameTermBuckets.get(0)).reduce(sameTermBuckets, reduceContext);
            ((Bucket)b).updateScore(significanceHeuristic);
            if (!(((Bucket)b).score > 0.0 && ((Bucket)b).subsetDf >= this.minDocCount) && reduceContext.isFinalReduce()) continue;
            ordered.insertWithOverflow(b);
        }
        Bucket[] list = this.createBucketsArray(ordered.size());
        int n = ordered.size() - 1;
        while (var12_17 >= 0) {
            list[var12_17] = (Bucket)ordered.pop();
            --var12_17;
        }
        return this.create(globalSubsetSize, globalSupersetSize, Arrays.asList(list));
    }

    protected abstract A create(long var1, long var3, List<B> var5);

    protected abstract B[] createBucketsArray(int var1);

    protected abstract long getSubsetSize();

    protected abstract long getSupersetSize();

    protected abstract SignificanceHeuristic getSignificanceHeuristic();

    public static abstract class Bucket<B extends Bucket<B>>
    extends SignificantTerms.Bucket {
        long bucketOrd;
        protected InternalAggregations aggregations;
        double score;
        final transient DocValueFormat format;

        protected Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations, DocValueFormat format) {
            super(subsetDf, subsetSize, supersetDf, supersetSize);
            this.aggregations = aggregations;
            this.format = format;
        }

        protected Bucket(StreamInput in, long subsetSize, long supersetSize, DocValueFormat format) {
            super(in, subsetSize, supersetSize);
            this.format = format;
        }

        @Override
        public long getSubsetDf() {
            return this.subsetDf;
        }

        @Override
        public long getSupersetDf() {
            return this.supersetDf;
        }

        @Override
        public long getSupersetSize() {
            return this.supersetSize;
        }

        @Override
        public long getSubsetSize() {
            return this.subsetSize;
        }

        public void updateScore(SignificanceHeuristic significanceHeuristic) {
            this.score = significanceHeuristic.getScore(this.subsetDf, this.subsetSize, this.supersetDf, this.supersetSize);
        }

        @Override
        public long getDocCount() {
            return this.subsetDf;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public B reduce(List<B> buckets, InternalAggregation.ReduceContext context) {
            long subsetDf = 0L;
            long supersetDf = 0L;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            for (Bucket bucket : buckets) {
                subsetDf += bucket.subsetDf;
                supersetDf += bucket.supersetDf;
                aggregationsList.add(bucket.aggregations);
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
            return this.newBucket(subsetDf, this.subsetSize, supersetDf, this.supersetSize, aggs);
        }

        abstract B newBucket(long var1, long var3, long var5, long var7, InternalAggregations var9);

        @Override
        public double getSignificanceScore() {
            return this.score;
        }

        @FunctionalInterface
        public static interface Reader<B extends Bucket<B>> {
            public B read(StreamInput var1, long var2, long var4, DocValueFormat var6) throws IOException;
        }
    }
}

